/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Framing;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;

public class RowsFraming
implements Framing {
    private final FrameInfo frameInfo;
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;

    public RowsFraming(FrameInfo frameInfo, int partitionStart, int partitionEnd, PagesIndex pagesIndex) {
        Preconditions.checkArgument((frameInfo.getType() == WindowFrameType.ROWS ? 1 : 0) != 0, (String)"Frame must be of type ROWS, actual: %s", (Object)((Object)frameInfo.getType()));
        this.frameInfo = frameInfo;
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
    }

    @Override
    public Framing.Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int rowPosition = currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        if (this.emptyFrame(this.frameInfo, rowPosition, endPosition)) {
            return new Framing.Range(-1, -1);
        }
        int frameStart = this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING ? 0 : (this.frameInfo.getStartType() == FrameBoundType.PRECEDING ? RowsFraming.preceding(rowPosition, this.getValue(this.frameInfo.getStartChannel(), currentPosition)) : (this.frameInfo.getStartType() == FrameBoundType.FOLLOWING ? RowsFraming.following(rowPosition, endPosition, this.getValue(this.frameInfo.getStartChannel(), currentPosition)) : rowPosition));
        int frameEnd = this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING ? endPosition : (this.frameInfo.getEndType() == FrameBoundType.PRECEDING ? RowsFraming.preceding(rowPosition, this.getValue(this.frameInfo.getEndChannel(), currentPosition)) : (this.frameInfo.getEndType() == FrameBoundType.FOLLOWING ? RowsFraming.following(rowPosition, endPosition, this.getValue(this.frameInfo.getEndChannel(), currentPosition)) : rowPosition));
        return new Framing.Range(frameStart, frameEnd);
    }

    private boolean emptyFrame(FrameInfo frameInfo, int rowPosition, int endPosition) {
        FrameBoundType startType = frameInfo.getStartType();
        FrameBoundType endType = frameInfo.getEndType();
        int positions = endPosition - rowPosition;
        if (startType == FrameBoundType.UNBOUNDED_PRECEDING && endType == FrameBoundType.PRECEDING) {
            return this.getValue(frameInfo.getEndChannel(), 0) > (long)rowPosition;
        }
        if (startType == FrameBoundType.FOLLOWING && endType == FrameBoundType.UNBOUNDED_FOLLOWING) {
            return this.getValue(frameInfo.getStartChannel(), 0) > (long)positions;
        }
        if (startType != endType) {
            return false;
        }
        FrameBoundType type = frameInfo.getStartType();
        if (type != FrameBoundType.PRECEDING && type != FrameBoundType.FOLLOWING) {
            return false;
        }
        long start = this.getValue(frameInfo.getStartChannel(), 0);
        long end = this.getValue(frameInfo.getEndChannel(), 0);
        if (type == FrameBoundType.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        return start > end || start > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Math.toIntExact((long)rowPosition - value);
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Math.toIntExact((long)rowPosition + value);
    }

    private long getValue(int channel, int currentPosition) {
        Preconditions.checkState((!this.pagesIndex.isNull(channel, currentPosition) ? 1 : 0) != 0, (Object)"Window frame offset must not be null");
        long value = this.pagesIndex.getLong(channel, currentPosition);
        Preconditions.checkState((value >= 0L ? 1 : 0) != 0, (Object)"Window frame offset must not be negative");
        return value;
    }
}

