/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.trino.operator.project.PageProjection;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.operator.window.pattern.PhysicalValueAccessor;
import io.trino.operator.window.pattern.ProjectingPagesWindowIndex;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BooleanType;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class LabelEvaluator {
    private final long matchNumber;
    private final int patternStart;
    private final int partitionStart;
    private final int searchStart;
    private final int searchEnd;
    private final List<Evaluation> evaluations;
    private final ProjectingPagesWindowIndex windowIndex;

    public LabelEvaluator(long matchNumber, int patternStart, int partitionStart, int searchStart, int searchEnd, List<Evaluation> evaluations, ProjectingPagesWindowIndex windowIndex) {
        this.matchNumber = matchNumber;
        this.patternStart = patternStart;
        this.partitionStart = partitionStart;
        this.searchStart = searchStart;
        this.searchEnd = searchEnd;
        this.evaluations = Objects.requireNonNull(evaluations, "evaluations is null");
        this.windowIndex = Objects.requireNonNull(windowIndex, "windowIndex is null");
    }

    public int getInputLength() {
        return this.searchEnd - this.patternStart;
    }

    public boolean isMatchingAtPartitionStart() {
        return this.patternStart == this.partitionStart;
    }

    public boolean evaluateLabel(ArrayView matchedLabels, MatchAggregation[] aggregations) {
        int label = matchedLabels.get(matchedLabels.length() - 1);
        Evaluation evaluation = this.evaluations.get(label);
        return evaluation.test(matchedLabels, aggregations, this.partitionStart, this.searchStart, this.searchEnd, this.patternStart, this.matchNumber, this.windowIndex);
    }

    public static class Evaluation {
        private final PageProjection projection;
        private final List<PhysicalValueAccessor> expectedLayout;
        private final Block[] nulls;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public Evaluation(PageProjection projection, List<PhysicalValueAccessor> expectedLayout, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.nulls = MeasureComputation.precomputeNulls(expectedLayout);
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public List<PhysicalValueAccessor> getExpectedLayout() {
            return this.expectedLayout;
        }

        public boolean test(ArrayView matchedLabels, MatchAggregation[] aggregations, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, ProjectingPagesWindowIndex windowIndex) {
            int currentRow = patternStart + matchedLabels.length() - 1;
            Block result = MeasureComputation.compute(currentRow, matchedLabels, aggregations, partitionStart, searchStart, searchEnd, patternStart, matchNumber, windowIndex, this.projection, this.expectedLayout, this.nulls, this.labelNames, this.session);
            return BooleanType.BOOLEAN.getBoolean(result, 0);
        }
    }

    public static class EvaluationSupplier {
        private final Supplier<PageProjection> projection;
        private final List<PhysicalValueAccessor> expectedLayout;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public EvaluationSupplier(Supplier<PageProjection> projection, List<PhysicalValueAccessor> expectedLayout, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Evaluation get() {
            return new Evaluation(this.projection.get(), this.expectedLayout, this.labelNames, this.session);
        }
    }
}

