/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.trino.execution.QueryManager;
import io.trino.execution.resourcegroups.NoOpResourceGroupManager;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.failuredetector.FailureDetector;
import io.trino.failuredetector.NoOpFailureDetector;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.WorkerLanguageFunctionProvider;
import io.trino.server.NoOpSessionSupplier;
import io.trino.server.SessionSupplier;
import io.trino.server.ui.NoWebUiAuthenticationFilter;
import io.trino.server.ui.WebUiAuthenticationFilter;

public class WorkerModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(SessionSupplier.class).to(NoOpSessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(ResourceGroupManager.class).to(NoOpResourceGroupManager.class).in(Scopes.SINGLETON);
        binder.bind(FailureDetector.class).to(NoOpFailureDetector.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).toInstance((Object)((QueryManager)Reflection.newProxy(QueryManager.class, (proxy, method, args) -> {
            throw new UnsupportedOperationException();
        })));
        binder.bind(WorkerLanguageFunctionProvider.class).in(Scopes.SINGLETON);
        binder.bind(LanguageFunctionProvider.class).to(WorkerLanguageFunctionProvider.class).in(Scopes.SINGLETON);
        binder.bind(WebUiAuthenticationFilter.class).to(NoWebUiAuthenticationFilter.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }
}

