/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import io.trino.Session;
import io.trino.client.QueryData;
import io.trino.server.ExternalUriInfo;
import io.trino.server.protocol.JsonBytesQueryData;
import io.trino.server.protocol.JsonEncodingUtils;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.spooling.QueryDataProducer;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonBytesQueryDataProducer
implements QueryDataProducer {
    private JsonEncodingUtils.TypeEncoder[] typeEncoders;
    private int[] sourcePageChannels;

    @Override
    public QueryData produce(ExternalUriInfo uriInfo, Session session, QueryResultRows rows, Consumer<TrinoException> throwableConsumer) {
        if (rows.isEmpty()) {
            return null;
        }
        List<OutputColumn> columns = rows.getOutputColumns().orElseThrow(() -> new IllegalStateException("Data present without columns"));
        if (this.typeEncoders == null) {
            this.typeEncoders = JsonEncodingUtils.createTypeEncoders(session, columns);
            this.sourcePageChannels = Objects.requireNonNull(columns, "columns is null").stream().mapToInt(OutputColumn::sourcePageChannel).toArray();
        }
        return new JsonBytesQueryData(session.toConnectorSession(), throwableConsumer, this.typeEncoders, this.sourcePageChannels, rows.getPages());
    }
}

