/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.QueryDataEncoders;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PreferredQueryDataEncoderSelector
implements QueryDataEncoder.EncoderSelector {
    private final Logger log = Logger.get(PreferredQueryDataEncoderSelector.class);
    private final QueryDataEncoders encoders;

    @Inject
    public PreferredQueryDataEncoderSelector(QueryDataEncoders encoders) {
        this.encoders = Objects.requireNonNull(encoders, "encoders is null");
    }

    @Override
    public Optional<QueryDataEncoder.Factory> select(List<String> encodings) {
        for (String encoding : encodings) {
            if (!this.encoders.exists(encoding)) continue;
            return Optional.of(this.encoders.get(encoding));
        }
        this.log.warn("Requested one of the spooled encodings: %s, but these are only available: %s", new Object[]{encodings, this.encoders.getAvailableEncodings()});
        return Optional.empty();
    }
}

