/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.trino.util.Ciphers;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SpoolingConfig {
    private Optional<SecretKey> sharedSecretKey = Optional.empty();
    private SegmentRetrievalMode retrievalMode = SegmentRetrievalMode.STORAGE;
    private boolean inliningEnabled = true;
    private long inliningMaxRows = 1000L;
    private DataSize inliningMaxSize = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize initialSegmentSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maximumSegmentSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    public Optional<SecretKey> getSharedSecretKey() {
        return this.sharedSecretKey;
    }

    @ConfigDescription(value="256 bit, base64-encoded secret key used to secure segment identifiers")
    @Config(value="protocol.spooling.shared-secret-key")
    @ConfigSecuritySensitive
    public SpoolingConfig setSharedSecretKey(String sharedEncryptionKey) {
        this.sharedSecretKey = Optional.ofNullable(sharedEncryptionKey).map(value -> new SecretKeySpec(Base64.getDecoder().decode((String)value), "AES"));
        return this;
    }

    public SegmentRetrievalMode getRetrievalMode() {
        return this.retrievalMode;
    }

    @Config(value="protocol.spooling.retrieval-mode")
    @ConfigDescription(value="Determines how the client will retrieve the segment")
    public SpoolingConfig setRetrievalMode(SegmentRetrievalMode retrievalMode) {
        this.retrievalMode = retrievalMode;
        return this;
    }

    @MinDataSize(value="1kB")
    @MaxDataSize(value="128MB")
    public @MinDataSize(value="1kB") @MaxDataSize(value="128MB") DataSize getInitialSegmentSize() {
        return this.initialSegmentSize;
    }

    @Config(value="protocol.spooling.initial-segment-size")
    @ConfigDescription(value="Initial size of the spooled segments in bytes")
    public SpoolingConfig setInitialSegmentSize(DataSize initialSegmentSize) {
        this.initialSegmentSize = initialSegmentSize;
        return this;
    }

    @MinDataSize(value="1kB")
    @MaxDataSize(value="128MB")
    public @MinDataSize(value="1kB") @MaxDataSize(value="128MB") DataSize getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    @LegacyConfig(value={"protocol.spooling.maximum-segment-size"})
    @Config(value="protocol.spooling.max-segment-size")
    @ConfigDescription(value="Maximum size of the spooled segments in bytes")
    public SpoolingConfig setMaximumSegmentSize(DataSize maximumSegmentSize) {
        this.maximumSegmentSize = maximumSegmentSize;
        return this;
    }

    public boolean isInliningEnabled() {
        return this.inliningEnabled;
    }

    @ConfigDescription(value="Allow spooling protocol to inline data")
    @Config(value="protocol.spooling.inlining.enabled")
    public SpoolingConfig setInliningEnabled(boolean inliningEnabled) {
        this.inliningEnabled = inliningEnabled;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000000L)
    public @Min(value=1L) @Max(value=1000000L) long getInliningMaxRows() {
        return this.inliningMaxRows;
    }

    @Config(value="protocol.spooling.inlining.max-rows")
    @ConfigDescription(value="Maximum number of rows that are allowed to be inlined per worker")
    public SpoolingConfig setInliningMaxRows(long inliningMaxRows) {
        this.inliningMaxRows = inliningMaxRows;
        return this;
    }

    @MinDataSize(value="1kB")
    @MaxDataSize(value="1MB")
    public @MinDataSize(value="1kB") @MaxDataSize(value="1MB") DataSize getInliningMaxSize() {
        return this.inliningMaxSize;
    }

    @Config(value="protocol.spooling.inlining.max-size")
    @ConfigDescription(value="Maximum size of rows that are allowed to be inlined per worker")
    public SpoolingConfig setInliningMaxSize(DataSize inliningMaxSize) {
        this.inliningMaxSize = inliningMaxSize;
        return this;
    }

    @AssertTrue(message="protocol.spooling.shared-secret-key must be 256 bits long")
    public @AssertTrue(message="protocol.spooling.shared-secret-key must be 256 bits long") boolean isSharedEncryptionKeyAes256() {
        return this.sharedSecretKey.map(Ciphers::is256BitSecretKeySpec).orElse(true);
    }

    @AssertTrue(message="protocol.spooling.initial-segment-size must be smaller than protocol.spooling.maximum-segment-size")
    public @AssertTrue(message="protocol.spooling.initial-segment-size must be smaller than protocol.spooling.maximum-segment-size") boolean areSegmentSizesCorrect() {
        return this.getInitialSegmentSize().compareTo(this.getMaximumSegmentSize()) < 0;
    }

    @AssertTrue(message="protocol.spooling.shared-secret-key must be set")
    public @AssertTrue(message="protocol.spooling.shared-secret-key must be set") boolean isSharedEncryptionKeySet() {
        return this.sharedSecretKey.isPresent();
    }

    public static enum SegmentRetrievalMode {
        STORAGE,
        COORDINATOR_STORAGE_REDIRECT,
        COORDINATOR_PROXY,
        WORKER_PROXY;

    }
}

