/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.Inject;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.TaskId;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.ForWorkerInfo;
import io.trino.server.GoneException;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.Node;
import io.trino.spi.QueryId;
import io.trino.spi.security.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Path(value="/ui/api/worker")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
public class WorkerResource {
    private final DispatchManager dispatchManager;
    private final InternalNodeManager nodeManager;
    private final AccessControl accessControl;
    private final HttpClient httpClient;
    private final HttpRequestSessionContextFactory sessionContextFactory;

    @Inject
    public WorkerResource(DispatchManager dispatchManager, InternalNodeManager nodeManager, AccessControl accessControl, @ForWorkerInfo HttpClient httpClient, HttpRequestSessionContextFactory sessionContextFactory) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
    }

    @GET
    @Path(value="{nodeId}/status")
    public jakarta.ws.rs.core.Response getStatus(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/status");
    }

    @GET
    @Path(value="{nodeId}/thread")
    public jakarta.ws.rs.core.Response getThreads(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/thread");
    }

    @GET
    @Path(value="{nodeId}/task/{taskId}")
    public jakarta.ws.rs.core.Response getThreads(@PathParam(value="taskId") TaskId task, @PathParam(value="nodeId") String nodeId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        QueryId queryId = task.getQueryId();
        Optional<QueryInfo> queryInfo = this.dispatchManager.getFullQueryInfo(queryId);
        if (queryInfo.isPresent()) {
            try {
                AccessControlUtil.checkCanViewQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders), queryInfo.get().getSession().toIdentity(), this.accessControl);
                return this.proxyJsonResponse(nodeId, "v1/task/" + String.valueOf(task));
            }
            catch (AccessDeniedException e) {
                throw new ForbiddenException();
            }
        }
        throw new GoneException();
    }

    @GET
    public jakarta.ws.rs.core.Response getWorkerList() {
        JsonNodeInfo jsonNode;
        Set<InternalNode> activeNodes = this.nodeManager.getAllNodes().getActiveNodes();
        Set<InternalNode> inactiveNodes = this.nodeManager.getAllNodes().getInactiveNodes();
        HashSet<JsonNodeInfo> jsonNodes = new HashSet<JsonNodeInfo>();
        for (Node node : activeNodes) {
            jsonNode = new JsonNodeInfo(node.getNodeIdentifier(), node.getHostAndPort().getHostText(), node.getVersion(), node.isCoordinator(), NodeState.ACTIVE.toString().toLowerCase(Locale.ENGLISH));
            jsonNodes.add(jsonNode);
        }
        for (Node node : inactiveNodes) {
            jsonNode = new JsonNodeInfo(node.getNodeIdentifier(), node.getHostAndPort().getHostText(), node.getVersion(), node.isCoordinator(), NodeState.INACTIVE.toString().toLowerCase(Locale.ENGLISH));
            jsonNodes.add(jsonNode);
        }
        return jakarta.ws.rs.core.Response.ok().entity(jsonNodes).build();
    }

    private jakarta.ws.rs.core.Response proxyJsonResponse(String nodeId, String workerPath) {
        Set<InternalNode> nodes = this.nodeManager.getNodes(NodeState.ACTIVE);
        InternalNode node = nodes.stream().filter(n -> n.getNodeIdentifier().equals(nodeId)).findFirst().orElseThrow(NotFoundException::new);
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath(workerPath).build()).build();
        byte[] responseStream = (byte[])this.httpClient.execute(request, (ResponseHandler)new StreamingJsonResponseHandler());
        return jakarta.ws.rs.core.Response.ok((Object)responseStream, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static class JsonNodeInfo {
        private final String nodeId;
        private final String nodeIp;
        private final String nodeVersion;
        private final boolean coordinator;
        private final String state;

        @JsonCreator
        public JsonNodeInfo(@JsonProperty(value="nodeId") String nodeId, @JsonProperty(value="nodeIp") String nodeIp, @JsonProperty(value="nodeVersion") String nodeVersion, @JsonProperty(value="coordinator") boolean coordinator, @JsonProperty(value="state") String state) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.nodeIp = Objects.requireNonNull(nodeIp, "nodeIp is null");
            this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
            this.coordinator = coordinator;
            this.state = Objects.requireNonNull(state, "state is null");
        }

        @JsonProperty
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonProperty
        public String getNodeIp() {
            return this.nodeIp;
        }

        @JsonProperty
        public String getNodeVersion() {
            return this.nodeVersion;
        }

        @JsonProperty
        public boolean getCoordinator() {
            return this.coordinator;
        }

        @JsonProperty
        public String getState() {
            return this.state;
        }
    }

    private static class StreamingJsonResponseHandler
    implements ResponseHandler<byte[], RuntimeException> {
        private StreamingJsonResponseHandler() {
        }

        public byte[] handleException(Request request, Exception exception) {
            throw new RuntimeException("Request to worker failed", exception);
        }

        public byte[] handle(Request request, Response response) {
            try {
                if (!"application/json".equals(response.getHeader("Content-Type"))) {
                    throw new RuntimeException("Response received was not of type application/json");
                }
                return response.getInputStream().readAllBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read response from worker", e);
            }
        }
    }
}

