/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.spi.connector.CatalogHandle;
import io.trino.split.SplitSource;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public CatalogHandle getCatalogHandle() {
        return this.splitSource.getCatalogHandle();
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(int maxSize) {
        ListenableFuture<SplitSource.SplitBatch> batch = this.splitSource.getNextBatch(maxSize);
        return Futures.transform(batch, splitBatch -> new SplitSource.SplitBatch((List)splitBatch.getSplits().stream().filter(input -> ThreadLocalRandom.current().nextDouble() < this.sampleRatio).collect(ImmutableList.toImmutableList()), splitBatch.isLastBatch()), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }

    @Override
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        this.splitSource.getTableExecuteSplitsInfo().ifPresent(splitInfo -> {
            throw new IllegalStateException("Cannot use SampledSplitSource with SplitSource which returns non-empty TableExecuteSplitsInfo=" + String.valueOf(splitInfo));
        });
        return Optional.empty();
    }
}

