/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record IsNull(Expression value) implements Expression
{
    public IsNull {
        Objects.requireNonNull(value, "value is null");
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitIsNull(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public String toString() {
        return "$is_null(%s)".formatted(this.value);
    }
}

