/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SimplifyCountOverConstant
implements Rule<AggregationNode> {
    private static final CatalogSchemaFunctionName COUNT_NAME = GlobalFunctionCatalog.builtinFunctionName("count");
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final PlannerContext plannerContext;

    public SimplifyCountOverConstant(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        boolean changed = false;
        LinkedHashMap<Symbol, AggregationNode.Aggregation> aggregations = new LinkedHashMap<Symbol, AggregationNode.Aggregation>(parent.getAggregations());
        ResolvedFunction countFunction = this.plannerContext.getMetadata().resolveBuiltinFunction("count", (List<TypeSignatureProvider>)ImmutableList.of());
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : parent.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!this.isCountOverConstant(aggregation, child.getAssignments())) continue;
            changed = true;
            aggregations.put(symbol, new AggregationNode.Aggregation(countFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), aggregation.getMask()));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(AggregationNode.builderFrom(parent).setSource(child).setAggregations(aggregations).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build());
    }

    private boolean isCountOverConstant(AggregationNode.Aggregation aggregation, Assignments inputs) {
        Constant constant;
        BoundSignature signature = aggregation.getResolvedFunction().signature();
        if (!signature.getName().equals((Object)COUNT_NAME) || signature.getArgumentTypes().size() != 1) {
            return false;
        }
        if (aggregation.isDistinct()) {
            return false;
        }
        Expression argument = aggregation.getArguments().get(0);
        if (argument instanceof Reference) {
            argument = inputs.get(Symbol.from(argument));
        }
        return argument instanceof Constant && (constant = (Constant)argument).value() != null;
    }
}

