/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.Range;
import java.util.Objects;

public record Cardinality(Range<Long> cardinalityRange) {
    public Cardinality {
        Objects.requireNonNull(cardinalityRange, "cardinalityRange is null");
    }

    public boolean isEmpty() {
        return this.isAtMost(0L);
    }

    public boolean isScalar() {
        return Range.singleton((Comparable)Long.valueOf(1L)).encloses(this.cardinalityRange);
    }

    public boolean isAtLeastScalar() {
        return this.isAtLeast(1L);
    }

    public boolean isAtMostScalar() {
        return this.isAtMost(1L);
    }

    public boolean isAtLeast(long minCardinality) {
        return Range.atLeast((Comparable)Long.valueOf(minCardinality)).encloses(this.cardinalityRange);
    }

    public boolean isAtMost(long maxCardinality) {
        return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(maxCardinality)).encloses(this.cardinalityRange);
    }
}

