/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProviderConfig;
import io.trino.spi.HostAddress;
import io.trino.spi.NodeManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ishugaliy.allgood.consistent.hash.ConsistentHash;
import org.ishugaliy.allgood.consistent.hash.HashRing;
import org.ishugaliy.allgood.consistent.hash.hasher.DefaultHasher;
import org.ishugaliy.allgood.consistent.hash.hasher.Hasher;
import org.ishugaliy.allgood.consistent.hash.node.Node;

public class ConsistentHashingHostAddressProvider
implements CachingHostAddressProvider {
    private static final Logger log = Logger.get(ConsistentHashingHostAddressProvider.class);
    private final NodeManager nodeManager;
    private final ScheduledExecutorService hashRingUpdater = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"hash-ring-refresher-%s"));
    private final int replicationFactor;
    private final Comparator<HostAddress> hostAddressComparator = Comparator.comparing(HostAddress::getHostText).thenComparing(HostAddress::getPort);
    private final ConsistentHash<TrinoNode> consistentHashRing = HashRing.newBuilder().hasher((Hasher)DefaultHasher.METRO_HASH).build();

    @Inject
    public ConsistentHashingHostAddressProvider(NodeManager nodeManager, ConsistentHashingHostAddressProviderConfig configuration) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.replicationFactor = configuration.getPreferredHostsCount();
    }

    @Override
    public List<HostAddress> getHosts(String splitPath, List<HostAddress> defaultAddresses) {
        return (List)this.consistentHashRing.locate(splitPath, this.replicationFactor).stream().map(TrinoNode::getHostAndPort).sorted(this.hostAddressComparator).collect(ImmutableList.toImmutableList());
    }

    @PostConstruct
    public void startRefreshingHashRing() {
        this.hashRingUpdater.scheduleWithFixedDelay(this::refreshHashRing, 5L, 5L, TimeUnit.SECONDS);
        this.refreshHashRing();
    }

    @PreDestroy
    public void destroy() {
        this.hashRingUpdater.shutdownNow();
    }

    @VisibleForTesting
    synchronized void refreshHashRing() {
        try {
            ImmutableSet trinoNodes = (ImmutableSet)this.nodeManager.getWorkerNodes().stream().map(TrinoNode::of).collect(ImmutableSet.toImmutableSet());
            Set hashRingNodes = this.consistentHashRing.getNodes();
            Sets.SetView removedNodes = Sets.difference((Set)hashRingNodes, (Set)trinoNodes);
            Sets.SetView newNodes = Sets.difference((Set)trinoNodes, (Set)hashRingNodes);
            if (!newNodes.isEmpty()) {
                this.consistentHashRing.addAll((Collection)newNodes);
            }
            if (!removedNodes.isEmpty()) {
                removedNodes.forEach(arg_0 -> this.consistentHashRing.remove(arg_0));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error refreshing hash ring");
        }
    }

    private record TrinoNode(String nodeIdentifier, HostAddress hostAndPort) implements Node
    {
        public static TrinoNode of(io.trino.spi.Node node) {
            return new TrinoNode(node.getNodeIdentifier(), node.getHostAndPort());
        }

        public HostAddress getHostAndPort() {
            return this.hostAndPort;
        }

        public String getKey() {
            return this.nodeIdentifier;
        }
    }
}

