/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.accounting;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.spi.accounting.ThreadAccountantFactory;
import org.apache.pinot.spi.accounting.ThreadResourceUsageAccountant;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.trace.Tracing;

public class HeapUsagePublishingAccountantFactory
implements ThreadAccountantFactory {
    public ThreadResourceUsageAccountant init(PinotConfiguration config, String instanceId) {
        int period = config.getProperty("accounting.heap.usage.publishing.period.ms", 5000);
        return new HeapUsagePublishingResourceUsageAccountant(period);
    }

    public static class HeapUsagePublishingResourceUsageAccountant
    extends Tracing.DefaultThreadResourceUsageAccountant {
        static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
        private final Timer _timer;
        private final int _period;

        public HeapUsagePublishingResourceUsageAccountant(int period) {
            this._period = period;
            this._timer = new Timer("HeapUsagePublishingAccountant", true);
        }

        public void publishHeapUsageMetrics() {
            ServerMetrics.get().setValueOfGlobalGauge((AbstractMetrics.Gauge)ServerGauge.JVM_HEAP_USED_BYTES, MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed());
        }

        public void startWatcherTask() {
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.publishHeapUsageMetrics();
                }
            }, this._period, (long)this._period);
        }
    }
}

