/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.accounting;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.accounting.CPUMemThreadLevelAccountingObjects;
import org.apache.pinot.spi.accounting.ThreadAccountantFactory;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageAccountant;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.config.instance.InstanceType;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.PinotMetricUtils;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerQueryCPUMemAccountantFactory
implements ThreadAccountantFactory {
    public ThreadResourceUsageAccountant init(PinotConfiguration config, String instanceId) {
        return new PerQueryCPUMemResourceUsageAccountant(config, instanceId);
    }

    public static class PerQueryCPUMemResourceUsageAccountant
    extends Tracing.DefaultThreadResourceUsageAccountant {
        static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
        private static final Logger LOGGER = LoggerFactory.getLogger(PerQueryCPUMemResourceUsageAccountant.class);
        private static final boolean IS_DEBUG_MODE_ENABLED = LOGGER.isDebugEnabled();
        private static final String ACCOUNTANT_TASK_NAME = "CPUMemThreadAccountant";
        private static final int ACCOUNTANT_PRIORITY = 4;
        private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setPriority(4);
            thread.setDaemon(true);
            thread.setName(ACCOUNTANT_TASK_NAME);
            return thread;
        });
        private final PinotConfiguration _config;
        private final ConcurrentHashMap<Thread, CPUMemThreadLevelAccountingObjects.ThreadEntry> _threadEntriesMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, Long> _concurrentTaskCPUStatsAggregator = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, Long> _concurrentTaskMemStatsAggregator = new ConcurrentHashMap();
        private final HashMap<String, Long> _finishedTaskCPUStatsAggregator = new HashMap();
        private final HashMap<String, Long> _finishedTaskMemStatsAggregator = new HashMap();
        private final ThreadLocal<CPUMemThreadLevelAccountingObjects.ThreadEntry> _threadLocalEntry = ThreadLocal.withInitial(() -> {
            CPUMemThreadLevelAccountingObjects.ThreadEntry ret = new CPUMemThreadLevelAccountingObjects.ThreadEntry();
            this._threadEntriesMap.put(Thread.currentThread(), ret);
            LOGGER.info("Adding thread to _threadLocalEntry: {}", (Object)Thread.currentThread().getName());
            return ret;
        });
        private final ThreadLocal<ThreadResourceUsageProvider> _threadResourceUsageProvider;
        private final boolean _isThreadCPUSamplingEnabled;
        private final boolean _isThreadMemorySamplingEnabled;
        private final Set<String> _inactiveQuery;
        private final WatcherTask _watcherTask;
        private final String _instanceId;

        public PerQueryCPUMemResourceUsageAccountant(PinotConfiguration config, String instanceId) {
            LOGGER.info("Initializing PerQueryCPUMemResourceUsageAccountant");
            this._config = config;
            this._instanceId = instanceId;
            boolean threadCpuTimeMeasurementEnabled = ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled();
            boolean threadMemoryMeasurementEnabled = ThreadResourceUsageProvider.isThreadMemoryMeasurementEnabled();
            LOGGER.info("threadCpuTimeMeasurementEnabled: {}, threadMemoryMeasurementEnabled: {}", (Object)threadCpuTimeMeasurementEnabled, (Object)threadMemoryMeasurementEnabled);
            boolean cpuSamplingConfig = config.getProperty("accounting.enable.thread.cpu.sampling", CommonConstants.Accounting.DEFAULT_ENABLE_THREAD_CPU_SAMPLING.booleanValue());
            boolean memorySamplingConfig = config.getProperty("accounting.enable.thread.memory.sampling", CommonConstants.Accounting.DEFAULT_ENABLE_THREAD_MEMORY_SAMPLING.booleanValue());
            LOGGER.info("cpuSamplingConfig: {}, memorySamplingConfig: {}", (Object)cpuSamplingConfig, (Object)memorySamplingConfig);
            this._isThreadCPUSamplingEnabled = cpuSamplingConfig && threadCpuTimeMeasurementEnabled;
            this._isThreadMemorySamplingEnabled = memorySamplingConfig && threadMemoryMeasurementEnabled;
            LOGGER.info("_isThreadCPUSamplingEnabled: {}, _isThreadMemorySamplingEnabled: {}", (Object)this._isThreadCPUSamplingEnabled, (Object)this._isThreadMemorySamplingEnabled);
            this._threadResourceUsageProvider = new ThreadLocal();
            this._inactiveQuery = new HashSet<String>();
            this._watcherTask = new WatcherTask();
        }

        public void sampleUsage() {
            this.sampleThreadBytesAllocated();
            this.sampleThreadCPUTime();
        }

        public int getEntryCount() {
            return this._threadEntriesMap.size();
        }

        public void updateQueryUsageConcurrently(String queryId) {
            if (this._isThreadCPUSamplingEnabled) {
                long cpuUsageNS = this.getThreadResourceUsageProvider().getThreadTimeNs();
                this._concurrentTaskCPUStatsAggregator.compute(queryId, (key, value) -> value == null ? cpuUsageNS : value + cpuUsageNS);
            }
            if (this._isThreadMemorySamplingEnabled) {
                long memoryAllocatedBytes = this.getThreadResourceUsageProvider().getThreadAllocatedBytes();
                this._concurrentTaskMemStatsAggregator.compute(queryId, (key, value) -> value == null ? memoryAllocatedBytes : value + memoryAllocatedBytes);
            }
        }

        public void sampleThreadCPUTime() {
            if (this._isThreadCPUSamplingEnabled) {
                this._threadLocalEntry.get()._currentThreadCPUTimeSampleMS = this.getThreadResourceUsageProvider().getThreadTimeNs();
            }
        }

        public void sampleThreadBytesAllocated() {
            if (this._isThreadMemorySamplingEnabled) {
                this._threadLocalEntry.get()._currentThreadMemoryAllocationSampleBytes = this.getThreadResourceUsageProvider().getThreadAllocatedBytes();
            }
        }

        private ThreadResourceUsageProvider getThreadResourceUsageProvider() {
            return this._threadResourceUsageProvider.get();
        }

        public void setThreadResourceUsageProvider(ThreadResourceUsageProvider threadResourceUsageProvider) {
            this._threadResourceUsageProvider.set(threadResourceUsageProvider);
        }

        public void createExecutionContextInner(@Nullable String queryId, int taskId, @Nullable ThreadExecutionContext parentContext) {
            this._threadLocalEntry.get()._errorStatus.set(null);
            if (parentContext == null) {
                assert (queryId != null);
                this._threadLocalEntry.get().setThreadTaskStatus(queryId, -1, Thread.currentThread());
            } else {
                this._threadLocalEntry.get().setThreadTaskStatus(parentContext.getQueryId(), taskId, parentContext.getAnchorThread());
            }
        }

        public ThreadExecutionContext getThreadExecutionContext() {
            return this._threadLocalEntry.get().getCurrentThreadTaskStatus();
        }

        public void clear() {
            CPUMemThreadLevelAccountingObjects.ThreadEntry threadEntry = this._threadLocalEntry.get();
            threadEntry.setToIdle();
            this._threadResourceUsageProvider.set(null);
            super.clear();
        }

        public void startWatcherTask() {
            EXECUTOR_SERVICE.submit(this._watcherTask);
        }

        public void cleanInactive() {
            for (String inactiveQueryId : this._inactiveQuery) {
                if (this._isThreadCPUSamplingEnabled) {
                    this._finishedTaskCPUStatsAggregator.remove(inactiveQueryId);
                    this._concurrentTaskCPUStatsAggregator.remove(inactiveQueryId);
                }
                if (!this._isThreadMemorySamplingEnabled) continue;
                this._finishedTaskMemStatsAggregator.remove(inactiveQueryId);
                this._concurrentTaskMemStatsAggregator.remove(inactiveQueryId);
            }
            this._inactiveQuery.clear();
            if (this._isThreadCPUSamplingEnabled) {
                this._inactiveQuery.addAll(this._finishedTaskCPUStatsAggregator.keySet());
                this._inactiveQuery.addAll(this._concurrentTaskCPUStatsAggregator.keySet());
            }
            if (this._isThreadMemorySamplingEnabled) {
                this._inactiveQuery.addAll(this._finishedTaskMemStatsAggregator.keySet());
                this._inactiveQuery.addAll(this._concurrentTaskMemStatsAggregator.keySet());
            }
        }

        public Map<String, AggregatedStats> aggregate(boolean isTriggered) {
            HashMap<String, AggregatedStats> ret = null;
            if (isTriggered) {
                ret = new HashMap<String, AggregatedStats>();
            }
            for (Map.Entry<Thread, CPUMemThreadLevelAccountingObjects.ThreadEntry> entry : this._threadEntriesMap.entrySet()) {
                CPUMemThreadLevelAccountingObjects.ThreadEntry threadEntry = entry.getValue();
                long currentCPUSample = this._isThreadCPUSamplingEnabled ? threadEntry._currentThreadCPUTimeSampleMS : 0L;
                long currentMemSample = this._isThreadMemorySamplingEnabled ? threadEntry._currentThreadMemoryAllocationSampleBytes : 0L;
                CPUMemThreadLevelAccountingObjects.TaskEntry currentTaskStatus = threadEntry.getCurrentThreadTaskStatus();
                Thread thread = entry.getKey();
                LOGGER.trace("tid: {}, task: {}", (Object)thread.getId(), (Object)currentTaskStatus);
                CPUMemThreadLevelAccountingObjects.TaskEntry lastQueryTask = threadEntry._previousThreadTaskStatus;
                if (currentTaskStatus != lastQueryTask) {
                    threadEntry._previousThreadTaskStatus = currentTaskStatus;
                    if (lastQueryTask != null) {
                        long lastSample;
                        String lastQueryId = lastQueryTask.getQueryId();
                        if (this._isThreadCPUSamplingEnabled) {
                            lastSample = threadEntry._previousThreadCPUTimeSampleMS;
                            this._finishedTaskCPUStatsAggregator.merge(lastQueryId, lastSample, Long::sum);
                        }
                        if (this._isThreadMemorySamplingEnabled) {
                            lastSample = threadEntry._previousThreadMemoryAllocationSampleBytes;
                            this._finishedTaskMemStatsAggregator.merge(lastQueryId, lastSample, Long::sum);
                        }
                    }
                }
                if (this._isThreadCPUSamplingEnabled) {
                    threadEntry._previousThreadCPUTimeSampleMS = currentCPUSample;
                }
                if (this._isThreadMemorySamplingEnabled) {
                    threadEntry._previousThreadMemoryAllocationSampleBytes = currentMemSample;
                }
                if (currentTaskStatus != null) {
                    String queryId = currentTaskStatus.getQueryId();
                    this._inactiveQuery.remove(queryId);
                    if (isTriggered) {
                        Thread anchorThread = currentTaskStatus.getAnchorThread();
                        boolean isAnchorThread = currentTaskStatus.isAnchorThread();
                        ret.compute(queryId, (k, v) -> v == null ? new AggregatedStats(currentCPUSample, currentMemSample, anchorThread, isAnchorThread, threadEntry._errorStatus, queryId) : v.merge(currentCPUSample, currentMemSample, isAnchorThread, threadEntry._errorStatus));
                    }
                }
                if (thread.isAlive()) continue;
                this._threadEntriesMap.remove(thread);
                LOGGER.info("Removing thread from _threadLocalEntry: {}", (Object)thread.getName());
            }
            if (isTriggered) {
                for (Map.Entry<Thread, CPUMemThreadLevelAccountingObjects.ThreadEntry> entry : ret.entrySet()) {
                    String activeQueryId = (String)((Object)entry.getKey());
                    long accumulatedCPUValue = this._isThreadCPUSamplingEnabled ? this._finishedTaskCPUStatsAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    long concurrentCPUValue = this._isThreadCPUSamplingEnabled ? this._concurrentTaskCPUStatsAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    long accumulatedMemValue = this._isThreadMemorySamplingEnabled ? this._finishedTaskMemStatsAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    long concurrentMemValue = this._isThreadMemorySamplingEnabled ? this._concurrentTaskMemStatsAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    ((AggregatedStats)((Object)entry.getValue())).merge(accumulatedCPUValue + concurrentCPUValue, accumulatedMemValue + concurrentMemValue, false, null);
                }
            }
            return ret;
        }

        public void postAggregation(Map<String, AggregatedStats> aggregatedUsagePerActiveQuery) {
        }

        public Exception getErrorStatus() {
            return this._threadLocalEntry.get()._errorStatus.getAndSet(null);
        }

        class WatcherTask
        implements Runnable {
            private final long _maxHeapSize = MEMORY_MX_BEAN.getHeapMemoryUsage().getMax();
            private final long _minMemoryFootprintForKill;
            private final long _panicLevel;
            private final long _criticalLevel;
            private final long _criticalLevelAfterGC;
            private final int _gcBackoffCount;
            private final long _alarmingLevel;
            private final int _normalSleepTime;
            private final int _gcWaitTime;
            private final int _alarmingSleepTimeDenominator;
            private final int _alarmingSleepTime;
            private final boolean _oomKillQueryEnabled;
            private final boolean _publishHeapUsageMetric;
            private final boolean _isCPUTimeBasedKillingEnabled;
            private final long _cpuTimeBasedKillingThresholdNS;
            private final boolean _isQueryKilledMetricEnabled;
            private final InstanceType _instanceType;
            private long _usedBytes;
            private int _sleepTime;
            private int _numQueriesKilledConsecutively;
            protected Map<String, AggregatedStats> _aggregatedUsagePerActiveQuery;
            private TriggeringLevel _triggeringLevel;
            private final AbstractMetrics _metrics;
            private final AbstractMetrics.Meter _queryKilledMeter;
            private final AbstractMetrics.Meter _heapMemoryCriticalExceededMeter;
            private final AbstractMetrics.Meter _heapMemoryPanicExceededMeter;
            private final AbstractMetrics.Gauge _memoryUsageGauge;

            WatcherTask() {
                this._minMemoryFootprintForKill = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.min.memory.footprint.to.kill.ratio", 0.025));
                this._panicLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.panic.heap.usage.ratio", (double)0.99f));
                this._criticalLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.critical.heap.usage.ratio", (double)0.96f));
                this._criticalLevelAfterGC = this._criticalLevel - (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.critical.heap.usage.ratio.delta.after.gc", (double)0.15f));
                this._gcBackoffCount = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.gc.backoff.count", 5);
                this._alarmingLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.alarming.usage.ratio", 0.75));
                this._normalSleepTime = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.sleep.ms", 30);
                this._gcWaitTime = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.gc.wait.time.ms", 0);
                this._alarmingSleepTimeDenominator = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.sleep.time.denominator", 3);
                this._alarmingSleepTime = this._normalSleepTime / this._alarmingSleepTimeDenominator;
                this._oomKillQueryEnabled = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.enable.killing.query", false);
                this._publishHeapUsageMetric = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.publishing.jvm.heap.usage", false);
                this._isCPUTimeBasedKillingEnabled = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.cpu.time.based.killing.enabled", false) && PerQueryCPUMemResourceUsageAccountant.this._isThreadCPUSamplingEnabled;
                this._cpuTimeBasedKillingThresholdNS = (long)PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.cpu.time.based.killing.threshold.ms", 30000) * 1000000L;
                this._isQueryKilledMetricEnabled = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.query.killed.metric.enabled", false);
                this._instanceType = InstanceType.valueOf((String)PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.instance.type", CommonConstants.Accounting.DEFAULT_CONFIG_OF_INSTANCE_TYPE.toString()));
                this._numQueriesKilledConsecutively = 0;
                switch (this._instanceType) {
                    case SERVER: {
                        this._metrics = ServerMetrics.get();
                        this._queryKilledMeter = ServerMeter.QUERIES_KILLED;
                        this._memoryUsageGauge = ServerGauge.JVM_HEAP_USED_BYTES;
                        this._heapMemoryCriticalExceededMeter = ServerMeter.HEAP_CRITICAL_LEVEL_EXCEEDED;
                        this._heapMemoryPanicExceededMeter = ServerMeter.HEAP_PANIC_LEVEL_EXCEEDED;
                        break;
                    }
                    case BROKER: {
                        this._metrics = BrokerMetrics.get();
                        this._queryKilledMeter = BrokerMeter.QUERIES_KILLED;
                        this._memoryUsageGauge = BrokerGauge.JVM_HEAP_USED_BYTES;
                        this._heapMemoryCriticalExceededMeter = BrokerMeter.HEAP_CRITICAL_LEVEL_EXCEEDED;
                        this._heapMemoryPanicExceededMeter = BrokerMeter.HEAP_PANIC_LEVEL_EXCEEDED;
                        break;
                    }
                    default: {
                        LOGGER.error("instanceType: {} not supported, using server metrics", (Object)this._instanceType);
                        this._metrics = new ServerMetrics(PinotMetricUtils.getPinotMetricsRegistry());
                        this._queryKilledMeter = ServerMeter.QUERIES_KILLED;
                        this._memoryUsageGauge = ServerGauge.JVM_HEAP_USED_BYTES;
                        this._heapMemoryCriticalExceededMeter = ServerMeter.HEAP_CRITICAL_LEVEL_EXCEEDED;
                        this._heapMemoryPanicExceededMeter = ServerMeter.HEAP_PANIC_LEVEL_EXCEEDED;
                    }
                }
            }

            @Override
            public void run() {
                LOGGER.info("Starting accountant task for PerQueryCPUMemAccountant.");
                LOGGER.info("Xmx is {}", (Object)this._maxHeapSize);
                LOGGER.info("_instanceType is {}", (Object)this._instanceType);
                LOGGER.info("_alarmingLevel of on heap memory is {}", (Object)this._alarmingLevel);
                LOGGER.info("_criticalLevel of on heap memory is {}", (Object)this._criticalLevel);
                LOGGER.info("_criticalLevelAfterGC of on heap memory is {}", (Object)this._criticalLevelAfterGC);
                LOGGER.info("_panicLevel of on heap memory is {}", (Object)this._panicLevel);
                LOGGER.info("_gcBackoffCount is {}", (Object)this._gcBackoffCount);
                LOGGER.info("_gcWaitTime is {}", (Object)this._gcWaitTime);
                LOGGER.info("_normalSleepTime is {}", (Object)this._normalSleepTime);
                LOGGER.info("_alarmingSleepTime is {}", (Object)this._alarmingSleepTime);
                LOGGER.info("_oomKillQueryEnabled: {}", (Object)this._oomKillQueryEnabled);
                LOGGER.info("_minMemoryFootprintForKill: {}", (Object)this._minMemoryFootprintForKill);
                LOGGER.info("_isCPUTimeBasedKillingEnabled: {}, _cpuTimeBasedKillingThresholdNS: {}", (Object)this._isCPUTimeBasedKillingEnabled, (Object)this._cpuTimeBasedKillingThresholdNS);
                while (true) {
                    block10: {
                        LOGGER.debug("Running timed task for PerQueryCPUMemAccountant.");
                        this._triggeringLevel = TriggeringLevel.Normal;
                        this._sleepTime = this._normalSleepTime;
                        this._aggregatedUsagePerActiveQuery = null;
                        this.collectTriggerMetrics();
                        if (!this.outOfMemoryPanicTrigger()) break block10;
                        LOGGER.debug(this._aggregatedUsagePerActiveQuery == null ? "_aggregatedUsagePerActiveQuery : null" : this._aggregatedUsagePerActiveQuery.toString());
                        LOGGER.debug("_threadEntriesMap size: {}", (Object)PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap.size());
                        if (this._publishHeapUsageMetric) {
                            this._metrics.setValueOfGlobalGauge(this._memoryUsageGauge, this._usedBytes);
                        }
                        PerQueryCPUMemResourceUsageAccountant.this.cleanInactive();
                        this.reschedule();
                        continue;
                    }
                    try {
                        this.evalTriggers();
                        this._aggregatedUsagePerActiveQuery = PerQueryCPUMemResourceUsageAccountant.this.aggregate(this._triggeringLevel.ordinal() > TriggeringLevel.Normal.ordinal());
                        PerQueryCPUMemResourceUsageAccountant.this.postAggregation(this._aggregatedUsagePerActiveQuery);
                        this.triggeredActions();
                        LOGGER.debug(this._aggregatedUsagePerActiveQuery == null ? "_aggregatedUsagePerActiveQuery : null" : this._aggregatedUsagePerActiveQuery.toString());
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("Caught exception while executing stats aggregation and query kill", (Throwable)e);
                            LOGGER.debug(this._aggregatedUsagePerActiveQuery == null ? "_aggregatedUsagePerActiveQuery : null" : this._aggregatedUsagePerActiveQuery.toString());
                        }
                        catch (Throwable throwable) {
                            LOGGER.debug(this._aggregatedUsagePerActiveQuery == null ? "_aggregatedUsagePerActiveQuery : null" : this._aggregatedUsagePerActiveQuery.toString());
                            LOGGER.debug("_threadEntriesMap size: {}", (Object)PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap.size());
                            if (this._publishHeapUsageMetric) {
                                this._metrics.setValueOfGlobalGauge(this._memoryUsageGauge, this._usedBytes);
                            }
                            PerQueryCPUMemResourceUsageAccountant.this.cleanInactive();
                            this.reschedule();
                            throw throwable;
                        }
                        LOGGER.debug("_threadEntriesMap size: {}", (Object)PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap.size());
                        if (this._publishHeapUsageMetric) {
                            this._metrics.setValueOfGlobalGauge(this._memoryUsageGauge, this._usedBytes);
                        }
                        PerQueryCPUMemResourceUsageAccountant.this.cleanInactive();
                        this.reschedule();
                        continue;
                    }
                    LOGGER.debug("_threadEntriesMap size: {}", (Object)PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap.size());
                    if (this._publishHeapUsageMetric) {
                        this._metrics.setValueOfGlobalGauge(this._memoryUsageGauge, this._usedBytes);
                    }
                    PerQueryCPUMemResourceUsageAccountant.this.cleanInactive();
                    this.reschedule();
                    continue;
                    break;
                }
            }

            private void collectTriggerMetrics() {
                this._usedBytes = MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
                LOGGER.debug("Heap used bytes {}", (Object)this._usedBytes);
            }

            private boolean outOfMemoryPanicTrigger() {
                if (this._usedBytes >= this._panicLevel) {
                    this.killAllQueries();
                    this._triggeringLevel = TriggeringLevel.HeapMemoryPanic;
                    this._metrics.addMeteredGlobalValue(this._heapMemoryPanicExceededMeter, 1L);
                    LOGGER.error("Heap used bytes {}, greater than _panicLevel {}, Killed all queries and triggered gc!", (Object)this._usedBytes, (Object)this._panicLevel);
                    PerQueryCPUMemResourceUsageAccountant.this.aggregate(false);
                    return true;
                }
                return false;
            }

            private void evalTriggers() {
                if (this._isCPUTimeBasedKillingEnabled) {
                    this._triggeringLevel = TriggeringLevel.CPUTimeBasedKilling;
                }
                if (this._usedBytes > this._criticalLevel) {
                    this._triggeringLevel = TriggeringLevel.HeapMemoryCritical;
                    this._metrics.addMeteredGlobalValue(this._heapMemoryCriticalExceededMeter, 1L);
                } else if (this._usedBytes > this._alarmingLevel) {
                    this._sleepTime = this._alarmingSleepTime;
                    this._triggeringLevel = IS_DEBUG_MODE_ENABLED && this._triggeringLevel == TriggeringLevel.Normal ? TriggeringLevel.HeapMemoryAlarmingVerbose : this._triggeringLevel;
                }
            }

            private void triggeredActions() {
                switch (this._triggeringLevel) {
                    case HeapMemoryCritical: {
                        LOGGER.warn("Heap used bytes {} exceeds critical level {}", (Object)this._usedBytes, (Object)this._criticalLevel);
                        this.killMostExpensiveQuery();
                        break;
                    }
                    case CPUTimeBasedKilling: {
                        this.killCPUTimeExceedQueries();
                        break;
                    }
                    case HeapMemoryAlarmingVerbose: {
                        LOGGER.warn("Heap used bytes {} exceeds alarming level", (Object)this._usedBytes);
                        LOGGER.warn("Query usage aggregation results {}", (Object)this._aggregatedUsagePerActiveQuery.toString());
                        this._numQueriesKilledConsecutively = 0;
                        break;
                    }
                    default: {
                        this._numQueriesKilledConsecutively = 0;
                    }
                }
            }

            void reschedule() {
                try {
                    Thread.sleep(this._sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            void killAllQueries() {
                if (this._oomKillQueryEnabled) {
                    int killedCount = 0;
                    for (Map.Entry<Thread, CPUMemThreadLevelAccountingObjects.ThreadEntry> entry : PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap.entrySet()) {
                        CPUMemThreadLevelAccountingObjects.ThreadEntry threadEntry = entry.getValue();
                        CPUMemThreadLevelAccountingObjects.TaskEntry taskEntry = threadEntry.getCurrentThreadTaskStatus();
                        if (taskEntry == null || !taskEntry.isAnchorThread()) continue;
                        threadEntry._errorStatus.set(new RuntimeException(String.format("Query killed due to %s out of memory!", this._instanceType)));
                        taskEntry.getAnchorThread().interrupt();
                        ++killedCount;
                    }
                    if (this._isQueryKilledMetricEnabled) {
                        this._metrics.addMeteredGlobalValue(this._queryKilledMeter, (long)killedCount);
                    }
                    try {
                        Thread.sleep(this._normalSleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.gc();
                    this._numQueriesKilledConsecutively = 0;
                }
            }

            private void killMostExpensiveQuery() {
                if (!this._aggregatedUsagePerActiveQuery.isEmpty() && this._numQueriesKilledConsecutively >= this._gcBackoffCount) {
                    this._numQueriesKilledConsecutively = 0;
                    System.gc();
                    try {
                        Thread.sleep(this._gcWaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._usedBytes = MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
                    if (this._usedBytes < this._criticalLevelAfterGC) {
                        return;
                    }
                    LOGGER.error("After GC, heap used bytes {} still exceeds _criticalLevelAfterGC level {}", (Object)this._usedBytes, (Object)this._criticalLevelAfterGC);
                }
                if (!PerQueryCPUMemResourceUsageAccountant.this._isThreadMemorySamplingEnabled && !PerQueryCPUMemResourceUsageAccountant.this._isThreadCPUSamplingEnabled) {
                    LOGGER.warn("But unable to kill query because neither memory nor cpu tracking is enabled");
                    return;
                }
                if (this._aggregatedUsagePerActiveQuery.isEmpty()) {
                    LOGGER.debug("No active queries to kill");
                    return;
                }
                if (PerQueryCPUMemResourceUsageAccountant.this._isThreadMemorySamplingEnabled) {
                    boolean shouldKill;
                    AggregatedStats maxUsageTuple = Collections.max(this._aggregatedUsagePerActiveQuery.values(), Comparator.comparing(AggregatedStats::getAllocatedBytes));
                    boolean bl = shouldKill = this._oomKillQueryEnabled && maxUsageTuple._allocatedBytes > this._minMemoryFootprintForKill;
                    if (shouldKill) {
                        maxUsageTuple._exceptionAtomicReference.set(new RuntimeException(String.format(" Query %s got killed because using %d bytes of memory on %s: %s, exceeding the quota", maxUsageTuple._queryId, maxUsageTuple.getAllocatedBytes(), this._instanceType, PerQueryCPUMemResourceUsageAccountant.this._instanceId)));
                        this.interruptRunnerThread(maxUsageTuple.getAnchorThread());
                        LOGGER.error("Query {} got picked because using {} bytes of memory, actual kill committed true}", (Object)maxUsageTuple._queryId, (Object)maxUsageTuple._allocatedBytes);
                        LOGGER.error("Current task status recorded is {}", PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap);
                    } else if (!this._oomKillQueryEnabled) {
                        LOGGER.warn("Query {} got picked because using {} bytes of memory, actual kill committed false because oomKillQueryEnabled is false", (Object)maxUsageTuple._queryId, (Object)maxUsageTuple._allocatedBytes);
                    } else {
                        LOGGER.warn("But all queries are below quota, no query killed");
                    }
                } else {
                    AggregatedStats maxUsageTuple = Collections.max(this._aggregatedUsagePerActiveQuery.values(), Comparator.comparing(AggregatedStats::getCpuNS));
                    if (this._oomKillQueryEnabled) {
                        maxUsageTuple._exceptionAtomicReference.set(new RuntimeException(String.format(" Query %s got killed because memory pressure, using %d ns of CPU time on %s: %s", maxUsageTuple._queryId, maxUsageTuple.getAllocatedBytes(), this._instanceType, PerQueryCPUMemResourceUsageAccountant.this._instanceId)));
                        this.interruptRunnerThread(maxUsageTuple.getAnchorThread());
                        LOGGER.error("Query {} got picked because using {} ns of cpu time, actual kill committed true", (Object)maxUsageTuple._allocatedBytes, (Object)maxUsageTuple._queryId);
                        LOGGER.error("Current task status recorded is {}", PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap);
                    } else {
                        LOGGER.warn("Query {} got picked because using {} bytes of memory, actual kill committed false because oomKillQueryEnabled is false", (Object)maxUsageTuple._queryId, (Object)maxUsageTuple._allocatedBytes);
                    }
                }
                LOGGER.warn("Query aggregation results {} for the previous kill.", (Object)this._aggregatedUsagePerActiveQuery.toString());
            }

            private void killCPUTimeExceedQueries() {
                for (Map.Entry<String, AggregatedStats> entry : this._aggregatedUsagePerActiveQuery.entrySet()) {
                    AggregatedStats value = entry.getValue();
                    if (value._cpuNS <= this._cpuTimeBasedKillingThresholdNS) continue;
                    LOGGER.error("Current task status recorded is {}. Query {} got picked because using {} ns of cpu time, greater than threshold {}", new Object[]{PerQueryCPUMemResourceUsageAccountant.this._threadEntriesMap, value._queryId, value.getCpuNS(), this._cpuTimeBasedKillingThresholdNS});
                    value._exceptionAtomicReference.set(new RuntimeException(String.format("Query %s got killed on %s: %s because using %d CPU time exceeding limit of %d ns CPU time", value._queryId, this._instanceType, PerQueryCPUMemResourceUsageAccountant.this._instanceId, value.getCpuNS(), this._cpuTimeBasedKillingThresholdNS)));
                    this.interruptRunnerThread(value.getAnchorThread());
                }
            }

            private void interruptRunnerThread(Thread thread) {
                thread.interrupt();
                if (this._isQueryKilledMetricEnabled) {
                    this._metrics.addMeteredGlobalValue(this._queryKilledMeter, 1L);
                }
                ++this._numQueriesKilledConsecutively;
            }
        }

        protected static class AggregatedStats {
            final String _queryId;
            final Thread _anchorThread;
            boolean _isAnchorThread;
            AtomicReference<Exception> _exceptionAtomicReference;
            long _allocatedBytes;
            long _cpuNS;

            public AggregatedStats(long cpuNS, long allocatedBytes, Thread anchorThread, boolean isAnchorThread, AtomicReference<Exception> exceptionAtomicReference, String queryId) {
                this._cpuNS = cpuNS;
                this._allocatedBytes = allocatedBytes;
                this._anchorThread = anchorThread;
                this._isAnchorThread = isAnchorThread;
                this._exceptionAtomicReference = exceptionAtomicReference;
                this._queryId = queryId;
            }

            public String toString() {
                return "AggregatedStats{_queryId='" + this._queryId + "', _anchorThread=" + this._anchorThread + ", _isAnchorThread=" + this._isAnchorThread + ", _exceptionAtomicReference=" + this._exceptionAtomicReference + ", _allocatedBytes=" + this._allocatedBytes + ", _cpuNS=" + this._cpuNS + "}";
            }

            public long getCpuNS() {
                return this._cpuNS;
            }

            public long getAllocatedBytes() {
                return this._allocatedBytes;
            }

            public Thread getAnchorThread() {
                return this._anchorThread;
            }

            public AggregatedStats merge(long cpuNS, long memoryBytes, boolean isAnchorThread, AtomicReference<Exception> exceptionAtomicReference) {
                this._cpuNS += cpuNS;
                this._allocatedBytes += memoryBytes;
                if (isAnchorThread) {
                    this._isAnchorThread = true;
                    this._exceptionAtomicReference = exceptionAtomicReference;
                }
                return this;
            }
        }

        static enum TriggeringLevel {
            Normal,
            HeapMemoryAlarmingVerbose,
            CPUTimeBasedKilling,
            HeapMemoryCritical,
            HeapMemoryPanic;

        }
    }
}

