/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.auth;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.DatabaseUtils;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.FineGrainedAccessControl;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FineGrainedAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FineGrainedAuthUtils.class);

    private FineGrainedAuthUtils() {
    }

    private static String findParam(String paramName, MultivaluedMap<String, String> pathParams, MultivaluedMap<String, String> queryParams) {
        String name = (String)pathParams.getFirst((Object)paramName);
        if (name == null) {
            name = (String)queryParams.getFirst((Object)paramName);
        }
        return name;
    }

    public static void validateFineGrainedAuth(Method endpointMethod, UriInfo uriInfo, HttpHeaders httpHeaders, FineGrainedAccessControl accessControl) {
        if (endpointMethod.isAnnotationPresent(Authorize.class)) {
            boolean hasAccess;
            String accessDeniedMsg;
            Authorize auth = endpointMethod.getAnnotation(Authorize.class);
            String targetId = null;
            if (auth.targetType() == TargetType.TABLE) {
                if (StringUtils.isEmpty((CharSequence)auth.paramName())) {
                    throw new WebApplicationException("paramName not found for table level authorization in API: " + uriInfo.getRequestUri(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                targetId = FineGrainedAuthUtils.findParam(auth.paramName(), (MultivaluedMap<String, String>)uriInfo.getPathParameters(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
                if (StringUtils.isEmpty((CharSequence)targetId)) {
                    throw new WebApplicationException("Could not find paramName " + auth.paramName() + " in path or query params of the API: " + uriInfo.getRequestUri(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                targetId = DatabaseUtils.translateTableName((String)TableNameBuilder.extractRawTableName((String)targetId), (HttpHeaders)httpHeaders);
                accessDeniedMsg = "Access denied to " + auth.action() + " for table: " + targetId;
            } else if (auth.targetType() == TargetType.CLUSTER) {
                accessDeniedMsg = "Access denied to " + auth.action() + " in the cluster";
            } else {
                throw new WebApplicationException("Unsupported targetType: " + auth.targetType() + " in API: " + uriInfo.getRequestUri(), Response.Status.INTERNAL_SERVER_ERROR);
            }
            try {
                hasAccess = accessControl.hasAccess(httpHeaders, auth.targetType(), targetId, auth.action());
            }
            catch (Throwable t) {
                String errorMsg = String.format("Failed to check for access for target type %s and target ID %s with action %s", new Object[]{auth.targetType(), targetId, auth.action()});
                LOGGER.error(errorMsg, t);
                throw new WebApplicationException(errorMsg, t, Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (!hasAccess) {
                throw new WebApplicationException(accessDeniedMsg, Response.Status.FORBIDDEN);
            }
        } else if (!accessControl.defaultAccess(httpHeaders)) {
            throw new WebApplicationException("Access denied - default authorization failed", Response.Status.FORBIDDEN);
        }
    }
}

