/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

public class MinionConstants {
    public static final String TASK_TIME_SUFFIX = ".time";
    public static final String TABLE_NAME_KEY = "tableName";
    public static final String SEGMENT_NAME_KEY = "segmentName";
    public static final String DOWNLOAD_URL_KEY = "downloadURL";
    public static final String UPLOAD_URL_KEY = "uploadURL";
    public static final String DOT_SEPARATOR = ".";
    public static final String URL_SEPARATOR = ",";
    public static final String SEGMENT_NAME_SEPARATOR = ",";
    public static final String AUTH_TOKEN = "authToken";
    public static final String ORIGINAL_SEGMENT_CRC_KEY = "crc";
    public static final String MAX_NUM_ATTEMPTS_KEY = "maxNumAttempts";
    public static final String INITIAL_RETRY_DELAY_MS_KEY = "initialRetryDelayMs";
    public static final String RETRY_SCALE_FACTOR_KEY = "retryScaleFactor";
    public static final String TIMEOUT_MS_KEY_SUFFIX = ".timeoutMs";
    public static final String NUM_CONCURRENT_TASKS_PER_INSTANCE_KEY_SUFFIX = ".numConcurrentTasksPerInstance";
    public static final String MAX_ATTEMPTS_PER_TASK_KEY_SUFFIX = ".maxAttemptsPerTask";
    public static final String TABLE_MAX_NUM_TASKS_KEY = "tableMaxNumTasks";
    public static final String ENABLE_REPLACE_SEGMENTS_KEY = "enableReplaceSegments";
    public static final int DEFAULT_MAX_ATTEMPTS_PER_TASK = 1;

    private MinionConstants() {
    }

    public static class UpsertCompactionTask {
        public static final String TASK_TYPE = "UpsertCompactionTask";
        public static final String BUFFER_TIME_PERIOD_KEY = "bufferTimePeriod";
        public static final String INVALID_RECORDS_THRESHOLD_PERCENT = "invalidRecordsThresholdPercent";
        public static final String INVALID_RECORDS_THRESHOLD_COUNT = "invalidRecordsThresholdCount";
        public static final String VALID_DOC_IDS_TYPE = "validDocIdsType";
        public static final String NUM_SEGMENTS_BATCH_PER_SERVER_REQUEST = "numSegmentsBatchPerServerRequest";
    }

    public static class SegmentGenerationAndPushTask {
        public static final String TASK_TYPE = "SegmentGenerationAndPushTask";
        public static final String CONFIG_NUMBER_CONCURRENT_TASKS_PER_INSTANCE = "SegmentGenerationAndPushTask.numConcurrentTasksPerInstance";
    }

    public static class RealtimeToOfflineSegmentsTask
    extends MergeTask {
        public static final String TASK_TYPE = "RealtimeToOfflineSegmentsTask";
        @Deprecated
        public static final String COLLECTOR_TYPE_KEY = "collectorType";
    }

    public static class MergeRollupTask
    extends MergeTask {
        public static final String TASK_TYPE = "MergeRollupTask";
        public static final String MERGE_LEVEL_KEY = "mergeLevel";
        public static final String SEGMENT_ZK_METADATA_MERGE_LEVEL_KEY = "MergeRollupTask.mergeLevel";
        public static final String SEGMENT_ZK_METADATA_TIME_KEY = "MergeRollupTask.time";
        public static final String MERGED_SEGMENT_NAME_PREFIX = "merged_";
        public static final String SEGMENT_GROUP_MANAGER_CLASS_NAME_KEY = "segment.group.manager.class.name";
    }

    public static abstract class MergeTask {
        public static final String BUCKET_TIME_PERIOD_KEY = "bucketTimePeriod";
        public static final String BUFFER_TIME_PERIOD_KEY = "bufferTimePeriod";
        public static final String WINDOW_START_MS_KEY = "windowStartMs";
        public static final String WINDOW_END_MS_KEY = "windowEndMs";
        public static final String NEGATE_WINDOW_FILTER = "negateWindowFilter";
        public static final String ROUND_BUCKET_TIME_PERIOD_KEY = "roundBucketTimePeriod";
        public static final String PARTITION_BUCKET_TIME_PERIOD_KEY = "partitionBucketTimePeriod";
        public static final String MERGE_TYPE_KEY = "mergeType";
        public static final String AGGREGATION_TYPE_KEY_SUFFIX = ".aggregationType";
        public static final String MODE = "mode";
        public static final String PROCESS_FROM_WATERMARK_MODE = "processFromWatermark";
        public static final String PROCESS_ALL_MODE = "processAll";
        public static final String MAX_NUM_RECORDS_PER_TASK_KEY = "maxNumRecordsPerTask";
        public static final String MAX_NUM_RECORDS_PER_SEGMENT_KEY = "maxNumRecordsPerSegment";
        public static final String SEGMENT_MAPPER_FILE_SIZE_IN_BYTES = "segmentMapperFileSizeThresholdInBytes";
        public static final String MAX_NUM_PARALLEL_BUCKETS = "maxNumParallelBuckets";
        public static final String SEGMENT_NAME_PREFIX_KEY = "segmentNamePrefix";
        public static final String SEGMENT_NAME_POSTFIX_KEY = "segmentNamePostfix";
        public static final String FIXED_SEGMENT_NAME_KEY = "fixedSegmentName";
        public static final String SEGMENT_ZK_METADATA_SHOULD_NOT_MERGE_KEY = "shouldNotMerge";
    }

    public static class PurgeTask {
        public static final String TASK_TYPE = "PurgeTask";
        public static final String LAST_PURGE_TIME_THREESOLD_PERIOD = "lastPurgeTimeThresholdPeriod";
        public static final String DEFAULT_LAST_PURGE_TIME_THRESHOLD_PERIOD = "14d";
    }
}

