/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockBuilder {
    private final DataSchema _dataSchema;
    private final DataBlock.Type _blockType;
    private final int _numRows;
    private final int _numColumns;
    private int[] _columnOffsets;
    private int _rowSizeInBytes;
    private int[] _cumulativeColumnOffsetSizeInBytes;
    private int[] _columnSizeInBytes;
    private final Object2IntOpenHashMap<String> _dictionary = new Object2IntOpenHashMap();
    private final UnsynchronizedByteArrayOutputStream _fixedSizeDataByteArrayOutputStream;
    private final DataOutputStream _fixedSizeDataOutputStream;
    private final UnsynchronizedByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(8192);
    private final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream((OutputStream)this._variableSizeDataByteArrayOutputStream);

    private DataBlockBuilder(DataSchema dataSchema, DataBlock.Type blockType, int numRows) {
        this._dataSchema = dataSchema;
        this._blockType = blockType;
        this._numRows = numRows;
        this._numColumns = dataSchema.size();
        if (this._blockType == DataBlock.Type.ROW) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets((DataSchema)dataSchema, (int[])this._columnOffsets);
            int nullBytes = this._numColumns * 8;
            int expectedFixedSizeStreamSize = (this._rowSizeInBytes + nullBytes) * numRows;
            this._fixedSizeDataByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(expectedFixedSizeStreamSize);
            this._fixedSizeDataOutputStream = new DataOutputStream((OutputStream)this._fixedSizeDataByteArrayOutputStream);
        } else {
            this._fixedSizeDataByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(8192);
            this._fixedSizeDataOutputStream = new DataOutputStream((OutputStream)this._fixedSizeDataByteArrayOutputStream);
            if (this._blockType == DataBlock.Type.COLUMNAR) {
                this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
                this._columnSizeInBytes = new int[this._numColumns];
                DataBlockUtils.computeColumnSizeInBytes((DataSchema)this._dataSchema, (int[])this._columnSizeInBytes);
                int cumulativeColumnOffset = 0;
                for (int i = 0; i < this._numColumns; ++i) {
                    this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                    cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
                }
            }
        }
    }

    public void setNullRowIds(@Nullable RoaringBitmap nullRowIds) throws IOException {
        this._fixedSizeDataOutputStream.writeInt(this._variableSizeDataByteArrayOutputStream.size());
        if (nullRowIds == null || nullRowIds.isEmpty()) {
            this._fixedSizeDataOutputStream.writeInt(0);
        } else {
            byte[] bitmapBytes = RoaringBitmapUtils.serialize((ImmutableBitmapDataProvider)nullRowIds);
            this._fixedSizeDataOutputStream.writeInt(bitmapBytes.length);
            this._variableSizeDataByteArrayOutputStream.write(bitmapBytes);
        }
    }

    public static RowDataBlock buildFromRows(List<Object[]> rows, DataSchema dataSchema) throws IOException {
        int numRows = rows.size();
        DataBlockBuilder rowBuilder = new DataBlockBuilder(dataSchema, DataBlock.Type.ROW, numRows);
        DataSchema.ColumnDataType[] storedTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        Object[] nullPlaceholders = new Object[numColumns];
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = new RoaringBitmap();
            nullPlaceholders[colId] = storedTypes[colId].getNullPlaceholder();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(rowBuilder._rowSizeInBytes);
        for (int rowId = 0; rowId < numRows; ++rowId) {
            byteBuffer.clear();
            Object[] row = rows.get(rowId);
            block18: for (int colId = 0; colId < numColumns; ++colId) {
                Object value = row[colId];
                if (value == null) {
                    nullBitmaps[colId].add(rowId);
                    value = nullPlaceholders[colId];
                }
                switch (storedTypes[colId]) {
                    case INT: {
                        byteBuffer.putInt((Integer)value);
                        continue block18;
                    }
                    case LONG: {
                        byteBuffer.putLong((Long)value);
                        continue block18;
                    }
                    case FLOAT: {
                        byteBuffer.putFloat(((Float)value).floatValue());
                        continue block18;
                    }
                    case DOUBLE: {
                        byteBuffer.putDouble((Double)value);
                        continue block18;
                    }
                    case BIG_DECIMAL: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (BigDecimal)value);
                        continue block18;
                    }
                    case STRING: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String)value);
                        continue block18;
                    }
                    case BYTES: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (ByteArray)value);
                        continue block18;
                    }
                    case INT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (int[])value);
                        continue block18;
                    }
                    case LONG_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (long[])value);
                        continue block18;
                    }
                    case FLOAT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (float[])value);
                        continue block18;
                    }
                    case DOUBLE_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (double[])value);
                        continue block18;
                    }
                    case STRING_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String[])value);
                        continue block18;
                    }
                    case OBJECT: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, value);
                        continue block18;
                    }
                    case UNKNOWN: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, null);
                        continue block18;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported stored type: %s for column: %s", storedTypes[colId], dataSchema.getColumnName(colId)));
                    }
                }
            }
            rowBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        for (RoaringBitmap nullBitmap : nullBitmaps) {
            rowBuilder.setNullRowIds(nullBitmap);
        }
        return DataBlockBuilder.buildRowBlock(rowBuilder);
    }

    public static ColumnarDataBlock buildFromColumns(List<Object[]> columns, DataSchema dataSchema) throws IOException {
        int colId;
        int numRows = columns.isEmpty() ? 0 : columns.get(0).length;
        DataBlockBuilder columnarBuilder = new DataBlockBuilder(dataSchema, DataBlock.Type.COLUMNAR, numRows);
        DataSchema.ColumnDataType[] storedTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        Object[] nullPlaceholders = new Object[numColumns];
        for (colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = new RoaringBitmap();
            nullPlaceholders[colId] = storedTypes[colId].getNullPlaceholder();
        }
        for (colId = 0; colId < numColumns; ++colId) {
            Object[] column = columns.get(colId);
            ByteBuffer byteBuffer = ByteBuffer.allocate(numRows * columnarBuilder._columnSizeInBytes[colId]);
            switch (storedTypes[colId]) {
                case INT: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putInt((Integer)value);
                    }
                    break;
                }
                case LONG: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putLong((Long)value);
                    }
                    break;
                }
                case FLOAT: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putFloat(((Float)value).floatValue());
                    }
                    break;
                }
                case DOUBLE: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putDouble((Double)value);
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (BigDecimal)value);
                    }
                    break;
                }
                case STRING: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String)value);
                    }
                    break;
                }
                case BYTES: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (ByteArray)value);
                    }
                    break;
                }
                case INT_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (int[])value);
                    }
                    break;
                }
                case LONG_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (long[])value);
                    }
                    break;
                }
                case FLOAT_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (float[])value);
                    }
                    break;
                }
                case DOUBLE_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (double[])value);
                    }
                    break;
                }
                case STRING_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String[])value);
                    }
                    break;
                }
                case OBJECT: {
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, column[rowId]);
                    }
                    break;
                }
                case UNKNOWN: {
                    int rowId;
                    for (rowId = 0; rowId < numRows; ++rowId) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, null);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported stored type: %s for column: %s", storedTypes[colId], dataSchema.getColumnName(colId)));
                }
            }
            columnarBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        for (RoaringBitmap nullBitmap : nullBitmaps) {
            columnarBuilder.setNullRowIds(nullBitmap);
        }
        return DataBlockBuilder.buildColumnarBlock(columnarBuilder);
    }

    private static RowDataBlock buildRowBlock(DataBlockBuilder builder) {
        return new RowDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static ColumnarDataBlock buildColumnarBlock(DataBlockBuilder builder) {
        return new ColumnarDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static String[] getReverseDictionary(Object2IntOpenHashMap<String> dictionary) {
        String[] reverseDictionary = new String[dictionary.size()];
        for (Object2IntMap.Entry entry : dictionary.object2IntEntrySet()) {
            reverseDictionary[entry.getIntValue()] = (String)entry.getKey();
        }
        return reverseDictionary;
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, BigDecimal value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = BigDecimalUtils.serialize((BigDecimal)value);
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String value) {
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
        byteBuffer.putInt(dictId);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, ByteArray value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = value.getBytes();
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, @Nullable Object value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        if (value == null) {
            byteBuffer.putInt(0);
            builder._variableSizeDataOutputStream.writeInt(100);
        } else {
            int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
            byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
            byteBuffer.putInt(bytes.length);
            builder._variableSizeDataOutputStream.writeInt(objectTypeValue);
            builder._variableSizeDataByteArrayOutputStream.write(bytes);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, int[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (int value : values) {
            builder._variableSizeDataOutputStream.writeInt(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, long[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (long value : values) {
            builder._variableSizeDataOutputStream.writeLong(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, float[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (float value : values) {
            builder._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, double[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (double value : values) {
            builder._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        for (String value : values) {
            int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
            builder._variableSizeDataOutputStream.writeInt(dictId);
        }
    }
}

