/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.core.data.manager.offline.DimensionTable;
import org.apache.pinot.core.data.manager.offline.FastLookupDimensionTable;
import org.apache.pinot.core.data.manager.offline.LookupRecordLocation;
import org.apache.pinot.core.data.manager.offline.MemoryOptimizedDimensionTable;
import org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.config.table.DimensionTableConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;

@ThreadSafe
public class DimensionTableDataManager
extends OfflineTableDataManager {
    private static final Map<String, DimensionTableDataManager> INSTANCES = new ConcurrentHashMap<String, DimensionTableDataManager>();
    private final AtomicReference<DimensionTable> _dimensionTable = new AtomicReference();
    private final AtomicInteger _loadToken = new AtomicInteger();
    private boolean _disablePreload = false;
    private boolean _errorOnDuplicatePrimaryKey = false;

    private DimensionTableDataManager() {
    }

    public static DimensionTableDataManager createInstanceByTableName(String tableNameWithType) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> new DimensionTableDataManager());
    }

    @VisibleForTesting
    public static DimensionTableDataManager registerDimensionTable(String tableNameWithType, DimensionTableDataManager instance) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> instance);
    }

    public static DimensionTableDataManager getInstanceByTableName(String tableNameWithType) {
        return INSTANCES.get(tableNameWithType);
    }

    @Override
    protected void doInit() {
        DimensionTableConfig dimensionTableConfig;
        super.doInit();
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        if (tableConfig != null && (dimensionTableConfig = tableConfig.getDimensionTableConfig()) != null) {
            this._disablePreload = dimensionTableConfig.isDisablePreload();
            this._errorOnDuplicatePrimaryKey = dimensionTableConfig.isErrorOnDuplicatePrimaryKey();
        }
        if (this._disablePreload) {
            this._dimensionTable.set(new MemoryOptimizedDimensionTable(schema, primaryKeyColumns, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), this));
        } else {
            this._dimensionTable.set(new FastLookupDimensionTable(schema, primaryKeyColumns, new HashMap<PrimaryKey, GenericRow>()));
        }
    }

    @Override
    public void addSegment(ImmutableSegment immutableSegment) {
        super.addSegment(immutableSegment);
        String segmentName = immutableSegment.getSegmentName();
        if (this.loadLookupTable()) {
            this._logger.info("Successfully loaded lookup table after adding segment: {}", (Object)segmentName);
        } else {
            this._logger.info("Skip loading lookup table after adding segment: {}, another loading in progress", (Object)segmentName);
        }
    }

    @Override
    protected void doOffloadSegment(String segmentName) {
        SegmentDataManager segmentDataManager = this.unregisterSegment(segmentName);
        if (segmentDataManager != null) {
            segmentDataManager.offload();
            this.releaseSegment(segmentDataManager);
            this._logger.info("Offloaded segment: {}", (Object)segmentName);
            if (this.loadLookupTable()) {
                this._logger.info("Successfully loaded lookup table after offloading segment: {}", (Object)segmentName);
            } else {
                this._logger.info("Skip loading lookup table after offloading segment: {}, another loading in progress", (Object)segmentName);
            }
        } else {
            this._logger.warn("Failed to find segment: {}, skipping offloading it", (Object)segmentName);
        }
    }

    @Override
    protected void doShutdown() {
        this.releaseAndRemoveAllSegments();
        this.closeDimensionTable(this._dimensionTable.get());
    }

    private void closeDimensionTable(DimensionTable dimensionTable) {
        try {
            dimensionTable.close();
        }
        catch (Exception e) {
            this._logger.error("Caught exception while closing the dimension table", (Throwable)e);
        }
    }

    private boolean loadLookupTable() {
        DimensionTable dimensionTable;
        DimensionTable dimensionTable2 = dimensionTable = this._disablePreload ? this.createMemOptimisedDimensionTable() : this.createFastLookupDimensionTable();
        if (dimensionTable != null) {
            this.closeDimensionTable(this._dimensionTable.getAndSet(dimensionTable));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DimensionTable createFastLookupDimensionTable() {
        token = this._loadToken.incrementAndGet();
        schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((boolean)(schema != null), (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        lookupTable = new HashMap<PrimaryKey, GenericRow>();
        segmentDataManagers = this.acquireAllSegments();
        try {
            for (SegmentDataManager segmentManager : segmentDataManagers) {
                block19: {
                    indexSegment = segmentManager.getSegment();
                    numTotalDocs = indexSegment.getSegmentMetadata().getTotalDocs();
                    if (numTotalDocs <= 0) continue;
                    try {
                        block18: {
                            recordReader = new PinotSegmentRecordReader();
                            try {
                                recordReader.init(indexSegment);
                                i = 0;
lbl18:
                                // 2 sources

                                while (i < numTotalDocs) {
                                    if (this._loadToken.get() != token) {
                                        var12_14 = null;
                                        break block18;
                                    }
                                    ** GOTO lbl-1000
                                }
                                break block19;
                            }
                            catch (Throwable var11_13) {
                                try {
                                    recordReader.close();
                                    throw var11_13;
                                }
                                catch (Throwable var12_15) {
                                    var11_13.addSuppressed(var12_15);
                                }
                                throw var11_13;
                            }
                        }
                        recordReader.close();
                        return var12_14;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while reading records from segment: " + indexSegment.getSegmentName());
                    }
lbl-1000:
                    // 1 sources

                    {
                        row = new GenericRow();
                        recordReader.getRecord(i, row);
                        previousRow = lookupTable.put(row.getPrimaryKey(primaryKeyColumns), row);
                        if (this._errorOnDuplicatePrimaryKey && previousRow != null) {
                            throw new IllegalStateException("Caught exception while reading records from segment: " + indexSegment.getSegmentName() + "primary key already exist for: " + row.getPrimaryKey(primaryKeyColumns));
                        }
                        ++i;
                        ** GOTO lbl18
                    }
                }
                recordReader.close();
            }
            var6_6 = new FastLookupDimensionTable(schema, primaryKeyColumns, lookupTable);
            return var6_6;
        }
        finally {
            var13_16 = segmentDataManagers.iterator();
            while (true) {
                if (!var13_16.hasNext()) {
                }
                segmentManager = var13_16.next();
                this.releaseSegment(segmentManager);
            }
        }
    }

    @Nullable
    private DimensionTable createMemOptimisedDimensionTable() {
        int token = this._loadToken.incrementAndGet();
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        int numPrimaryKeyColumns = primaryKeyColumns.size();
        HashMap<PrimaryKey, LookupRecordLocation> lookupTable = new HashMap<PrimaryKey, LookupRecordLocation>();
        List<SegmentDataManager> segmentDataManagers = this.acquireAllSegments();
        ArrayList<PinotSegmentRecordReader> recordReaders = new ArrayList<PinotSegmentRecordReader>(segmentDataManagers.size());
        for (SegmentDataManager segmentManager : segmentDataManagers) {
            IndexSegment indexSegment = segmentManager.getSegment();
            int numTotalDocs = indexSegment.getSegmentMetadata().getTotalDocs();
            if (numTotalDocs <= 0) continue;
            try {
                PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
                recordReader.init(indexSegment);
                recordReaders.add(recordReader);
                for (int i = 0; i < numTotalDocs; ++i) {
                    if (this._loadToken.get() != token) {
                        for (PinotSegmentRecordReader reader : recordReaders) {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                this._logger.error("Caught exception while closing record reader for segment: {}", (Object)reader.getSegmentName(), (Object)e);
                            }
                        }
                        for (SegmentDataManager dataManager : segmentDataManagers) {
                            this.releaseSegment(dataManager);
                        }
                        return null;
                    }
                    Object[] values = new Object[numPrimaryKeyColumns];
                    for (int j = 0; j < numPrimaryKeyColumns; ++j) {
                        values[j] = recordReader.getValue(i, (String)primaryKeyColumns.get(j));
                    }
                    lookupTable.put(new PrimaryKey(values), new LookupRecordLocation(recordReader, i));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while reading records from segment: " + indexSegment.getSegmentName());
            }
        }
        return new MemoryOptimizedDimensionTable(schema, primaryKeyColumns, lookupTable, segmentDataManagers, recordReaders, this);
    }

    public boolean isPopulated() {
        return !this._dimensionTable.get().isEmpty();
    }

    public GenericRow lookupRowByPrimaryKey(PrimaryKey pk) {
        return this._dimensionTable.get().get(pk);
    }

    public FieldSpec getColumnFieldSpec(String columnName) {
        return this._dimensionTable.get().getFieldSpecFor(columnName);
    }

    public List<String> getPrimaryKeyColumns() {
        return this._dimensionTable.get().getPrimaryKeyColumns();
    }
}

