/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.data.manager.offline.DimensionTable;
import org.apache.pinot.core.data.manager.offline.LookupRecordLocation;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryOptimizedDimensionTable
implements DimensionTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryOptimizedDimensionTable.class);
    private final Map<PrimaryKey, LookupRecordLocation> _lookupTable;
    private final Schema _tableSchema;
    private final List<String> _primaryKeyColumns;
    private final ThreadLocal<GenericRow> _reuse = ThreadLocal.withInitial(GenericRow::new);
    private final List<SegmentDataManager> _segmentDataManagers;
    private final List<PinotSegmentRecordReader> _recordReaders;
    private final TableDataManager _tableDataManager;

    MemoryOptimizedDimensionTable(Schema tableSchema, List<String> primaryKeyColumns, Map<PrimaryKey, LookupRecordLocation> lookupTable, List<SegmentDataManager> segmentDataManagers, List<PinotSegmentRecordReader> recordReaders, TableDataManager tableDataManager) {
        this._tableSchema = tableSchema;
        this._primaryKeyColumns = primaryKeyColumns;
        this._lookupTable = lookupTable;
        this._segmentDataManagers = segmentDataManagers;
        this._recordReaders = recordReaders;
        this._tableDataManager = tableDataManager;
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    @Override
    public GenericRow get(PrimaryKey pk) {
        LookupRecordLocation lookupRecordLocation = this._lookupTable.get(pk);
        if (lookupRecordLocation == null) {
            return null;
        }
        GenericRow reuse = this._reuse.get();
        reuse.clear();
        return lookupRecordLocation.getRecord(reuse);
    }

    @Override
    public boolean isEmpty() {
        return this._lookupTable.isEmpty();
    }

    @Override
    public FieldSpec getFieldSpecFor(String columnName) {
        return this._tableSchema.getFieldSpecFor(columnName);
    }

    @Override
    public void close() {
        for (PinotSegmentRecordReader recordReader : this._recordReaders) {
            try {
                recordReader.close();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while closing record reader for segment: {}", (Object)recordReader.getSegmentName(), (Object)e);
            }
        }
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            this._tableDataManager.releaseSegment(segmentDataManager);
        }
    }
}

