/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.realtime.SegmentCompletionUtils;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotFSSegmentUploader
implements SegmentUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotFSSegmentUploader.class);
    public static final int DEFAULT_SEGMENT_UPLOAD_TIMEOUT_MILLIS = 10000;
    private final String _segmentStoreUriStr;
    private final ExecutorService _executorService = Executors.newCachedThreadPool();
    private final int _timeoutInMs;
    private final ServerMetrics _serverMetrics;

    public PinotFSSegmentUploader(String segmentStoreDirUri, int timeoutMillis, ServerMetrics serverMetrics) {
        this._segmentStoreUriStr = segmentStoreDirUri;
        this._timeoutInMs = timeoutMillis;
        this._serverMetrics = serverMetrics;
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName) {
        return this.uploadSegment(segmentFile, segmentName, this._timeoutInMs);
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName, int timeoutInMillis) {
        if (this._segmentStoreUriStr == null || this._segmentStoreUriStr.isEmpty()) {
            LOGGER.error("Missing segment store uri. Failed to upload segment file {} for {}.", (Object)segmentFile.getName(), (Object)segmentName.getSegmentName());
            return null;
        }
        String rawTableName = TableNameBuilder.extractRawTableName((String)segmentName.getTableName());
        Callable<URI> uploadTask = () -> {
            URI destUri = new URI(StringUtil.join((String)File.separator, (String[])new String[]{this._segmentStoreUriStr, segmentName.getTableName(), SegmentCompletionUtils.generateTmpSegmentFileName(segmentName.getSegmentName())}));
            long startTime = System.currentTimeMillis();
            try {
                PinotFS pinotFS = PinotFSFactory.create((String)new URI(this._segmentStoreUriStr).getScheme());
                if (pinotFS.exists(destUri)) {
                    pinotFS.delete(destUri, true);
                }
                pinotFS.copyFromLocalFile(segmentFile, destUri);
                URI uRI = destUri;
                return uRI;
            }
            catch (Exception e) {
                LOGGER.warn("Failed copy segment tar file {} to segment store {}: {}", new Object[]{segmentFile.getName(), destUri, e});
            }
            finally {
                long duration = System.currentTimeMillis() - startTime;
                this._serverMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)ServerTimer.SEGMENT_UPLOAD_TIME_MS, duration, TimeUnit.MILLISECONDS);
            }
            return null;
        };
        Future<URI> future = this._executorService.submit(uploadTask);
        try {
            URI segmentLocation = future.get(timeoutInMillis, TimeUnit.MILLISECONDS);
            LOGGER.info("Successfully upload segment {} to {}.", (Object)segmentName, (Object)segmentLocation);
            this._serverMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)(segmentLocation == null ? ServerMeter.SEGMENT_UPLOAD_FAILURE : ServerMeter.SEGMENT_UPLOAD_SUCCESS), 1L);
            return segmentLocation;
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted while waiting for segment upload of {} to {}.", (Object)segmentName, (Object)this._segmentStoreUriStr);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            this._serverMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)ServerMeter.SEGMENT_UPLOAD_TIMEOUT, 1L);
            LOGGER.warn("Timed out waiting to upload segment: {} for table: {}", (Object)segmentName.getSegmentName(), (Object)rawTableName);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to upload file {} of segment {} for table {}", new Object[]{segmentFile.getAbsolutePath(), segmentName, rawTableName, e});
        }
        this._serverMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)ServerMeter.SEGMENT_UPLOAD_FAILURE, 1L);
        return null;
    }
}

