/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.core.data.manager.realtime.IdleTimer;
import org.apache.pinot.core.data.manager.realtime.RealtimeConsumptionRateManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitterFactory;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.io.writer.impl.DirectMemoryManager;
import org.apache.pinot.segment.local.io.writer.impl.MmapMemoryManager;
import org.apache.pinot.segment.local.realtime.converter.ColumnIndicesForRealtimeTable;
import org.apache.pinot.segment.local.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.CompletionConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.recordenricher.RecordEnricherPipeline;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.PartitionGroupConsumer;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionLagState;
import org.apache.pinot.spi.stream.PermanentConsumerException;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamDataDecoder;
import org.apache.pinot.spi.stream.StreamDataDecoderImpl;
import org.apache.pinot.spi.stream.StreamDataDecoderResult;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffsetFactory;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.ExponentialBackoffRetryPolicy;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeSegmentDataManager
extends SegmentDataManager {
    public static final String RESOURCE_TEMP_DIR_NAME = "_tmp";
    private static final int MINIMUM_CONSUME_TIME_MINUTES = 10;
    private static final long TIME_THRESHOLD_FOR_LOG_MINUTES = 1L;
    private static final long TIME_EXTENSION_ON_EMPTY_SEGMENT_HOURS = 1L;
    private static final int MSG_COUNT_THRESHOLD_FOR_LOG = 100000;
    private static final int BUILD_TIME_LEASE_SECONDS = 30;
    private static final int MAX_CONSECUTIVE_ERROR_COUNT = 5;
    private final SegmentZKMetadata _segmentZKMetadata;
    private final TableConfig _tableConfig;
    private final RealtimeTableDataManager _realtimeTableDataManager;
    private final StreamDataDecoder _streamDataDecoder;
    private final int _segmentMaxRowCount;
    private final String _resourceDataDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final Semaphore _partitionGroupConsumerSemaphore;
    private final AtomicBoolean _acquiredConsumerSemaphore;
    private final ServerMetrics _serverMetrics;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final BooleanSupplier _isReadyToConsumeData;
    private final MutableSegmentImpl _realtimeSegment;
    private volatile StreamPartitionMsgOffset _currentOffset;
    private volatile State _state;
    private volatile int _numRowsConsumed = 0;
    private volatile int _numRowsIndexed = 0;
    private volatile int _numRowsErrored = 0;
    private volatile int _consecutiveErrorCount = 0;
    private long _startTimeMs = 0L;
    private final IdleTimer _idleTimer = new IdleTimer();
    private final String _segmentNameStr;
    private final SegmentVersion _segmentVersion;
    private final SegmentBuildTimeLeaseExtender _leaseExtender;
    private SegmentBuildDescriptor _segmentBuildDescriptor;
    private final StreamConsumerFactory _streamConsumerFactory;
    private final StreamPartitionMsgOffsetFactory _streamPartitionMsgOffsetFactory;
    private volatile long _consumeEndTime = 0L;
    private volatile boolean _hasMessagesFetched = false;
    private volatile boolean _endOfPartitionGroup = false;
    private volatile boolean _forceCommitMessageReceived = false;
    private volatile StreamPartitionMsgOffset _finalOffset;
    private volatile boolean _shouldStop = false;
    private static final int MAX_TIME_FOR_CONSUMING_TO_ONLINE_IN_SECONDS = 31;
    private Thread _consumerThread;
    private final int _partitionGroupId;
    private final PartitionGroupConsumptionStatus _partitionGroupConsumptionStatus;
    final String _clientId;
    private final RecordEnricherPipeline _recordEnricherPipeline;
    private final TransformPipeline _transformPipeline;
    private PartitionGroupConsumer _partitionGroupConsumer = null;
    private StreamMetadataProvider _partitionMetadataProvider = null;
    private final File _resourceTmpDir;
    private final String _tableNameWithType;
    private final ColumnIndicesForRealtimeTable _columnIndicesForRealtimeTable;
    private final Logger _segmentLogger;
    private final String _tableStreamName;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final AtomicLong _lastUpdatedRowsIndexed = new AtomicLong(0L);
    private final String _instanceId;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final long _consumeStartTime;
    private final StreamPartitionMsgOffset _startOffset;
    private final StreamConfig _streamConfig;
    private RowMetadata _lastRowMetadata;
    private long _lastConsumedTimestampMs = -1L;
    private long _lastLogTime = 0L;
    private int _lastConsumedCount = 0;
    private String _stopReason = null;
    private final Semaphore _segBuildSemaphore;
    private final boolean _isOffHeap;
    private final boolean _nullHandlingEnabled;
    private final SegmentCommitterFactory _segmentCommitterFactory;
    private final RealtimeConsumptionRateManager.ConsumptionRateLimiter _partitionRateLimiter;
    private final RealtimeConsumptionRateManager.ConsumptionRateLimiter _serverRateLimiter;
    private final StreamPartitionMsgOffset _latestStreamOffsetAtStartupTime;
    private final CommonConstants.Segment.Realtime.CompletionMode _segmentCompletionMode;
    private final List<String> _filteredMessageOffsets = new ArrayList<String>();
    private final boolean _allowConsumptionDuringCommit;
    private boolean _trackFilteredMessageOffsets = false;

    private boolean endCriteriaReached() {
        Preconditions.checkState((boolean)this._state.shouldConsume(), (String)"Incorrect state %s", (Object)((Object)this._state));
        long now = this.now();
        switch (this._state) {
            case INITIAL_CONSUMING: {
                if (now >= this._consumeEndTime) {
                    if (!this._hasMessagesFetched) {
                        this._segmentLogger.info("No events came in, extending time by {} hours", (Object)1L);
                        this._consumeEndTime += TimeUnit.HOURS.toMillis(1L);
                        return false;
                    }
                    this._segmentLogger.info("Stopping consumption due to time limit start={} now={} numRowsConsumed={} numRowsIndexed={}", new Object[]{this._startTimeMs, now, this._numRowsConsumed, this._numRowsIndexed});
                    this._stopReason = "timeLimit";
                    return true;
                }
                if (this._numRowsIndexed >= this._segmentMaxRowCount) {
                    this._segmentLogger.info("Stopping consumption due to row limit nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._segmentMaxRowCount, this._numRowsIndexed, this._numRowsConsumed});
                    this._stopReason = "rowLimit";
                    return true;
                }
                if (this._endOfPartitionGroup) {
                    this._segmentLogger.info("Stopping consumption due to end of partitionGroup reached nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._segmentMaxRowCount, this._numRowsIndexed, this._numRowsConsumed});
                    this._stopReason = "endOfPartitionGroup";
                    return true;
                }
                if (this._forceCommitMessageReceived) {
                    this._segmentLogger.info("Stopping consumption due to force commit - numRowsConsumed={} numRowsIndexed={}", (Object)this._numRowsConsumed, (Object)this._numRowsIndexed);
                    this._stopReason = "forceCommitMessageReceived";
                    return true;
                }
                return false;
            }
            case CATCHING_UP: {
                this._stopReason = null;
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this._segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this._segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
            case CONSUMING_TO_ONLINE: {
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this._segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (now >= this._consumeEndTime) {
                    this._segmentLogger.info("Past max time budget: offset={}, state={}", (Object)this._currentOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this._segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
        }
        this._segmentLogger.error("Illegal state: {}", (Object)this._state);
        throw new RuntimeException("Illegal state to consume");
    }

    private void handleTransientStreamErrors(Exception e) throws Exception {
        ++this._consecutiveErrorCount;
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
        this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
        if (this._consecutiveErrorCount > 5) {
            this._segmentLogger.warn("Stream transient exception when fetching messages, stopping consumption after {} attempts", (Object)this._consecutiveErrorCount, (Object)e);
            throw e;
        }
        this._segmentLogger.warn("Stream transient exception when fetching messages, retrying (count={})", (Object)this._consecutiveErrorCount, (Object)e);
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.recreateStreamConsumer("Too many transient errors");
    }

    protected boolean consumeLoop() throws Exception {
        this.removeSegmentFile();
        this._numRowsErrored = 0;
        long idlePipeSleepTimeMillis = 100L;
        long idleTimeoutMillis = this._streamConfig.getIdleTimeoutMillis();
        this._idleTimer.init();
        StreamPartitionMsgOffset lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
        this._segmentLogger.info("Starting consumption loop start offset {}, finalOffset {}", (Object)this._currentOffset, (Object)this._finalOffset);
        while (!this._shouldStop && !this.endCriteriaReached()) {
            MessageBatch messageBatch;
            this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 1L);
            try {
                messageBatch = this._partitionGroupConsumer.fetchMessages(this._currentOffset, this._streamConfig.getFetchTimeoutMillis());
                this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_FETCHED, (long)messageBatch.getUnfilteredMessageCount());
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("message batch received. filtered={} unfiltered={} endOfPartitionGroup={}", new Object[]{messageBatch.getMessageCount(), messageBatch.getUnfilteredMessageCount(), messageBatch.isEndOfPartitionGroup()});
                }
                this._endOfPartitionGroup = messageBatch.isEndOfPartitionGroup();
                this._consecutiveErrorCount = 0;
            }
            catch (PermanentConsumerException e) {
                this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                this._segmentLogger.warn("Permanent exception from stream when fetching messages, stopping consumption", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            catch (Throwable t) {
                this._segmentLogger.warn("Stream error when fetching messages, stopping consumption", t);
                throw t;
            }
            this.reportDataLoss(messageBatch);
            boolean endCriteriaReached = this.processStreamEvents(messageBatch, idlePipeSleepTimeMillis);
            if (this._currentOffset.compareTo((Object)lastUpdatedOffset) != 0) {
                this._idleTimer.markEventConsumed();
                if (this._currentOffset instanceof LongMsgOffset) {
                    this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.HIGHEST_STREAM_OFFSET_CONSUMED, ((LongMsgOffset)this._currentOffset).getOffset());
                }
                lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
            } else if (endCriteriaReached) {
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("No messages processed before end criteria was reached. Staying at offset {}", (Object)this._currentOffset);
                }
            } else if (messageBatch.getUnfilteredMessageCount() > 0) {
                this._idleTimer.markEventConsumed();
                StreamPartitionMsgOffset nextOffset = messageBatch.getOffsetOfNextBatch();
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("Skipped empty batch. Advancing from {} to {}", (Object)this._currentOffset, (Object)nextOffset);
                }
                this._currentOffset = nextOffset;
                lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(nextOffset);
            } else {
                long timeSinceStreamLastCreatedOrConsumedMs = this._idleTimer.getTimeSinceStreamLastCreatedOrConsumedMs();
                if (idleTimeoutMillis >= 0L && timeSinceStreamLastCreatedOrConsumedMs > idleTimeoutMillis) {
                    this.recreateStreamConsumer(String.format("Total idle time: %d ms exceeded idle timeout: %d ms", timeSinceStreamLastCreatedOrConsumedMs, idleTimeoutMillis));
                    this._idleTimer.markStreamCreated();
                }
            }
            if (!endCriteriaReached) continue;
            break;
        }
        if (this._numRowsErrored > 0) {
            this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
            this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
        }
        return true;
    }

    private boolean processStreamEvents(MessageBatch messageBatch, long idlePipeSleepTimeMillis) {
        int messageCount = messageBatch.getMessageCount();
        this._partitionRateLimiter.throttle(messageCount);
        this._serverRateLimiter.throttle(messageCount);
        PinotMeter realtimeRowsConsumedMeter = null;
        PinotMeter realtimeRowsDroppedMeter = null;
        PinotMeter realtimeIncompleteRowsConsumedMeter = null;
        PinotMeter realtimeRowsSanitizedMeter = null;
        int indexedMessageCount = 0;
        int streamMessageCount = 0;
        boolean canTakeMore = true;
        TransformPipeline.Result reusedResult = new TransformPipeline.Result();
        boolean prematureExit = false;
        for (int index = 0; index < messageCount; ++index) {
            boolean bl = prematureExit = this._shouldStop || this.endCriteriaReached();
            if (prematureExit) {
                if (!this._segmentLogger.isDebugEnabled()) break;
                this._segmentLogger.debug("stop processing message batch early shouldStop: {}", (Object)this._shouldStop);
                break;
            }
            if (!canTakeMore) {
                this._segmentLogger.error("Buffer full with {} rows consumed (row limit {}, indexed {})", new Object[]{this._numRowsConsumed, this._numRowsIndexed, this._segmentMaxRowCount});
                throw new RuntimeException("Realtime segment full");
            }
            StreamMessage streamMessage = messageBatch.getStreamMessage(index);
            StreamDataDecoderResult decodedRow = this._streamDataDecoder.decode(streamMessage);
            StreamMessageMetadata metadata = streamMessage.getMetadata();
            StreamPartitionMsgOffset offset = null;
            StreamPartitionMsgOffset nextOffset = null;
            if (metadata != null) {
                offset = metadata.getOffset();
                nextOffset = metadata.getNextOffset();
            }
            if (nextOffset == null) {
                nextOffset = messageBatch.getNextStreamPartitionMsgOffsetAtIndex(index);
            }
            if (decodedRow.getException() != null) {
                realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
                ++this._numRowsErrored;
            } else {
                try {
                    this._recordEnricherPipeline.run(decodedRow.getResult());
                    this._transformPipeline.processRow(decodedRow.getResult(), reusedResult);
                }
                catch (Exception e) {
                    ++this._numRowsErrored;
                    reusedResult.getTransformedRows().clear();
                    String errorMessage = String.format("Caught exception while transforming the record at offset: %s , row: %s", offset, decodedRow.getResult());
                    this._segmentLogger.error(errorMessage, (Throwable)e);
                    this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, e));
                }
                if (reusedResult.getSkippedRowCount() > 0) {
                    realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_FILTERED, (long)reusedResult.getSkippedRowCount(), realtimeRowsDroppedMeter);
                    if (this._trackFilteredMessageOffsets) {
                        this._filteredMessageOffsets.add(offset.toString());
                    }
                }
                if (reusedResult.getIncompleteRowCount() > 0) {
                    realtimeIncompleteRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.INCOMPLETE_REALTIME_ROWS_CONSUMED, (long)reusedResult.getIncompleteRowCount(), realtimeIncompleteRowsConsumedMeter);
                }
                if (reusedResult.getSanitizedRowCount() > 0) {
                    realtimeRowsSanitizedMeter = this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_SANITIZED, (long)reusedResult.getSanitizedRowCount(), realtimeRowsSanitizedMeter);
                }
                List transformedRows = reusedResult.getTransformedRows();
                for (GenericRow transformedRow : transformedRows) {
                    try {
                        canTakeMore = this._realtimeSegment.index(transformedRow, (RowMetadata)metadata);
                        ++indexedMessageCount;
                        this._lastRowMetadata = metadata;
                        this._lastConsumedTimestampMs = System.currentTimeMillis();
                        realtimeRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, realtimeRowsConsumedMeter);
                        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L);
                    }
                    catch (Exception e) {
                        ++this._numRowsErrored;
                        String errorMessage = String.format("Caught exception while indexing the record at offset: %s , row: %s", offset, transformedRow);
                        this._segmentLogger.error(errorMessage, (Throwable)e);
                        this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, e));
                    }
                }
            }
            this._currentOffset = nextOffset;
            this._numRowsIndexed = this._realtimeSegment.getNumDocsIndexed();
            ++this._numRowsConsumed;
            ++streamMessageCount;
        }
        this.updateCurrentDocumentCountMetrics();
        if (messageBatch.getUnfilteredMessageCount() > 0) {
            this.updateIngestionMetrics((RowMetadata)messageBatch.getLastMessageMetadata());
            this._hasMessagesFetched = true;
            if (streamMessageCount > 0 && this._segmentLogger.isDebugEnabled()) {
                this._segmentLogger.debug("Indexed {} messages ({} messages read from stream) current offset {}", new Object[]{indexedMessageCount, streamMessageCount, this._currentOffset});
            }
        } else if (!prematureExit) {
            this.setIngestionDelayToZero();
            if (this._segmentLogger.isDebugEnabled()) {
                this._segmentLogger.debug("empty batch received - sleeping for {}ms", (Object)idlePipeSleepTimeMillis);
            }
            Uninterruptibles.sleepUninterruptibly((long)idlePipeSleepTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return prematureExit;
    }

    @VisibleForTesting
    protected StreamPartitionMsgOffset extractOffset(SegmentCompletionProtocol.Response response) {
        return this._streamPartitionMsgOffsetFactory.create(response.getStreamPartitionMsgOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSegmentForCommit(long buildTimeLeaseMs) {
        try {
            File segmentTarFile;
            if (this._segmentBuildDescriptor != null && this._segmentBuildDescriptor.getOffset().compareTo((Object)this._currentOffset) == 0 && (segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile()) != null && segmentTarFile.exists()) {
                return;
            }
            this.removeSegmentFile();
            if (buildTimeLeaseMs <= 0L) {
                buildTimeLeaseMs = this._segBuildSemaphore == null ? (long)SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds() * 1000L : 30000L;
            }
            this._leaseExtender.addSegment(this._segmentNameStr, buildTimeLeaseMs, this._currentOffset);
            this._segmentBuildDescriptor = this.buildSegmentInternal(true);
        }
        finally {
            this._leaseExtender.removeSegment(this._segmentNameStr);
        }
    }

    public Map<String, String> getPartitionToCurrentOffset() {
        return Collections.singletonMap(String.valueOf(this._partitionGroupId), this._currentOffset.toString());
    }

    public CommonConstants.ConsumerState getConsumerState() {
        return this._state == State.ERROR ? CommonConstants.ConsumerState.NOT_CONSUMING : CommonConstants.ConsumerState.CONSUMING;
    }

    public long getLastConsumedTimestamp() {
        return this._lastConsumedTimestampMs;
    }

    public Map<String, ConsumerPartitionState> getConsumerPartitionState() {
        String partitionGroupId = String.valueOf(this._partitionGroupId);
        return Collections.singletonMap(partitionGroupId, new ConsumerPartitionState(partitionGroupId, this.getCurrentOffset(), this.getLastConsumedTimestamp(), this.fetchLatestStreamOffset(5000L), this._lastRowMetadata));
    }

    public Map<String, PartitionLagState> getPartitionToLagState(Map<String, ConsumerPartitionState> consumerPartitionStateMap) {
        if (this._partitionMetadataProvider == null) {
            this.createPartitionMetadataProvider("Get Partition Lag State");
        }
        return this._partitionMetadataProvider.getCurrentPartitionLagState(consumerPartitionStateMap);
    }

    private void reportDataLoss(MessageBatch messageBatch) {
        if (messageBatch.hasDataLoss()) {
            this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.STREAM_DATA_LOSS, 1L);
            String message = String.format("Message loss detected in stream partition: %s for table: %s startOffset: %s batchFirstOffset: %s", this._partitionGroupId, this._tableNameWithType, this._startOffset, messageBatch.getFirstMessageOffset());
            this._segmentLogger.error(message);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), message, null));
        }
    }

    public StreamPartitionMsgOffset getCurrentOffset() {
        return this._currentOffset;
    }

    public StreamPartitionMsgOffset getLatestStreamOffsetAtStartupTime() {
        return this._latestStreamOffsetAtStartupTime;
    }

    @VisibleForTesting
    SegmentBuildDescriptor getSegmentBuildDescriptor() {
        return this._segmentBuildDescriptor;
    }

    @VisibleForTesting
    Semaphore getPartitionGroupConsumerSemaphore() {
        return this._partitionGroupConsumerSemaphore;
    }

    @VisibleForTesting
    AtomicBoolean getAcquiredConsumerSemaphore() {
        return this._acquiredConsumerSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    SegmentBuildDescriptor buildSegmentInternal(boolean forCommit) {
        long segmentSizeBytes;
        File indexDir;
        File dataDir;
        long waitTimeMillis;
        long buildTimeMillis;
        File tempSegmentFolder;
        if (this._allowConsumptionDuringCommit) {
            this.closeStreamConsumers();
        }
        if (this._realtimeTableDataManager.isShutDown()) {
            this._segmentLogger.warn("Table data manager is already shut down");
            return null;
        }
        try {
            long startTimeMillis = this.now();
            if (this._segBuildSemaphore != null) {
                this._segmentLogger.info("Waiting to acquire semaphore for building segment");
                this._segBuildSemaphore.acquire();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, 1L);
            long lockAcquireTimeMillis = this.now();
            tempSegmentFolder = new File(this._resourceTmpDir, "tmp-" + this._segmentNameStr + "-" + this.now());
            SegmentZKPropsConfig segmentZKPropsConfig = new SegmentZKPropsConfig();
            segmentZKPropsConfig.setStartOffset(this._segmentZKMetadata.getStartOffset());
            segmentZKPropsConfig.setEndOffset(this._currentOffset.toString());
            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(this._realtimeSegment, segmentZKPropsConfig, tempSegmentFolder.getAbsolutePath(), this._schema, this._tableNameWithType, this._tableConfig, this._segmentZKMetadata.getSegmentName(), this._columnIndicesForRealtimeTable, this._nullHandlingEnabled);
            this._segmentLogger.info("Trying to build segment");
            try {
                converter.build(this._segmentVersion, this._serverMetrics);
            }
            catch (Exception e) {
                this._segmentLogger.error("Could not build segment", (Throwable)e);
                FileUtils.deleteQuietly((File)tempSegmentFolder);
                this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), "Could not build segment", e));
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            buildTimeMillis = this.now() - lockAcquireTimeMillis;
            waitTimeMillis = lockAcquireTimeMillis - startTimeMillis;
            this._segmentLogger.info("Successfully built segment (Column Mode: {}) in {} ms, after lockWaitTime {} ms", new Object[]{converter.isColumnMajorEnabled(), buildTimeMillis, waitTimeMillis});
            dataDir = new File(this._resourceDataDir);
            indexDir = new File(dataDir, this._segmentNameStr);
            FileUtils.deleteQuietly((File)indexDir);
            File[] tempFiles = tempSegmentFolder.listFiles();
            assert (tempFiles != null);
            File tempIndexDir = tempFiles[0];
            try {
                FileUtils.moveDirectory((File)tempIndexDir, (File)indexDir);
            }
            catch (IOException e) {
                String errorMessage = String.format("Caught exception while moving index directory from: %s to: %s", tempIndexDir, indexDir);
                this._segmentLogger.error(errorMessage, (Throwable)e);
                this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            segmentSizeBytes = FileUtils.sizeOfDirectory((File)indexDir);
        }
        catch (InterruptedException e) {
            String errorMessage = "Interrupted while waiting for semaphore";
            this._segmentLogger.error(errorMessage, (Throwable)e);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            return segmentBuildDescriptor;
        }
        this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(buildTimeMillis));
        this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS, TimeUnit.MILLISECONDS.toSeconds(waitTimeMillis));
        if (!forCommit) return new SegmentBuildDescriptor(null, null, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        File segmentTarFile = new File(dataDir, this._segmentNameStr + ".tar.gz");
        try {
            TarGzCompressionUtils.createTarGzFile((File)indexDir, (File)segmentTarFile);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught exception while taring index directory from: %s to: %s", indexDir, segmentTarFile);
            this._segmentLogger.error(errorMessage, (Throwable)e);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
            return segmentBuildDescriptor;
        }
        File metadataFile = SegmentDirectoryPaths.findMetadataFile((File)indexDir);
        if (metadataFile == null) {
            String errorMessage = String.format("Failed to find file: %s under index directory: %s", "metadata.properties", indexDir);
            this._segmentLogger.error(errorMessage);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, null));
            return null;
        }
        File creationMetaFile = SegmentDirectoryPaths.findCreationMetaFile((File)indexDir);
        if (creationMetaFile == null) {
            String errorMessage = String.format("Failed to find file: %s under index directory: %s", "creation.meta", indexDir);
            this._segmentLogger.error(errorMessage);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, null));
            return null;
        }
        HashMap<String, File> metadataFiles = new HashMap<String, File>();
        metadataFiles.put("metadata.properties", metadataFile);
        metadataFiles.put("creation.meta", creationMetaFile);
        return new SegmentBuildDescriptor(segmentTarFile, metadataFiles, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        finally {
            FileUtils.deleteQuietly((File)tempSegmentFolder);
        }
        finally {
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
        }
    }

    @VisibleForTesting
    boolean commitSegment(String controllerVipUrl) throws Exception {
        File segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile();
        Preconditions.checkState((segmentTarFile != null && segmentTarFile.exists() ? 1 : 0) != 0, (String)"Segment tar file: %s does not exist", (Object)segmentTarFile);
        SegmentCompletionProtocol.Response commitResponse = this.commit(controllerVipUrl);
        if (commitResponse.getStatus() != SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS) {
            this._segmentLogger.warn("Controller response was {} and not {}", (Object)commitResponse.getStatus(), (Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS);
            return false;
        }
        this._realtimeTableDataManager.replaceConsumingSegment(this._segmentNameStr);
        this.removeSegmentFile();
        return true;
    }

    @VisibleForTesting
    SegmentCompletionProtocol.Response commit(String controllerVipUrl) {
        SegmentCommitter segmentCommitter;
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withSegmentName(this._segmentNameStr).withStreamPartitionMsgOffset(this._currentOffset.toString()).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId).withReason(this._stopReason).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        try {
            segmentCommitter = this._segmentCommitterFactory.createSegmentCommitter(params, controllerVipUrl);
        }
        catch (URISyntaxException e) {
            this._segmentLogger.error("Failed to create a segment committer: ", (Throwable)e);
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return segmentCommitter.commit(this._segmentBuildDescriptor);
    }

    protected boolean buildSegmentAndReplace() throws Exception {
        SegmentBuildDescriptor descriptor = this.buildSegmentInternal(false);
        if (descriptor == null) {
            return false;
        }
        this._realtimeTableDataManager.replaceConsumingSegment(this._segmentNameStr);
        return true;
    }

    private void closeStreamConsumers() {
        this.closePartitionGroupConsumer();
        this.closePartitionMetadataProvider();
        if (this._acquiredConsumerSemaphore.compareAndSet(true, false)) {
            this._partitionGroupConsumerSemaphore.release();
        }
    }

    private void closePartitionGroupConsumer() {
        try {
            this._partitionGroupConsumer.close();
        }
        catch (Exception e) {
            this._segmentLogger.warn("Could not close stream consumer", (Throwable)e);
        }
    }

    private void closePartitionMetadataProvider() {
        if (this._partitionMetadataProvider != null) {
            try {
                this._partitionMetadataProvider.close();
            }
            catch (Exception e) {
                this._segmentLogger.warn("Could not close stream metadata provider", (Throwable)e);
            }
        }
    }

    private void cleanupMetrics() {
        this._serverMetrics.removeTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING);
    }

    protected void hold() throws InterruptedException {
        Thread.sleep(3000L);
    }

    protected void postStopConsumedMsg(String reason) {
        SegmentCompletionProtocol.Response response;
        ConsumptionStopIndicator indicator = new ConsumptionStopIndicator(this._currentOffset, this._segmentNameStr, this._instanceId, this._protocolHandler, reason, this._segmentLogger);
        while ((response = indicator.postSegmentStoppedConsuming()).getStatus() != SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            this._segmentLogger.info("Retrying after response {}", (Object)response.toJsonString());
            if (!this._shouldStop) continue;
        }
    }

    protected SegmentCompletionProtocol.Response postSegmentConsumedMsg() {
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withStreamPartitionMsgOffset(this._currentOffset.toString()).withSegmentName(this._segmentNameStr).withReason(this._stopReason).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId);
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        return this._protocolHandler.segmentConsumed(params);
    }

    private void removeSegmentFile() {
        if (this._segmentBuildDescriptor != null) {
            this._segmentBuildDescriptor.deleteSegmentFile();
            this._segmentBuildDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void goOnlineFromConsuming(SegmentZKMetadata segmentZKMetadata) throws InterruptedException {
        this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        try {
            this.removeSegmentFile();
            this._leaseExtender.removeSegment(this._segmentNameStr);
            StreamPartitionMsgOffset endOffset = this._streamPartitionMsgOffsetFactory.create(segmentZKMetadata.getEndOffset());
            this._segmentLogger.info("State: {}, transitioning from CONSUMING to ONLINE (startOffset: {}, endOffset: {})", new Object[]{this._state, this._startOffset, endOffset});
            this.stop();
            this._segmentLogger.info("Consumer thread stopped in state {}", (Object)this._state);
            switch (this._state) {
                case COMMITTED: 
                case RETAINED: {
                    this._segmentLogger.info("State {}. Nothing to do", (Object)this._state.toString());
                    return;
                }
                case DISCARDED: 
                case ERROR: {
                    this._segmentLogger.info("State {}. Downloading to replace", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(segmentZKMetadata);
                    return;
                }
                case INITIAL_CONSUMING: 
                case CATCHING_UP: 
                case HOLDING: {
                    switch (this._segmentCompletionMode) {
                        case DOWNLOAD: {
                            this._segmentLogger.info("State {}. CompletionMode {}. Downloading to replace", (Object)this._state.toString(), (Object)this._segmentCompletionMode);
                            this.downloadSegmentAndReplace(segmentZKMetadata);
                            return;
                        }
                        case DEFAULT: {
                            if (this._currentOffset.compareTo((Object)endOffset) > 0) {
                                this._segmentLogger.warn("Current offset {} ahead of the offset in zk {}. Downloading to replace", (Object)this._currentOffset, (Object)endOffset);
                                this.downloadSegmentAndReplace(segmentZKMetadata);
                                return;
                            } else if (this._currentOffset.compareTo((Object)endOffset) == 0) {
                                this._segmentLogger.info("Current offset {} matches offset in zk {}. Replacing segment", (Object)this._currentOffset, (Object)endOffset);
                                this.buildSegmentAndReplace();
                                return;
                            } else {
                                this._segmentLogger.info("Attempting to catch up from offset {} to {} ", (Object)this._currentOffset, (Object)endOffset);
                                boolean success = this.catchupToFinalOffset(endOffset, TimeUnit.MILLISECONDS.convert(31L, TimeUnit.SECONDS));
                                if (success) {
                                    this._segmentLogger.info("Caught up to offset {}", (Object)this._currentOffset);
                                    this.buildSegmentAndReplace();
                                    return;
                                } else {
                                    this._segmentLogger.info("Could not catch up to offset (current = {}). Downloading to replace", (Object)this._currentOffset);
                                    this.downloadSegmentAndReplace(segmentZKMetadata);
                                    return;
                                }
                            }
                        }
                    }
                    return;
                }
                default: {
                    this._segmentLogger.info("Downloading to replace segment while in state {}", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(segmentZKMetadata);
                    return;
                }
            }
        }
        catch (Exception e) {
            Utils.rethrowException((Throwable)e);
            return;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    protected void downloadSegmentAndReplace(SegmentZKMetadata segmentZKMetadata) throws Exception {
        if (this._allowConsumptionDuringCommit) {
            this.closeStreamConsumers();
        }
        this._realtimeTableDataManager.downloadAndReplaceConsumingSegment(segmentZKMetadata);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean catchupToFinalOffset(StreamPartitionMsgOffset endOffset, long timeoutMs) {
        this._finalOffset = endOffset;
        this._consumeEndTime = this.now() + timeoutMs;
        this._state = State.CONSUMING_TO_ONLINE;
        this._shouldStop = false;
        try {
            this.consumeLoop();
        }
        catch (Exception e) {
            this._segmentLogger.warn("Exception when catching up to final offset", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
        if (this._currentOffset.compareTo((Object)endOffset) != 0) {
            this._segmentLogger.warn("Could not consume up to {} (current offset {})", (Object)endOffset, (Object)this._currentOffset);
            return false;
        }
        return true;
    }

    public void doOffload() {
        try {
            this.stop();
        }
        catch (Exception e) {
            this._segmentLogger.error("Caught exception while stopping the consumer thread", (Throwable)e);
        }
        this.closeStreamConsumers();
        this.cleanupMetrics();
        this._realtimeSegment.offload();
    }

    protected void doDestroy() {
        this._realtimeSegment.destroy();
    }

    public void startConsumption() {
        this._consumerThread = new Thread((Runnable)new PartitionConsumer(), this._segmentNameStr);
        this._segmentLogger.info("Created new consumer thread {} for {}", (Object)this._consumerThread, (Object)this);
        this._consumerThread.start();
    }

    public void stop() throws InterruptedException {
        this._shouldStop = true;
        if (Thread.currentThread() != this._consumerThread && this._consumerThread.isAlive()) {
            this._consumerThread.interrupt();
            this._consumerThread.join();
        }
    }

    public RealtimeSegmentDataManager(SegmentZKMetadata segmentZKMetadata, TableConfig tableConfig, RealtimeTableDataManager realtimeTableDataManager, String resourceDataDir, IndexLoadingConfig indexLoadingConfig, Schema schema, LLCSegmentName llcSegmentName, Semaphore partitionGroupConsumerSemaphore, ServerMetrics serverMetrics, @Nullable PartitionUpsertMetadataManager partitionUpsertMetadataManager, @Nullable PartitionDedupMetadataManager partitionDedupMetadataManager, BooleanSupplier isReadyToConsumeData) throws AttemptsExceededException, RetriableOperationException {
        int segmentMaxRowCount;
        String sortedColumn;
        List sortedColumns;
        this._segBuildSemaphore = realtimeTableDataManager.getSegmentBuildSemaphore();
        this._segmentZKMetadata = segmentZKMetadata;
        this._tableConfig = tableConfig;
        this._tableNameWithType = this._tableConfig.getTableName();
        this._realtimeTableDataManager = realtimeTableDataManager;
        this._resourceDataDir = resourceDataDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._serverMetrics = serverMetrics;
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._isReadyToConsumeData = isReadyToConsumeData;
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this._instanceId = this._realtimeTableDataManager.getInstanceId();
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getLeaseExtender(this._tableNameWithType);
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(this._serverMetrics, this._tableNameWithType);
        CompletionConfig completionConfig = this._tableConfig.getValidationConfig().getCompletionConfig();
        this._segmentCompletionMode = completionConfig != null && CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD.toString().equalsIgnoreCase(completionConfig.getCompletionMode()) ? CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD : CommonConstants.Segment.Realtime.CompletionMode.DEFAULT;
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        IndexingConfig indexingConfig = this._tableConfig.getIndexingConfig();
        this._streamConfig = new StreamConfig(this._tableNameWithType, IngestionConfigUtils.getStreamConfigMap((TableConfig)this._tableConfig));
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._streamConfig);
        this._streamPartitionMsgOffsetFactory = this._streamConsumerFactory.createStreamMsgOffsetFactory();
        String streamTopic = this._streamConfig.getTopicName();
        this._segmentNameStr = this._segmentZKMetadata.getSegmentName();
        this._partitionGroupId = llcSegmentName.getPartitionGroupId();
        this._partitionGroupConsumptionStatus = new PartitionGroupConsumptionStatus(this._partitionGroupId, llcSegmentName.getSequenceNumber(), this._streamPartitionMsgOffsetFactory.create(this._segmentZKMetadata.getStartOffset()), this._segmentZKMetadata.getEndOffset() == null ? null : this._streamPartitionMsgOffsetFactory.create(this._segmentZKMetadata.getEndOffset()), this._segmentZKMetadata.getStatus().toString());
        this._partitionGroupConsumerSemaphore = partitionGroupConsumerSemaphore;
        this._acquiredConsumerSemaphore = new AtomicBoolean(false);
        InstanceDataManagerConfig instanceDataManagerConfig = this._indexLoadingConfig.getInstanceDataManagerConfig();
        String clientIdSuffix = instanceDataManagerConfig != null ? instanceDataManagerConfig.getConsumerClientIdSuffix() : null;
        this._clientId = StringUtils.isNotBlank((CharSequence)clientIdSuffix) ? this._tableNameWithType + "-" + streamTopic + "-" + this._partitionGroupId + "-" + clientIdSuffix : this._tableNameWithType + "-" + streamTopic + "-" + this._partitionGroupId;
        this._segmentLogger = LoggerFactory.getLogger((String)(RealtimeSegmentDataManager.class.getName() + "_" + this._segmentNameStr));
        this._tableStreamName = this._tableNameWithType + "_" + streamTopic;
        this._memoryManager = this._indexLoadingConfig.isRealtimeOffHeapAllocation() && !this._indexLoadingConfig.isDirectRealtimeOffHeapAllocation() ? new MmapMemoryManager(this._realtimeTableDataManager.getConsumerDir(), this._segmentNameStr, this._serverMetrics) : new DirectMemoryManager(this._segmentNameStr, this._serverMetrics);
        this._partitionRateLimiter = RealtimeConsumptionRateManager.getInstance().createRateLimiter(this._streamConfig, this._tableNameWithType, this._serverMetrics, this._clientId);
        this._serverRateLimiter = RealtimeConsumptionRateManager.getInstance().getServerRateLimiter();
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getStreamIngestionConfig() != null) {
            this._trackFilteredMessageOffsets = tableConfig.getIngestionConfig().getStreamIngestionConfig().isTrackFilteredMessageOffsets();
        }
        if ((sortedColumns = indexLoadingConfig.getSortedColumns()).isEmpty()) {
            this._segmentLogger.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)llcSegmentName);
            sortedColumn = null;
        } else {
            String firstSortedColumn = (String)sortedColumns.get(0);
            if (this._schema.hasColumn(firstSortedColumn)) {
                this._segmentLogger.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)llcSegmentName);
                sortedColumn = firstSortedColumn;
            } else {
                this._segmentLogger.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)llcSegmentName);
                sortedColumn = null;
            }
        }
        if (sortedColumn != null) {
            indexLoadingConfig.addInvertedIndexColumns(new String[]{sortedColumn});
        }
        if ((segmentMaxRowCount = segmentZKMetadata.getSizeThresholdToFlushSegment()) <= 0) {
            segmentMaxRowCount = this._streamConfig.getFlushThresholdRows();
        }
        if (segmentMaxRowCount <= 0) {
            segmentMaxRowCount = 5000000;
        }
        this._segmentMaxRowCount = segmentMaxRowCount;
        this._isOffHeap = indexLoadingConfig.isRealtimeOffHeapAllocation();
        this._nullHandlingEnabled = indexingConfig.isNullHandlingEnabled();
        this._columnIndicesForRealtimeTable = new ColumnIndicesForRealtimeTable(sortedColumn, new ArrayList(indexLoadingConfig.getInvertedIndexColumns()), new ArrayList(indexLoadingConfig.getTextIndexColumns()), new ArrayList(indexLoadingConfig.getFSTIndexColumns()), new ArrayList(indexLoadingConfig.getNoDictionaryColumns()), new ArrayList(indexLoadingConfig.getVarLengthDictionaryColumns()));
        String consumerDir = realtimeTableDataManager.getConsumerDir();
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder(indexLoadingConfig).setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentNameStr).setStreamName(streamTopic).setSchema(this._schema).setTimeColumnName(timeColumnName).setCapacity(this._segmentMaxRowCount).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setSegmentZKMetadata(segmentZKMetadata).setOffHeap(this._isOffHeap).setMemoryManager(this._memoryManager).setStatsHistory(realtimeTableDataManager.getStatsHistory()).setAggregateMetrics(indexingConfig.isAggregateMetrics()).setIngestionAggregationConfigs(IngestionConfigUtils.getAggregationConfigs((TableConfig)tableConfig)).setNullHandlingEnabled(this._nullHandlingEnabled).setConsumerDir(consumerDir).setUpsertMode(tableConfig.getUpsertMode()).setPartitionUpsertMetadataManager(partitionUpsertMetadataManager).setPartitionDedupMetadataManager(partitionDedupMetadataManager).setUpsertComparisonColumns(tableConfig.getUpsertComparisonColumns()).setUpsertDeleteRecordColumn(tableConfig.getUpsertDeleteRecordColumn()).setUpsertOutOfOrderRecordColumn(tableConfig.getOutOfOrderRecordColumn()).setUpsertDropOutOfOrderRecord(tableConfig.isDropOutOfOrderRecord()).setFieldConfigList(tableConfig.getFieldConfigList());
        Set fieldsToRead = IngestionUtils.getFieldsForRecordExtractor((IngestionConfig)this._tableConfig.getIngestionConfig(), (Schema)this._schema);
        ExponentialBackoffRetryPolicy retryPolicy = RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)1000L, (double)1.2f);
        AtomicReference localStreamDataDecoder = new AtomicReference();
        try {
            retryPolicy.attempt(() -> {
                try {
                    StreamMessageDecoder streamMessageDecoder = this.createMessageDecoder(fieldsToRead);
                    localStreamDataDecoder.set(new StreamDataDecoderImpl(streamMessageDecoder));
                    return true;
                }
                catch (Exception e) {
                    this._segmentLogger.warn("Failed to initialize the StreamMessageDecoder: ", (Throwable)e);
                    return false;
                }
            });
        }
        catch (Exception e) {
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), "Failed to initialize the StreamMessageDecoder", e));
            throw e;
        }
        this._streamDataDecoder = (StreamDataDecoder)localStreamDataDecoder.get();
        try {
            this._recordEnricherPipeline = RecordEnricherPipeline.fromTableConfig((TableConfig)tableConfig);
        }
        catch (Exception e) {
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), "Failed to initialize the RecordEnricherPipeline", e));
            throw e;
        }
        this._transformPipeline = new TransformPipeline(tableConfig, schema);
        try {
            this._partitionGroupConsumerSemaphore.acquire();
            this._acquiredConsumerSemaphore.set(true);
        }
        catch (InterruptedException e) {
            String errorMsg = "InterruptedException when acquiring the partitionConsumerSemaphore";
            this._segmentLogger.error(errorMsg);
            throw new RuntimeException(errorMsg + " for segment: " + this._segmentNameStr);
        }
        try {
            this._startOffset = this._partitionGroupConsumptionStatus.getStartOffset();
            this._currentOffset = this._streamPartitionMsgOffsetFactory.create(this._startOffset);
            this.makeStreamConsumer("Starting");
            this.createPartitionMetadataProvider("Starting");
            this.setPartitionParameters(realtimeSegmentConfigBuilder, indexingConfig.getSegmentPartitionConfig());
            this._realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build(), serverMetrics);
            this._resourceTmpDir = new File(resourceDataDir, RESOURCE_TEMP_DIR_NAME);
            if (!this._resourceTmpDir.exists()) {
                this._resourceTmpDir.mkdirs();
            }
            this._state = State.INITIAL_CONSUMING;
            this._latestStreamOffsetAtStartupTime = this.fetchLatestStreamOffset(5000L);
            this._consumeStartTime = this.now();
            this.setConsumeEndTime(segmentZKMetadata, this._consumeStartTime);
            this._segmentCommitterFactory = new SegmentCommitterFactory(this._segmentLogger, this._protocolHandler, tableConfig, indexLoadingConfig, serverMetrics);
            this._segmentLogger.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{llcSegmentName, this._segmentMaxRowCount, new DateTime(this._consumeEndTime, DateTimeZone.UTC)});
            this._allowConsumptionDuringCommit = !this._realtimeTableDataManager.isPartialUpsertEnabled() ? true : this._tableConfig.getUpsertConfig().isAllowPartialUpsertConsumptionDuringCommit();
        }
        catch (Exception e) {
            this._partitionGroupConsumerSemaphore.release();
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), "Failed to initialize segment data manager", e));
            this._segmentLogger.warn("Scheduling task to call controller to mark the segment as OFFLINE in Ideal State due to initialization error: '{}'", (Object)e.getMessage());
            new Thread(() -> {
                ConsumptionStopIndicator indicator = new ConsumptionStopIndicator(this._currentOffset, this._segmentNameStr, this._instanceId, this._protocolHandler, "Consuming segment initialization error", this._segmentLogger);
                try {
                    Thread.sleep(30000L);
                    indicator.postSegmentStoppedConsuming();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }).start();
            throw e;
        }
    }

    private void setConsumeEndTime(SegmentZKMetadata segmentZKMetadata, long now) {
        long maxConsumeTimeMillis = this._streamConfig.getFlushThresholdTimeMillis();
        this._consumeEndTime = segmentZKMetadata.getCreationTime() + maxConsumeTimeMillis;
        long minConsumeTimeMillis = Math.min(maxConsumeTimeMillis, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES));
        if (this._consumeEndTime - now < minConsumeTimeMillis) {
            this._consumeEndTime = now + minConsumeTimeMillis;
        }
    }

    public long getTimeSinceEventLastConsumedMs() {
        return this._idleTimer.getTimeSinceEventLastConsumedMs();
    }

    public StreamPartitionMsgOffset fetchLatestStreamOffset(long maxWaitTimeMs) {
        return this.fetchStreamOffset(OffsetCriteria.LARGEST_OFFSET_CRITERIA, maxWaitTimeMs);
    }

    public StreamPartitionMsgOffset fetchEarliestStreamOffset(long maxWaitTimeMs) {
        return this.fetchStreamOffset(OffsetCriteria.SMALLEST_OFFSET_CRITERIA, maxWaitTimeMs);
    }

    private StreamPartitionMsgOffset fetchStreamOffset(OffsetCriteria offsetCriteria, long maxWaitTimeMs) {
        if (this._partitionMetadataProvider == null) {
            this.createPartitionMetadataProvider("Fetch latest stream offset");
        }
        try {
            return this._partitionMetadataProvider.fetchStreamPartitionOffset(offsetCriteria, maxWaitTimeMs);
        }
        catch (Exception e) {
            this._segmentLogger.warn(String.format("Cannot fetch stream offset with criteria %s for clientId %s and partitionGroupId %d with maxWaitTime %d", offsetCriteria, this._clientId, this._partitionGroupId, maxWaitTimeMs), (Throwable)e);
            return null;
        }
    }

    private void setPartitionParameters(RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder, SegmentPartitionConfig segmentPartitionConfig) {
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            if (columnPartitionMap.size() == 1) {
                Map.Entry entry = columnPartitionMap.entrySet().iterator().next();
                String partitionColumn = (String)entry.getKey();
                ColumnPartitionConfig columnPartitionConfig = (ColumnPartitionConfig)entry.getValue();
                String partitionFunctionName = columnPartitionConfig.getFunctionName();
                int numPartitions = columnPartitionConfig.getNumPartitions();
                try {
                    int numPartitionGroups = this._partitionMetadataProvider.computePartitionGroupMetadata(this._clientId, this._streamConfig, Collections.emptyList(), 5000).size();
                    if (numPartitionGroups != numPartitions) {
                        this._segmentLogger.info("Number of stream partitions: {} does not match number of partitions in the partition config: {}, using number of stream partitions", (Object)numPartitionGroups, (Object)numPartitions);
                        numPartitions = numPartitionGroups;
                    }
                }
                catch (Exception e) {
                    this._segmentLogger.warn("Failed to get number of stream partitions in 5s, using number of partitions in the partition config: {}", (Object)numPartitions, (Object)e);
                    this.createPartitionMetadataProvider("Timeout getting number of stream partitions");
                }
                realtimeSegmentConfigBuilder.setPartitionColumn(partitionColumn);
                realtimeSegmentConfigBuilder.setPartitionFunction(PartitionFunctionFactory.getPartitionFunction((String)partitionFunctionName, (int)numPartitions, null));
                realtimeSegmentConfigBuilder.setPartitionId(this._partitionGroupId);
            } else {
                this._segmentLogger.warn("Cannot partition on multiple columns: {}", columnPartitionMap.keySet());
            }
        }
    }

    private void makeStreamConsumer(String reason) {
        if (this._partitionGroupConsumer != null) {
            this.closePartitionGroupConsumer();
        }
        this._segmentLogger.info("Creating new stream consumer for topic partition {} , reason: {}", (Object)this._clientId, (Object)reason);
        try {
            this._partitionGroupConsumer = this._streamConsumerFactory.createPartitionGroupConsumer(this._clientId, this._partitionGroupConsumptionStatus);
            this._partitionGroupConsumer.start(this._currentOffset);
        }
        catch (Exception e) {
            this._segmentLogger.error("Faced exception while trying to recreate stream consumer for topic partition {} reason {}", new Object[]{this._clientId, reason, e});
            this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.STREAM_CONSUMER_CREATE_EXCEPTIONS, 1L);
            throw e;
        }
    }

    private void recreateStreamConsumer(String reason) {
        this._segmentLogger.info("Recreating stream consumer for topic partition {}, reason: {}", (Object)this._clientId, (Object)reason);
        this._currentOffset = this._partitionGroupConsumer.checkpoint(this._currentOffset);
        this.closePartitionGroupConsumer();
        try {
            this._partitionGroupConsumer = this._streamConsumerFactory.createPartitionGroupConsumer(this._clientId, this._partitionGroupConsumptionStatus);
            this._partitionGroupConsumer.start(this._currentOffset);
        }
        catch (Exception e) {
            this._segmentLogger.error("Faced exception while trying to recreate stream consumer for topic partition {}", (Object)this._clientId, (Object)e);
            this._serverMetrics.addMeteredTableValue(this._clientId, (AbstractMetrics.Meter)ServerMeter.STREAM_CONSUMER_CREATE_EXCEPTIONS, 1L);
            throw e;
        }
    }

    private void createPartitionMetadataProvider(String reason) {
        this.closePartitionMetadataProvider();
        this._segmentLogger.info("Creating new partition metadata provider, reason: {}", (Object)reason);
        this._partitionMetadataProvider = this._streamConsumerFactory.createPartitionMetadataProvider(this._clientId, this._partitionGroupId);
    }

    private void updateIngestionMetrics(RowMetadata metadata) {
        if (metadata != null) {
            try {
                StreamPartitionMsgOffset latestOffset = this._partitionMetadataProvider.fetchStreamPartitionOffset(OffsetCriteria.LARGEST_OFFSET_CRITERIA, 5000L);
                this._realtimeTableDataManager.updateIngestionMetrics(metadata.getRecordIngestionTimeMs(), metadata.getFirstStreamRecordIngestionTimeMs(), metadata.getOffset(), latestOffset, this._partitionGroupId);
            }
            catch (Exception e) {
                this._segmentLogger.warn("Failed to fetch latest offset for updating ingestion delay", (Throwable)e);
            }
        }
    }

    private void setIngestionDelayToZero() {
        long currentTimeMs = System.currentTimeMillis();
        this._realtimeTableDataManager.updateIngestionMetrics(currentTimeMs, currentTimeMs, null, null, this._partitionGroupId);
    }

    private void updateCurrentDocumentCountMetrics() {
        long prevTime;
        long rowsIndexed = (long)this._numRowsIndexed - this._lastUpdatedRowsIndexed.get();
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, rowsIndexed);
        this._lastUpdatedRowsIndexed.set(this._numRowsIndexed);
        long now = this.now();
        int rowsConsumed = this._numRowsConsumed - this._lastConsumedCount;
        long l = prevTime = this._lastLogTime == 0L ? this._consumeStartTime : this._lastLogTime;
        if (now - prevTime > TimeUnit.MINUTES.toMillis(1L) || rowsConsumed >= 100000) {
            float consumedRate = (float)rowsConsumed * 1000.0f / (float)(now - prevTime);
            this._segmentLogger.info("Consumed {} events from (rate:{}/s), currentOffset={}, numRowsConsumedSoFar={}, numRowsIndexedSoFar={}", new Object[]{rowsConsumed, Float.valueOf(consumedRate), this._currentOffset, this._numRowsConsumed, this._numRowsIndexed});
            if (this._filteredMessageOffsets.size() > 0) {
                if (this._trackFilteredMessageOffsets) {
                    this._segmentLogger.info("Filtered events with offsets: {}", this._filteredMessageOffsets);
                }
                this._filteredMessageOffsets.clear();
            }
            this._lastConsumedCount = this._numRowsConsumed;
            this._lastLogTime = now;
        }
    }

    private StreamMessageDecoder createMessageDecoder(Set<String> fieldsToRead) {
        String decoderClass = this._streamConfig.getDecoderClass();
        try {
            Map decoderProperties = this._streamConfig.getDecoderProperties();
            StreamMessageDecoder decoder = (StreamMessageDecoder)PluginManager.get().createInstance(decoderClass);
            decoder.init(fieldsToRead, this._streamConfig, this._tableConfig, this._schema);
            return decoder;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while creating StreamMessageDecoder from stream config: " + this._streamConfig, e);
        }
    }

    public MutableSegment getSegment() {
        return this._realtimeSegment;
    }

    public String getSegmentName() {
        return this._segmentNameStr;
    }

    public void forceCommit() {
        this._forceCommitMessageReceived = true;
    }

    private static class ConsumptionStopIndicator {
        final StreamPartitionMsgOffset _offset;
        final String _segmentName;
        final String _instanceId;
        final Logger _logger;
        final ServerSegmentCompletionProtocolHandler _protocolHandler;
        final String _reason;

        private ConsumptionStopIndicator(StreamPartitionMsgOffset offset, String segmentName, String instanceId, ServerSegmentCompletionProtocolHandler protocolHandler, String reason, Logger logger) {
            this._offset = offset;
            this._segmentName = segmentName;
            this._instanceId = instanceId;
            this._protocolHandler = protocolHandler;
            this._logger = logger;
            this._reason = reason;
        }

        SegmentCompletionProtocol.Response postSegmentStoppedConsuming() {
            SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
            params.withStreamPartitionMsgOffset(this._offset.toString()).withReason(this._reason).withSegmentName(this._segmentName).withInstanceId(this._instanceId);
            SegmentCompletionProtocol.Response response = this._protocolHandler.segmentStoppedConsuming(params);
            this._logger.info("Got response {}", (Object)response.toJsonString());
            return response;
        }
    }

    public class PartitionConsumer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long initialConsumptionEnd = 0L;
            long lastCatchUpStart = 0L;
            long catchUpTimeMillis = 0L;
            RealtimeSegmentDataManager.this._startTimeMs = RealtimeSegmentDataManager.this.now();
            try {
                if (!RealtimeSegmentDataManager.this._isReadyToConsumeData.getAsBoolean()) {
                    do {
                        Thread.sleep(RealtimeTableDataManager.READY_TO_CONSUME_DATA_CHECK_INTERVAL_MS);
                    } while (!RealtimeSegmentDataManager.this._shouldStop && !RealtimeSegmentDataManager.this._isReadyToConsumeData.getAsBoolean());
                }
                if (RealtimeSegmentDataManager.this._partitionUpsertMetadataManager != null) {
                    if (RealtimeSegmentDataManager.this._tableConfig.getUpsertMetadataTTL() > 0.0) {
                        RealtimeSegmentDataManager.this._partitionUpsertMetadataManager.takeSnapshot();
                        RealtimeSegmentDataManager.this._partitionUpsertMetadataManager.removeExpiredPrimaryKeys();
                    } else {
                        RealtimeSegmentDataManager.this._partitionUpsertMetadataManager.removeExpiredPrimaryKeys();
                        RealtimeSegmentDataManager.this._partitionUpsertMetadataManager.takeSnapshot();
                    }
                }
                block18: while (!RealtimeSegmentDataManager.this._state.isFinal()) {
                    if (RealtimeSegmentDataManager.this._state.shouldConsume()) {
                        RealtimeSegmentDataManager.this.consumeLoop();
                    }
                    RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                    if (RealtimeSegmentDataManager.this._shouldStop) break;
                    if (RealtimeSegmentDataManager.this._state == State.INITIAL_CONSUMING) {
                        initialConsumptionEnd = RealtimeSegmentDataManager.this.now();
                        RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(initialConsumptionEnd - RealtimeSegmentDataManager.this._startTimeMs));
                    } else if (RealtimeSegmentDataManager.this._state == State.CATCHING_UP) {
                        RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(catchUpTimeMillis += RealtimeSegmentDataManager.this.now() - lastCatchUpStart));
                    }
                    RealtimeSegmentDataManager.this._state = State.HOLDING;
                    SegmentCompletionProtocol.Response response = RealtimeSegmentDataManager.this.postSegmentConsumedMsg();
                    SegmentCompletionProtocol.ControllerResponseStatus status = response.getStatus();
                    switch (status) {
                        case NOT_LEADER: {
                            RealtimeSegmentDataManager.this._segmentLogger.warn("Got not leader response");
                            RealtimeSegmentDataManager.this.hold();
                            break;
                        }
                        case CATCH_UP: {
                            StreamPartitionMsgOffset rspOffset = RealtimeSegmentDataManager.this.extractOffset(response);
                            if (rspOffset.compareTo((Object)RealtimeSegmentDataManager.this._currentOffset) <= 0) {
                                RealtimeSegmentDataManager.this._segmentLogger.error("Invalid catchup offset {} in controller response, current offset {}", (Object)rspOffset, (Object)RealtimeSegmentDataManager.this._currentOffset);
                                RealtimeSegmentDataManager.this.hold();
                                break;
                            }
                            RealtimeSegmentDataManager.this._state = State.CATCHING_UP;
                            RealtimeSegmentDataManager.this._finalOffset = rspOffset;
                            lastCatchUpStart = RealtimeSegmentDataManager.this.now();
                            break;
                        }
                        case HOLD: {
                            RealtimeSegmentDataManager.this.hold();
                            break;
                        }
                        case DISCARD: {
                            RealtimeSegmentDataManager.this._state = State.DISCARDED;
                            break;
                        }
                        case KEEP: {
                            if (RealtimeSegmentDataManager.this._segmentCompletionMode == CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD) {
                                RealtimeSegmentDataManager.this._state = State.DISCARDED;
                                break;
                            }
                            RealtimeSegmentDataManager.this._state = State.RETAINING;
                            Lock segmentLock = RealtimeSegmentDataManager.this._realtimeTableDataManager.getSegmentLock(RealtimeSegmentDataManager.this._segmentNameStr);
                            segmentLock.lockInterruptibly();
                            try {
                                if (RealtimeSegmentDataManager.this.buildSegmentAndReplace()) {
                                    RealtimeSegmentDataManager.this._state = State.RETAINED;
                                    continue block18;
                                }
                                RealtimeSegmentDataManager.this._state = State.ERROR;
                                RealtimeSegmentDataManager.this._segmentLogger.error("Could not build segment for {}", (Object)RealtimeSegmentDataManager.this._segmentNameStr);
                                continue block18;
                            }
                            finally {
                                segmentLock.unlock();
                                continue block18;
                            }
                        }
                        case COMMIT: {
                            RealtimeSegmentDataManager.this._state = State.COMMITTING;
                            RealtimeSegmentDataManager.this._currentOffset = RealtimeSegmentDataManager.this._partitionGroupConsumer.checkpoint(RealtimeSegmentDataManager.this._currentOffset);
                            Lock segmentLock = RealtimeSegmentDataManager.this._realtimeTableDataManager.getSegmentLock(RealtimeSegmentDataManager.this._segmentNameStr);
                            segmentLock.lockInterruptibly();
                            try {
                                long buildTimeSeconds = response.getBuildTimeSeconds();
                                RealtimeSegmentDataManager.this.buildSegmentForCommit(buildTimeSeconds * 1000L);
                                if (RealtimeSegmentDataManager.this._segmentBuildDescriptor == null) {
                                    RealtimeSegmentDataManager.this._state = State.ERROR;
                                    RealtimeSegmentDataManager.this._segmentLogger.error("Could not build segment for {}", (Object)RealtimeSegmentDataManager.this._segmentNameStr);
                                    continue block18;
                                }
                                if (RealtimeSegmentDataManager.this.commitSegment(response.getControllerVipUrl())) {
                                    RealtimeSegmentDataManager.this._state = State.COMMITTED;
                                    continue block18;
                                }
                            }
                            finally {
                                segmentLock.unlock();
                                continue block18;
                            }
                            RealtimeSegmentDataManager.this._state = State.HOLDING;
                            RealtimeSegmentDataManager.this._segmentLogger.info("Could not commit segment. Retrying after hold");
                            RealtimeSegmentDataManager.this.hold();
                            break;
                        }
                        default: {
                            RealtimeSegmentDataManager.this._segmentLogger.error("Holding after response from Controller: {}", (Object)response.toJsonString());
                            RealtimeSegmentDataManager.this.hold();
                        }
                    }
                }
            }
            catch (Exception e) {
                if (RealtimeSegmentDataManager.this._shouldStop) {
                    RealtimeSegmentDataManager.this._segmentLogger.info("Caught exception in consumer thread after stop() is invoked: {}, ignoring the exception", (Object)e.toString());
                }
                String errorMessage = "Exception while in work";
                RealtimeSegmentDataManager.this._segmentLogger.error(errorMessage, (Throwable)e);
                RealtimeSegmentDataManager.this.postStopConsumedMsg(e.getClass().getName());
                RealtimeSegmentDataManager.this._state = State.ERROR;
                RealtimeSegmentDataManager.this._realtimeTableDataManager.addSegmentError(RealtimeSegmentDataManager.this._segmentNameStr, new SegmentErrorInfo(RealtimeSegmentDataManager.this.now(), errorMessage, e));
                RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                return;
            }
            RealtimeSegmentDataManager.this.removeSegmentFile();
            if (initialConsumptionEnd != 0L) {
                RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(RealtimeSegmentDataManager.this.now() - initialConsumptionEnd));
            }
            if (!RealtimeSegmentDataManager.this._shouldStop) {
                RealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(RealtimeSegmentDataManager.this._clientId, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
            }
        }
    }

    @VisibleForTesting
    public class SegmentBuildDescriptor {
        final File _segmentTarFile;
        final Map<String, File> _metadataFileMap;
        final StreamPartitionMsgOffset _offset;
        final long _waitTimeMillis;
        final long _buildTimeMillis;
        final long _segmentSizeBytes;

        public SegmentBuildDescriptor(@Nullable File segmentTarFile, Map<String, File> metadataFileMap, StreamPartitionMsgOffset offset, long buildTimeMillis, long waitTimeMillis, long segmentSizeBytes) {
            this._segmentTarFile = segmentTarFile;
            this._metadataFileMap = metadataFileMap;
            this._offset = RealtimeSegmentDataManager.this._streamPartitionMsgOffsetFactory.create(offset);
            this._buildTimeMillis = buildTimeMillis;
            this._waitTimeMillis = waitTimeMillis;
            this._segmentSizeBytes = segmentSizeBytes;
        }

        public StreamPartitionMsgOffset getOffset() {
            return this._offset;
        }

        public long getBuildTimeMillis() {
            return this._buildTimeMillis;
        }

        public long getWaitTimeMillis() {
            return this._waitTimeMillis;
        }

        @Nullable
        public File getSegmentTarFile() {
            return this._segmentTarFile;
        }

        @Nullable
        public Map<String, File> getMetadataFiles() {
            return this._metadataFileMap;
        }

        public long getSegmentSizeBytes() {
            return this._segmentSizeBytes;
        }

        public void deleteSegmentFile() {
            if (this._segmentTarFile != null) {
                FileUtils.deleteQuietly((File)this._segmentTarFile);
            }
        }
    }

    @VisibleForTesting
    public static enum State {
        INITIAL_CONSUMING,
        CATCHING_UP,
        HOLDING,
        CONSUMING_TO_ONLINE,
        RETAINING,
        COMMITTING,
        DISCARDED,
        RETAINED,
        COMMITTED,
        ERROR;


        public boolean shouldConsume() {
            return this.equals((Object)INITIAL_CONSUMING) || this.equals((Object)CATCHING_UP) || this.equals((Object)CONSUMING_TO_ONLINE);
        }

        public boolean isFinal() {
            return this.equals((Object)ERROR) || this.equals((Object)COMMITTED) || this.equals((Object)RETAINED) || this.equals((Object)DISCARDED);
        }
    }
}

