/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.IngestionDelayTracker;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManagerFactory;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManagerFactory;
import org.apache.pinot.segment.local.utils.SchemaUtils;
import org.apache.pinot.segment.local.utils.tablestate.TableStateUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;

@ThreadSafe
public class RealtimeTableDataManager
extends BaseTableDataManager {
    private SegmentBuildTimeLeaseExtender _leaseExtender;
    private RealtimeSegmentStatsHistory _statsHistory;
    private final Semaphore _segmentBuildSemaphore;
    private final Map<Integer, Semaphore> _partitionGroupIdToSemaphoreMap = new ConcurrentHashMap<Integer, Semaphore>();
    private static final String STATS_FILE_NAME = "segment-stats.ser";
    private static final String CONSUMERS_DIR = "consumers";
    private static final int MIN_INTERVAL_BETWEEN_STATS_UPDATES_MINUTES = 30;
    public static final long READY_TO_CONSUME_DATA_CHECK_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    private final Supplier<Boolean> _isServerReadyToServeQueries;
    private IngestionDelayTracker _ingestionDelayTracker;
    private TableDedupMetadataManager _tableDedupMetadataManager;
    private TableUpsertMetadataManager _tableUpsertMetadataManager;
    private BooleanSupplier _isTableReadyToConsumeData;

    public RealtimeTableDataManager(Semaphore segmentBuildSemaphore) {
        this(segmentBuildSemaphore, () -> true);
    }

    public RealtimeTableDataManager(Semaphore segmentBuildSemaphore, Supplier<Boolean> isServerReadyToServeQueries) {
        this._segmentBuildSemaphore = segmentBuildSemaphore;
        this._isServerReadyToServeQueries = isServerReadyToServeQueries;
    }

    @Override
    protected void doInit() {
        UpsertConfig upsertConfig;
        DedupConfig dedupConfig;
        boolean dedupEnabled;
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getOrCreate(this._instanceId, this._serverMetrics, this._tableNameWithType);
        this._ingestionDelayTracker = new IngestionDelayTracker(this._serverMetrics, this._tableNameWithType, this, this._isServerReadyToServeQueries);
        File statsFile = new File(this._tableDataDir, STATS_FILE_NAME);
        try {
            this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFile);
        }
        catch (IOException | ClassNotFoundException e) {
            this._logger.error("Caught exception while reading stats history from: {}", (Object)statsFile.getAbsolutePath(), (Object)e);
            File savedFile = new File(this._tableDataDir, "segment-stats.ser." + UUID.randomUUID());
            try {
                FileUtils.moveFile((File)statsFile, (File)savedFile);
            }
            catch (IOException e1) {
                this._logger.error("Could not move {} to {}", new Object[]{statsFile.getAbsolutePath(), savedFile.getAbsolutePath(), e1});
                throw new RuntimeException(e);
            }
            this._logger.warn("Saved unreadable {} into {}. Creating a fresh instance", (Object)statsFile.getAbsolutePath(), (Object)savedFile.getAbsolutePath());
            try {
                this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFile);
            }
            catch (Exception e2) {
                Utils.rethrowException((Throwable)e2);
            }
        }
        this._statsHistory.setMinIntervalBetweenUpdatesMillis(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        String consumerDirPath = this.getConsumerDir();
        File consumerDir = new File(consumerDirPath);
        if (consumerDir.exists()) {
            File[] segmentFiles = consumerDir.listFiles((dir, name) -> !name.equals(STATS_FILE_NAME));
            Preconditions.checkState((segmentFiles != null ? 1 : 0) != 0, (String)"Failed to list segment files from consumer dir: %s for table: %s", (Object)consumerDirPath, (Object)this._tableNameWithType);
            for (File file : segmentFiles) {
                if (file.delete()) {
                    this._logger.info("Deleted old file {}", (Object)file.getAbsolutePath());
                    continue;
                }
                this._logger.error("Cannot delete file {}", (Object)file.getAbsolutePath());
            }
        }
        boolean bl = dedupEnabled = (dedupConfig = this._tableConfig.getDedupConfig()) != null && dedupConfig.isDedupEnabled();
        if (dedupEnabled) {
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)this._tableNameWithType);
            List primaryKeyColumns = schema.getPrimaryKeyColumns();
            Preconditions.checkState((!CollectionUtils.isEmpty((Collection)primaryKeyColumns) ? 1 : 0) != 0, (Object)"Primary key columns must be configured for dedup");
            this._tableDedupMetadataManager = TableDedupMetadataManagerFactory.create((TableConfig)this._tableConfig, (Schema)schema, (TableDataManager)this, (ServerMetrics)this._serverMetrics);
        }
        if ((upsertConfig = this._tableConfig.getUpsertConfig()) != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE) {
            Preconditions.checkState((!dedupEnabled ? 1 : 0) != 0, (String)"Dedup and upsert cannot be both enabled for table: %s", (Object)this._tableUpsertMetadataManager);
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)this._tableNameWithType);
            this._tableUpsertMetadataManager = TableUpsertMetadataManagerFactory.create((TableConfig)this._tableConfig, (PinotConfiguration)this._instanceDataManagerConfig.getUpsertConfig());
            this._tableUpsertMetadataManager.init(this._tableConfig, schema, (TableDataManager)this);
        }
        this._isTableReadyToConsumeData = this.isDedupEnabled() || this.isPartialUpsertEnabled() ? new BooleanSupplier(){
            volatile boolean _allSegmentsLoaded;
            long _lastCheckTimeMs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getAsBoolean() {
                if (this._allSegmentsLoaded) {
                    return true;
                }
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this._allSegmentsLoaded) {
                        return true;
                    }
                    long currentTimeMs = System.currentTimeMillis();
                    if (currentTimeMs - this._lastCheckTimeMs <= READY_TO_CONSUME_DATA_CHECK_INTERVAL_MS) {
                        return false;
                    }
                    this._lastCheckTimeMs = currentTimeMs;
                    this._allSegmentsLoaded = TableStateUtils.isAllSegmentsLoaded((HelixManager)RealtimeTableDataManager.this._helixManager, (String)RealtimeTableDataManager.this._tableNameWithType);
                    return this._allSegmentsLoaded;
                }
            }
        } : () -> true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doShutdown() {
        this._ingestionDelayTracker.shutdown();
        if (this._tableUpsertMetadataManager != null) {
            this._tableUpsertMetadataManager.stop();
            this.releaseAndRemoveAllSegments();
            try {
                this._tableUpsertMetadataManager.close();
            }
            catch (IOException e) {
                this._logger.warn("Caught exception while closing upsert metadata manager", (Throwable)e);
            }
        } else {
            this.releaseAndRemoveAllSegments();
        }
        if (this._leaseExtender != null) {
            this._leaseExtender.shutDown();
        }
    }

    public void updateIngestionMetrics(long ingestionTimeMs, long firstStreamIngestionTimeMs, StreamPartitionMsgOffset offset, StreamPartitionMsgOffset latestOffset, int partitionGroupId) {
        this._ingestionDelayTracker.updateIngestionMetrics(ingestionTimeMs, firstStreamIngestionTimeMs, offset, latestOffset, partitionGroupId);
    }

    public long getPartitionIngestionTimeMs(String segmentNameStr) {
        LLCSegmentName segmentName = new LLCSegmentName(segmentNameStr);
        int partitionGroupId = segmentName.getPartitionGroupId();
        return this._ingestionDelayTracker.getPartitionIngestionTimeMs(partitionGroupId);
    }

    public void onConsumingToDropped(String segmentNameStr) {
        LLCSegmentName segmentName = new LLCSegmentName(segmentNameStr);
        this._ingestionDelayTracker.stopTrackingPartitionIngestionDelay(segmentName.getPartitionGroupId());
    }

    public void onConsumingToOnline(String segmentNameStr) {
        LLCSegmentName segmentName = new LLCSegmentName(segmentNameStr);
        this._ingestionDelayTracker.markPartitionForVerification(segmentName.getPartitionGroupId());
    }

    @Override
    public List<SegmentContext> getSegmentContexts(List<IndexSegment> selectedSegments, Map<String, String> queryOptions) {
        ArrayList<SegmentContext> segmentContexts = new ArrayList<SegmentContext>(selectedSegments.size());
        selectedSegments.forEach(s -> segmentContexts.add(new SegmentContext(s)));
        if (this.isUpsertEnabled() && !QueryOptionsUtils.isSkipUpsert(queryOptions)) {
            this._tableUpsertMetadataManager.setSegmentContexts(segmentContexts, queryOptions);
        }
        return segmentContexts;
    }

    public Set<Integer> getHostedPartitionsGroupIds() {
        HashSet<Integer> partitionsHostedByThisServer = new HashSet<Integer>();
        List segments = TableStateUtils.getSegmentsInGivenStateForThisInstance((HelixManager)this._helixManager, (String)this._tableNameWithType, (String)"CONSUMING");
        for (String segmentNameStr : segments) {
            LLCSegmentName segmentName = new LLCSegmentName(segmentNameStr);
            partitionsHostedByThisServer.add(segmentName.getPartitionGroupId());
        }
        return partitionsHostedByThisServer;
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public Semaphore getSegmentBuildSemaphore() {
        return this._segmentBuildSemaphore;
    }

    public String getConsumerDir() {
        File consumerDir;
        Object consumerDirPath = this._instanceDataManagerConfig.getConsumerDir();
        if (consumerDirPath != null) {
            consumerDir = new File((String)consumerDirPath, this._tableNameWithType);
        } else {
            consumerDirPath = this._tableDataDir + File.separator + CONSUMERS_DIR;
            consumerDir = new File((String)consumerDirPath);
        }
        if (!consumerDir.exists() && !consumerDir.mkdirs()) {
            this._logger.error("Failed to create consumer directory {}", (Object)consumerDir.getAbsolutePath());
        }
        return consumerDir.getAbsolutePath();
    }

    public boolean isDedupEnabled() {
        return this._tableDedupMetadataManager != null;
    }

    public boolean isUpsertEnabled() {
        return this._tableUpsertMetadataManager != null;
    }

    public boolean isPartialUpsertEnabled() {
        return this._tableUpsertMetadataManager != null && this._tableUpsertMetadataManager.getUpsertMode() == UpsertConfig.Mode.PARTIAL;
    }

    private boolean isUpsertPreloadEnabled() {
        UpsertConfig upsertConfig = this._tableConfig.getUpsertConfig();
        return this._tableUpsertMetadataManager != null && this._segmentPreloadExecutor != null && upsertConfig != null && upsertConfig.isEnableSnapshot() && upsertConfig.isEnablePreload();
    }

    private void handleUpsertPreload(SegmentZKMetadata zkMetadata, IndexLoadingConfig indexLoadingConfig) {
        if (!this.isUpsertPreloadEnabled()) {
            return;
        }
        String segmentName = zkMetadata.getSegmentName();
        Integer partitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (SegmentZKMetadata)zkMetadata, null);
        Preconditions.checkState((partitionId != null ? 1 : 0) != 0, (Object)String.format("Failed to get partition id for segment: %s in upsert-enabled table: %s", segmentName, this._tableNameWithType));
        this._tableUpsertMetadataManager.getOrCreatePartitionManager(partitionId.intValue()).preloadSegments(indexLoadingConfig);
    }

    @Override
    protected void doAddOnlineSegment(String segmentName) throws Exception {
        SegmentZKMetadata zkMetadata = this.fetchZKMetadata(segmentName);
        Preconditions.checkState((zkMetadata.getStatus() != CommonConstants.Segment.Realtime.Status.IN_PROGRESS ? 1 : 0) != 0, (String)"Segment: %s of table: %s is not committed, cannot make it ONLINE", (Object)segmentName, (Object)this._tableNameWithType);
        IndexLoadingConfig indexLoadingConfig = this.fetchIndexLoadingConfig();
        indexLoadingConfig.setSegmentTier(zkMetadata.getTier());
        this.handleUpsertPreload(zkMetadata, indexLoadingConfig);
        SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager == null) {
            this.addNewOnlineSegment(zkMetadata, indexLoadingConfig);
        } else if (segmentDataManager instanceof RealtimeSegmentDataManager) {
            this._logger.info("Changing segment: {} from CONSUMING to ONLINE", (Object)segmentName);
            ((RealtimeSegmentDataManager)segmentDataManager).goOnlineFromConsuming(zkMetadata);
            this.onConsumingToOnline(segmentName);
        } else {
            this.replaceSegmentIfCrcMismatch(segmentDataManager, zkMetadata, indexLoadingConfig);
        }
    }

    public void addConsumingSegment(String segmentName) throws AttemptsExceededException, RetriableOperationException {
        Preconditions.checkState((!this._shutDown ? 1 : 0) != 0, (String)"Table data manager is already shut down, cannot add CONSUMING segment: %s to table: %s", (Object)segmentName, (Object)this._tableNameWithType);
        this._logger.info("Adding CONSUMING segment: {}", (Object)segmentName);
        Lock segmentLock = this.getSegmentLock(segmentName);
        segmentLock.lock();
        try {
            this.doAddConsumingSegment(segmentName);
        }
        catch (Exception e) {
            this.addSegmentError(segmentName, new SegmentErrorInfo(System.currentTimeMillis(), "Caught exception while adding CONSUMING segment", e));
            throw e;
        }
        finally {
            segmentLock.unlock();
        }
    }

    private void doAddConsumingSegment(String segmentName) throws AttemptsExceededException, RetriableOperationException {
        SegmentZKMetadata zkMetadata = this.fetchZKMetadata(segmentName);
        if (zkMetadata.getStatus() != CommonConstants.Segment.Realtime.Status.IN_PROGRESS) {
            this._logger.warn("Segment: {} is already committed, skipping adding it as CONSUMING segment", (Object)segmentName);
            return;
        }
        IndexLoadingConfig indexLoadingConfig = this.fetchIndexLoadingConfig();
        this.handleUpsertPreload(zkMetadata, indexLoadingConfig);
        SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager != null) {
            this._logger.warn("Segment: {} ({}) already exists, skipping adding it as CONSUMING segment", (Object)segmentName, (Object)(segmentDataManager instanceof RealtimeSegmentDataManager ? "CONSUMING" : "COMPLETED"));
            return;
        }
        this._logger.info("Adding new CONSUMING segment: {}", (Object)segmentName);
        File segmentDir = new File(this._indexDir, segmentName);
        FileUtils.deleteQuietly((File)segmentDir);
        TableConfig tableConfig = indexLoadingConfig.getTableConfig();
        Schema schema = indexLoadingConfig.getSchema();
        assert (tableConfig != null && schema != null);
        this.validate(tableConfig, schema);
        VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSegmentSchema((Schema)schema, (String)segmentName);
        RealtimeTableDataManager.setDefaultTimeValueIfInvalid(tableConfig, schema, zkMetadata);
        LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
        int partitionGroupId = llcSegmentName.getPartitionGroupId();
        Semaphore semaphore = this._partitionGroupIdToSemaphoreMap.computeIfAbsent(partitionGroupId, k -> new Semaphore(1));
        PartitionUpsertMetadataManager partitionUpsertMetadataManager = this._tableUpsertMetadataManager != null ? this._tableUpsertMetadataManager.getOrCreatePartitionManager(partitionGroupId) : null;
        PartitionDedupMetadataManager partitionDedupMetadataManager = this._tableDedupMetadataManager != null ? this._tableDedupMetadataManager.getOrCreatePartitionManager(partitionGroupId) : null;
        RealtimeSegmentDataManager realtimeSegmentDataManager = new RealtimeSegmentDataManager(zkMetadata, tableConfig, this, this._indexDir.getAbsolutePath(), indexLoadingConfig, schema, llcSegmentName, semaphore, this._serverMetrics, partitionUpsertMetadataManager, partitionDedupMetadataManager, this._isTableReadyToConsumeData);
        realtimeSegmentDataManager.startConsumption();
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        this.registerSegment(segmentName, realtimeSegmentDataManager);
        this._logger.info("Added new CONSUMING segment: {}", (Object)segmentName);
    }

    @VisibleForTesting
    static void setDefaultTimeValueIfInvalid(TableConfig tableConfig, Schema schema, SegmentZKMetadata zkMetadata) {
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        if (StringUtils.isEmpty((CharSequence)timeColumnName)) {
            return;
        }
        DateTimeFieldSpec timeColumnSpec = schema.getSpecForTimeColumn(timeColumnName);
        Preconditions.checkState((timeColumnSpec != null ? 1 : 0) != 0, (String)"Failed to find time field: %s from schema: %s", (Object)timeColumnName, (Object)schema.getSchemaName());
        String defaultTimeString = timeColumnSpec.getDefaultNullValueString();
        DateTimeFormatSpec dateTimeFormatSpec = timeColumnSpec.getFormatSpec();
        try {
            long defaultTimeMs = dateTimeFormatSpec.fromFormatToMillis(defaultTimeString);
            if (TimeUtils.timeValueInValidRange((long)defaultTimeMs)) {
                return;
            }
        }
        catch (Exception defaultTimeMs) {
            // empty catch block
        }
        String creationTimeString = dateTimeFormatSpec.fromMillisToFormat(zkMetadata.getCreationTime());
        Object creationTime = timeColumnSpec.getDataType().convert(creationTimeString);
        timeColumnSpec.setDefaultNullValue(creationTime);
        LOGGER.info("Default time: {} does not comply with format: {}, using creation time: {} as the default time for table: {}", new Object[]{defaultTimeString, timeColumnSpec.getFormat(), creationTime, tableConfig.getTableName()});
    }

    @Override
    public void addSegment(ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        Preconditions.checkState((!this._shutDown ? 1 : 0) != 0, (String)"Table data manager is already shut down, cannot add segment: %s to table: %s", (Object)segmentName, (Object)this._tableNameWithType);
        if (this.isUpsertEnabled()) {
            this.handleUpsert(immutableSegment);
            return;
        }
        if (this.isDedupEnabled() && immutableSegment instanceof ImmutableSegmentImpl) {
            this.buildDedupMeta((ImmutableSegmentImpl)immutableSegment);
        }
        super.addSegment(immutableSegment);
    }

    private void buildDedupMeta(ImmutableSegmentImpl immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        Integer partitionGroupId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)this._tableNameWithType, (HelixManager)this._helixManager, null);
        Preconditions.checkNotNull((Object)partitionGroupId, (Object)String.format("PartitionGroupId is not available for segment: '%s' (dedup-enabled table: %s)", segmentName, this._tableNameWithType));
        PartitionDedupMetadataManager partitionDedupMetadataManager = this._tableDedupMetadataManager.getOrCreatePartitionManager(partitionGroupId.intValue());
        immutableSegment.enableDedup(partitionDedupMetadataManager);
        partitionDedupMetadataManager.addSegment((IndexSegment)immutableSegment);
    }

    private void handleUpsert(ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        this._logger.info("Adding immutable segment: {} with upsert enabled", (Object)segmentName);
        Integer partitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)this._tableNameWithType, (HelixManager)this._helixManager, null);
        Preconditions.checkNotNull((Object)partitionId, (Object)String.format("Failed to get partition id for segment: %s (upsert-enabled table: %s)", segmentName, this._tableNameWithType));
        PartitionUpsertMetadataManager partitionUpsertMetadataManager = this._tableUpsertMetadataManager.getOrCreatePartitionManager(partitionId.intValue());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)immutableSegment.getSegmentMetadata().getTotalDocs());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        ImmutableSegmentDataManager newSegmentManager = new ImmutableSegmentDataManager(immutableSegment);
        if (partitionUpsertMetadataManager.isPreloading()) {
            partitionUpsertMetadataManager.preloadSegment(immutableSegment);
            this.registerSegment(segmentName, newSegmentManager);
            this._logger.info("Preloaded immutable segment: {} with upsert enabled", (Object)segmentName);
            return;
        }
        SegmentDataManager oldSegmentManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
        if (oldSegmentManager == null) {
            this.registerSegment(segmentName, newSegmentManager);
            partitionUpsertMetadataManager.addSegment(immutableSegment);
            this._logger.info("Added new immutable segment: {} with upsert enabled", (Object)segmentName);
        } else {
            IndexSegment oldSegment = oldSegmentManager.getSegment();
            partitionUpsertMetadataManager.replaceSegment(immutableSegment, oldSegment);
            this.registerSegment(segmentName, newSegmentManager);
            this._logger.info("Replaced {} segment: {} with upsert enabled", (Object)(oldSegment instanceof ImmutableSegment ? "immutable" : "mutable"), (Object)segmentName);
            oldSegmentManager.offload();
            this.releaseSegment(oldSegmentManager);
        }
    }

    public void downloadAndReplaceConsumingSegment(SegmentZKMetadata zkMetadata) throws Exception {
        String segmentName = zkMetadata.getSegmentName();
        this._logger.info("Downloading and replacing CONSUMING segment: {} with committed one", (Object)segmentName);
        File indexDir = this.downloadSegment(zkMetadata);
        IndexLoadingConfig indexLoadingConfig = this.fetchIndexLoadingConfig();
        indexLoadingConfig.setSegmentTier(zkMetadata.getTier());
        this.addSegment(ImmutableSegmentLoader.load((File)indexDir, (IndexLoadingConfig)indexLoadingConfig));
        this._logger.info("Downloaded and replaced CONSUMING segment: {}", (Object)segmentName);
    }

    public void replaceConsumingSegment(String segmentName) throws Exception {
        this._logger.info("Replacing CONSUMING segment: {} with the one sealed locally", (Object)segmentName);
        File indexDir = new File(this._indexDir, segmentName);
        IndexLoadingConfig indexLoadingConfig = this.fetchIndexLoadingConfig();
        this.addSegment(ImmutableSegmentLoader.load((File)indexDir, (IndexLoadingConfig)indexLoadingConfig));
        this._logger.info("Replaced CONSUMING segment: {}", (Object)segmentName);
    }

    public String getServerInstance() {
        return this._instanceId;
    }

    @VisibleForTesting
    public TableUpsertMetadataManager getTableUpsertMetadataManager() {
        return this._tableUpsertMetadataManager;
    }

    public Map<Integer, Long> getUpsertPartitionToPrimaryKeyCount() {
        if (this.isUpsertEnabled()) {
            return this._tableUpsertMetadataManager.getPartitionToPrimaryKeyCount();
        }
        return Collections.emptyMap();
    }

    private void validate(TableConfig tableConfig, Schema schema) {
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        List sortedColumns = indexingConfig.getSortedColumn();
        if (CollectionUtils.isNotEmpty((Collection)sortedColumns)) {
            FieldSpec fieldSpec;
            String sortedColumn = (String)sortedColumns.get(0);
            if (sortedColumns.size() > 1) {
                this._logger.warn("More than one sorted column configured. Using {}", (Object)sortedColumn);
            }
            Preconditions.checkArgument(((fieldSpec = schema.getFieldSpecFor(sortedColumn)) != null ? 1 : 0) != 0, (String)"Failed to find sorted column: %s in schema for table: %s", (Object)sortedColumn, (Object)this._tableNameWithType);
            Preconditions.checkArgument((boolean)fieldSpec.isSingleValueField(), (String)"Cannot configure multi-valued column %s as sorted column for table: %s", (Object)sortedColumn, (Object)this._tableNameWithType);
        }
        SchemaUtils.validate((Schema)schema);
    }
}

