/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentBuildTimeLeaseExtender {
    private static final int MAX_NUM_ATTEMPTS = 3;
    private static final int EXTRA_TIME_SECONDS = 120;
    private static final int REPEAT_REQUEST_PERIOD_SEC = 108;
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentBuildTimeLeaseExtender.class);
    private static final Map<String, SegmentBuildTimeLeaseExtender> TABLE_TO_LEASE_EXTENDER = new ConcurrentHashMap<String, SegmentBuildTimeLeaseExtender>();
    private static ScheduledExecutorService _executor;
    private final Map<String, Future> _segmentToFutureMap = new ConcurrentHashMap<String, Future>();
    private final String _instanceId;
    private final String _tableNameWithType;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;

    public static void initExecutor() {
        _executor = new ScheduledThreadPoolExecutor(1);
        LOGGER.info("Initialized segment build time lease extender executor");
    }

    public static void shutdownExecutor() {
        if (_executor != null) {
            _executor.shutdownNow();
            _executor = null;
        }
        LOGGER.info("Shut down segment build time lease extender executor");
    }

    @VisibleForTesting
    public static boolean isExecutorShutdown() {
        return _executor == null;
    }

    public static SegmentBuildTimeLeaseExtender getLeaseExtender(String tableNameWithType) {
        return TABLE_TO_LEASE_EXTENDER.get(tableNameWithType);
    }

    public static SegmentBuildTimeLeaseExtender getOrCreate(String instanceId, ServerMetrics serverMetrics, String tableNameWithType) {
        return TABLE_TO_LEASE_EXTENDER.compute(tableNameWithType, (k, v) -> {
            if (v == null) {
                SegmentBuildTimeLeaseExtender leaseExtender = new SegmentBuildTimeLeaseExtender(instanceId, serverMetrics, tableNameWithType);
                LOGGER.info("Created lease extender for table: {}", (Object)tableNameWithType);
                return leaseExtender;
            }
            LOGGER.warn("Lease extender for table: {} already exists", (Object)tableNameWithType);
            return v;
        });
    }

    private SegmentBuildTimeLeaseExtender(String instanceId, ServerMetrics serverMetrics, String tableNameWithType) {
        this._instanceId = instanceId;
        this._tableNameWithType = tableNameWithType;
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(serverMetrics, tableNameWithType);
    }

    public void shutDown() {
        for (Map.Entry<String, Future> entry : this._segmentToFutureMap.entrySet()) {
            Future future = entry.getValue();
            boolean cancelled = future.cancel(true);
            if (cancelled) continue;
            LOGGER.warn("Task could not be cancelled for {}", (Object)entry.getKey());
        }
        this._segmentToFutureMap.clear();
        TABLE_TO_LEASE_EXTENDER.remove(this._tableNameWithType);
    }

    public void addSegment(String segmentId, long initialBuildTimeMs, StreamPartitionMsgOffset offset) {
        long initialDelayMs = initialBuildTimeMs * 9L / 10L;
        SegmentCompletionProtocol.Request.Params reqParams = new SegmentCompletionProtocol.Request.Params();
        reqParams.withStreamPartitionMsgOffset(offset.toString()).withSegmentName(segmentId).withExtraTimeSec(120).withInstanceId(this._instanceId);
        ScheduledFuture<?> future = _executor.scheduleWithFixedDelay(new LeaseExtender(reqParams), initialDelayMs, 108000L, TimeUnit.MILLISECONDS);
        this._segmentToFutureMap.put(segmentId, future);
    }

    public void removeSegment(String segmentId) {
        boolean cancelled;
        Future future = this._segmentToFutureMap.get(segmentId);
        if (future != null && !(cancelled = future.cancel(true))) {
            LOGGER.warn("Task could not be cancelled for {}", (Object)segmentId);
        }
        this._segmentToFutureMap.remove(segmentId);
    }

    private class LeaseExtender
    implements Runnable {
        private final SegmentCompletionProtocol.Request.Params _params;

        private LeaseExtender(SegmentCompletionProtocol.Request.Params params) {
            this._params = params;
        }

        @Override
        public void run() {
            int nAttempts = 0;
            SegmentCompletionProtocol.ControllerResponseStatus status = SegmentCompletionProtocol.ControllerResponseStatus.NOT_SENT;
            String segmentId = this._params.getSegmentName();
            while (status != SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED && nAttempts < 3) {
                try {
                    SegmentCompletionProtocol.Response response = SegmentBuildTimeLeaseExtender.this._protocolHandler.extendBuildTime(this._params);
                    status = response.getStatus();
                }
                catch (Exception e) {
                    LOGGER.warn("Exception trying to send lease renewal for {}", (Object)segmentId);
                }
                if (status == SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) continue;
                Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.warn("Retrying lease extension for {} because controller status {}", (Object)segmentId, (Object)status.toString());
                ++nAttempts;
            }
            if (nAttempts >= 3) {
                LOGGER.error("Failed to send lease extension for {}", (Object)segmentId);
            }
        }
    }
}

