/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.core.util.SegmentCompletionProtocolUtils;
import org.apache.pinot.server.realtime.ControllerLeaderLocator;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;

public class Server2ControllerSegmentUploader
implements SegmentUploader {
    private final Logger _segmentLogger;
    private final URI _controllerSegmentUploadCommitUrl;
    private final FileUploadDownloadClient _fileUploadDownloadClient;
    private final String _segmentName;
    private final int _segmentUploadRequestTimeoutMs;
    private final ServerMetrics _serverMetrics;
    private final AuthProvider _authProvider;
    private final String _rawTableName;

    public Server2ControllerSegmentUploader(Logger segmentLogger, FileUploadDownloadClient fileUploadDownloadClient, String controllerSegmentUploadCommitUrl, String segmentName, int segmentUploadRequestTimeoutMs, ServerMetrics serverMetrics, AuthProvider authProvider, String tableName) throws URISyntaxException {
        this._segmentLogger = segmentLogger;
        this._fileUploadDownloadClient = fileUploadDownloadClient;
        this._controllerSegmentUploadCommitUrl = new URI(controllerSegmentUploadCommitUrl);
        this._segmentName = segmentName;
        this._segmentUploadRequestTimeoutMs = segmentUploadRequestTimeoutMs;
        this._serverMetrics = serverMetrics;
        this._authProvider = authProvider;
        this._rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName) {
        return this.uploadSegment(segmentFile, segmentName, this._segmentUploadRequestTimeoutMs);
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName, int timeoutInMillis) {
        SegmentCompletionProtocol.Response response = this.uploadSegmentToController(segmentFile, timeoutInMillis);
        if (response.getStatus() == SegmentCompletionProtocol.ControllerResponseStatus.UPLOAD_SUCCESS) {
            try {
                URI uri = new URI(response.getSegmentLocation());
                this._serverMetrics.addMeteredTableValue(this._rawTableName, (AbstractMetrics.Meter)ServerMeter.SEGMENT_UPLOAD_SUCCESS, 1L);
                return uri;
            }
            catch (URISyntaxException e) {
                this._segmentLogger.error("Error in segment location format: ", (Throwable)e);
            }
        }
        this._serverMetrics.addMeteredTableValue(this._rawTableName, (AbstractMetrics.Meter)ServerMeter.SEGMENT_UPLOAD_FAILURE, 1L);
        return null;
    }

    public SegmentCompletionProtocol.Response uploadSegmentToController(File segmentFile) {
        return this.uploadSegmentToController(segmentFile, this._segmentUploadRequestTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCompletionProtocol.Response uploadSegmentToController(File segmentFile, int timeoutInMillis) {
        SegmentCompletionProtocol.Response response;
        long startTime = System.currentTimeMillis();
        try {
            String responseStr = this._fileUploadDownloadClient.uploadSegment(this._controllerSegmentUploadCommitUrl, this._segmentName, segmentFile, AuthProviderUtils.toRequestHeaders((AuthProvider)this._authProvider), null, timeoutInMillis).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString((String)responseStr);
            this._segmentLogger.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)this._controllerSegmentUploadCommitUrl);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            this._segmentLogger.error("Could not send request {}", (Object)this._controllerSegmentUploadCommitUrl, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        finally {
            long duration = System.currentTimeMillis() - startTime;
            this._serverMetrics.addTimedTableValue(this._rawTableName, (AbstractMetrics.Timer)ServerTimer.SEGMENT_UPLOAD_TIME_MS, duration, TimeUnit.MILLISECONDS);
        }
        SegmentCompletionProtocolUtils.raiseSegmentCompletionProtocolResponseMetric(this._serverMetrics, response);
        return response;
    }
}

