/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.utils.StringUtil;
import org.slf4j.Logger;

public class SplitSegmentCommitter
implements SegmentCommitter {
    private final SegmentCompletionProtocol.Request.Params _params;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final SegmentUploader _segmentUploader;
    private final String _peerDownloadScheme;
    private final Logger _segmentLogger;

    public SplitSegmentCommitter(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, SegmentCompletionProtocol.Request.Params params, SegmentUploader segmentUploader, @Nullable String peerDownloadScheme) {
        this._segmentLogger = segmentLogger;
        this._protocolHandler = protocolHandler;
        this._params = new SegmentCompletionProtocol.Request.Params(params);
        this._segmentUploader = segmentUploader;
        this._peerDownloadScheme = peerDownloadScheme;
    }

    @VisibleForTesting
    SegmentUploader getSegmentUploader() {
        return this._segmentUploader;
    }

    public SplitSegmentCommitter(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, SegmentCompletionProtocol.Request.Params params, SegmentUploader segmentUploader) {
        this(segmentLogger, protocolHandler, params, segmentUploader, null);
    }

    @Override
    public SegmentCompletionProtocol.Response commit(RealtimeSegmentDataManager.SegmentBuildDescriptor segmentBuildDescriptor) {
        File segmentTarFile = segmentBuildDescriptor.getSegmentTarFile();
        SegmentCompletionProtocol.Response segmentCommitStartResponse = this._protocolHandler.segmentCommitStart(this._params);
        if (!segmentCommitStartResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_CONTINUE)) {
            this._segmentLogger.warn("CommitStart failed  with response {}", (Object)segmentCommitStartResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        String segmentLocation = this.uploadSegment(segmentTarFile, this._segmentUploader, this._params);
        if (segmentLocation == null) {
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        this._params.withSegmentLocation(segmentLocation);
        SegmentCompletionProtocol.Response commitEndResponse = this._protocolHandler.segmentCommitEndWithMetadata(this._params, segmentBuildDescriptor.getMetadataFiles());
        if (!commitEndResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            this._segmentLogger.warn("CommitEnd failed with response {}", (Object)commitEndResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        return commitEndResponse;
    }

    protected String uploadSegment(File segmentTarFile, SegmentUploader segmentUploader, SegmentCompletionProtocol.Request.Params params) {
        URI segmentLocation = segmentUploader.uploadSegment(segmentTarFile, new LLCSegmentName(params.getSegmentName()));
        if (segmentLocation != null) {
            return segmentLocation.toString();
        }
        if (this._peerDownloadScheme != null) {
            return StringUtil.join((String)"/", (String[])new String[]{"peer://", params.getSegmentName()});
        }
        return null;
    }
}

