/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.BaseTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public abstract class IndexedTable
extends BaseTable {
    protected final Map<Key, Record> _lookupMap;
    protected final boolean _hasFinalInput;
    protected final int _resultSize;
    protected final int _numKeyColumns;
    protected final AggregationFunction[] _aggregationFunctions;
    protected final boolean _hasOrderBy;
    protected final TableResizer _tableResizer;
    protected final int _trimSize;
    protected final int _trimThreshold;
    protected Collection<Record> _topRecords;
    private int _numResizes;
    private long _resizeTimeNs;

    protected IndexedTable(DataSchema dataSchema, boolean hasFinalInput, QueryContext queryContext, int resultSize, int trimSize, int trimThreshold, Map<Key, Record> lookupMap) {
        super(dataSchema);
        this._lookupMap = lookupMap;
        this._hasFinalInput = hasFinalInput;
        this._resultSize = resultSize;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        this._numKeyColumns = groupByExpressions.size();
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions != null) {
            this._hasOrderBy = true;
            this._tableResizer = new TableResizer(dataSchema, hasFinalInput, queryContext);
            this._trimSize = Math.min(trimSize, trimThreshold / 2);
            this._trimThreshold = trimThreshold;
        } else {
            this._hasOrderBy = false;
            this._tableResizer = null;
            this._trimSize = Integer.MAX_VALUE;
            this._trimThreshold = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean upsert(Record record) {
        Object[] keyValues = Arrays.copyOf(record.getValues(), this._numKeyColumns);
        return this.upsert(new Key(keyValues), record);
    }

    protected void addOrUpdateRecord(Key key, Record newRecord) {
        this._lookupMap.compute(key, (k, v) -> v == null ? newRecord : this.updateRecord((Record)v, newRecord));
    }

    protected void updateExistingRecord(Key key, Record newRecord) {
        this._lookupMap.computeIfPresent(key, (k, v) -> this.updateRecord((Record)v, newRecord));
    }

    private Record updateRecord(Record existingRecord, Record newRecord) {
        Object[] existingValues = existingRecord.getValues();
        Object[] newValues = newRecord.getValues();
        int numAggregations = this._aggregationFunctions.length;
        int index = this._numKeyColumns;
        if (!this._hasFinalInput) {
            int i = 0;
            while (i < numAggregations) {
                existingValues[index] = this._aggregationFunctions[i].merge(existingValues[index], newValues[index]);
                ++i;
                ++index;
            }
        } else {
            int i = 0;
            while (i < numAggregations) {
                existingValues[index] = this._aggregationFunctions[i].mergeFinalResult((Comparable)existingValues[index], (Comparable)newValues[index]);
                ++i;
                ++index;
            }
        }
        return existingRecord;
    }

    protected void resize() {
        assert (this._hasOrderBy);
        long startTimeNs = System.nanoTime();
        this._tableResizer.resizeRecordsMap(this._lookupMap, this._trimSize);
        long resizeTimeNs = System.nanoTime() - startTimeNs;
        ++this._numResizes;
        this._resizeTimeNs += resizeTimeNs;
    }

    @Override
    public void finish(boolean sort, boolean storeFinalResult) {
        if (this._hasOrderBy) {
            long startTimeNs = System.nanoTime();
            this._topRecords = this._tableResizer.getTopRecords(this._lookupMap, this._resultSize, sort);
            long resizeTimeNs = System.nanoTime() - startTimeNs;
            ++this._numResizes;
            this._resizeTimeNs += resizeTimeNs;
        } else {
            this._topRecords = this._lookupMap.values();
        }
        assert (!this._hasFinalInput || storeFinalResult);
        if (storeFinalResult && !this._hasFinalInput) {
            DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
            int numAggregationFunctions = this._aggregationFunctions.length;
            for (int i = 0; i < numAggregationFunctions; ++i) {
                columnDataTypes[i + this._numKeyColumns] = this._aggregationFunctions[i].getFinalResultColumnType();
            }
            for (Record record : this._topRecords) {
                Object[] values = record.getValues();
                for (int i = 0; i < numAggregationFunctions; ++i) {
                    int colId = i + this._numKeyColumns;
                    values[colId] = this._aggregationFunctions[i].extractFinalResult(values[colId]);
                }
            }
        }
    }

    @Override
    public int size() {
        return this._topRecords != null ? this._topRecords.size() : this._lookupMap.size();
    }

    @Override
    public Iterator<Record> iterator() {
        return this._topRecords.iterator();
    }

    public int getNumResizes() {
        return this._numResizes;
    }

    public long getResizeTimeMs() {
        return TimeUnit.NANOSECONDS.toMillis(this._resizeTimeNs);
    }
}

