/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.function.scalar;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.dynatrace.hash4j.distinctcount.UltraLogLog;
import java.math.BigDecimal;
import java.util.Base64;
import javax.annotation.Nullable;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.segment.local.utils.UltraLogLogUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class SketchFunctions {
    private static final SetOperationBuilder SET_OPERATION_BUILDER = new SetOperationBuilder();

    private SketchFunctions() {
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toThetaSketch(@Nullable Object input) {
        return SketchFunctions.toThetaSketch(input, 16384);
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toThetaSketch(@Nullable Object input, int nominalEntries) {
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(nominalEntries).build();
        if (input != null) {
            if (input instanceof Integer) {
                sketch.update((long)((Integer)input).intValue());
            } else if (input instanceof Long) {
                sketch.update(((Long)input).longValue());
            } else if (input instanceof Float) {
                sketch.update((double)((Float)input).floatValue());
            } else if (input instanceof Double) {
                sketch.update(((Double)input).doubleValue());
            } else if (input instanceof BigDecimal) {
                sketch.update(((BigDecimal)input).toString());
            } else if (input instanceof String) {
                sketch.update((String)input);
            } else if (input instanceof byte[]) {
                sketch.update((byte[])input);
            } else {
                throw new IllegalArgumentException("Unrecognised input type for Theta sketch: " + input.getClass().getSimpleName());
            }
        }
        return ObjectSerDeUtils.DATA_SKETCH_THETA_SER_DE.serialize((Sketch)sketch.compact());
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toHLL(@Nullable Object input) {
        return SketchFunctions.toHLL(input, 8);
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toHLL(@Nullable Object input, int log2m) {
        HyperLogLog hll = new HyperLogLog(log2m);
        if (input != null) {
            hll.offer(input);
        }
        return ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.serialize(hll);
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toIntegerSumTupleSketch(@Nullable Object key, @Nullable Integer value) {
        return SketchFunctions.toIntegerSumTupleSketch(key, value, 14);
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toIntegerSumTupleSketch(@Nullable Object key, Integer value, int lgK) {
        IntegerSketch is = new IntegerSketch(lgK, IntegerSummary.Mode.Sum);
        if (value != null && key != null) {
            if (key instanceof Integer) {
                is.update((long)((Integer)key).intValue(), value);
            } else if (key instanceof Long) {
                is.update(((Long)key).longValue(), value);
            } else if (key instanceof Float) {
                is.update((double)((Float)key).floatValue(), (Object)value);
            } else if (key instanceof Double) {
                is.update(((Double)key).doubleValue(), (Object)value);
            } else if (key instanceof BigDecimal) {
                is.update(((BigDecimal)key).toString(), value);
            } else if (key instanceof String) {
                is.update((String)key, value);
            } else if (key instanceof byte[]) {
                is.update((byte[])key, (Object)value);
            } else {
                throw new IllegalArgumentException("Unrecognised key type for Theta sketch: " + key.getClass().getSimpleName());
            }
        }
        return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.serialize((org.apache.datasketches.tuple.Sketch<IntegerSummary>)is.compact());
    }

    @ScalarFunction(names={"getThetaSketchEstimate", "get_theta_sketch_estimate"})
    public static long getThetaSketchEstimate(Object sketchObject) {
        return Math.round(SketchFunctions.asThetaSketch(sketchObject).getEstimate());
    }

    @ScalarFunction(names={"thetaSketchUnion", "theta_sketch_union"})
    public static Sketch thetaSketchUnion(Object o1, Object o2) {
        return SketchFunctions.thetaSketchUnionVar(o1, o2);
    }

    @ScalarFunction(names={"thetaSketchUnion", "theta_sketch_union"})
    public static Sketch thetaSketchUnion(Object o1, Object o2, Object o3) {
        return SketchFunctions.thetaSketchUnionVar(o1, o2, o3);
    }

    @ScalarFunction(names={"thetaSketchUnion", "theta_sketch_union"})
    public static Sketch thetaSketchUnion(Object o1, Object o2, Object o3, Object o4) {
        return SketchFunctions.thetaSketchUnionVar(o1, o2, o3, o4);
    }

    @ScalarFunction(names={"thetaSketchUnion", "theta_sketch_union"})
    public static Sketch thetaSketchUnion(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return SketchFunctions.thetaSketchUnionVar(o1, o2, o3, o4, o5);
    }

    @ScalarFunction(names={"thetaSketchIntersect", "theta_sketch_intersect"})
    public static Sketch thetaSketchIntersect(Object o1, Object o2) {
        return SketchFunctions.thetaSketchIntersectVar(o1, o2);
    }

    @ScalarFunction(names={"thetaSketchIntersect", "theta_sketch_intersect"})
    public static Sketch thetaSketchIntersect(Object o1, Object o2, Object o3) {
        return SketchFunctions.thetaSketchIntersectVar(o1, o2, o3);
    }

    @ScalarFunction(names={"thetaSketchIntersect", "theta_sketch_intersect"})
    public static Sketch thetaSketchIntersect(Object o1, Object o2, Object o3, Object o4) {
        return SketchFunctions.thetaSketchIntersectVar(o1, o2, o3, o4);
    }

    @ScalarFunction(names={"thetaSketchIntersect", "theta_sketch_intersect"})
    public static Sketch thetaSketchIntersect(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return SketchFunctions.thetaSketchIntersectVar(o1, o2, o3, o4, o5);
    }

    @ScalarFunction(names={"thetaSketchDiff", "theta_sketch_diff"})
    public static Sketch thetaSketchDiff(Object sketchObjectA, Object sketchObjectB) {
        AnotB diff = SET_OPERATION_BUILDER.buildANotB();
        diff.setA(SketchFunctions.asThetaSketch(sketchObjectA));
        diff.notB(SketchFunctions.asThetaSketch(sketchObjectB));
        return diff.getResult(false, null, false);
    }

    @ScalarFunction(names={"thetaSketchToString", "theta_sketch_to_string"})
    public static String thetaSketchToString(Object sketchObject) {
        return SketchFunctions.asThetaSketch(sketchObject).toString();
    }

    private static Sketch thetaSketchUnionVar(Object ... sketchObjects) {
        Union union = SET_OPERATION_BUILDER.buildUnion();
        for (Object sketchObj : sketchObjects) {
            union.union(SketchFunctions.asThetaSketch(sketchObj));
        }
        return union.getResult(false, null);
    }

    private static Sketch thetaSketchIntersectVar(Object ... sketchObjects) {
        Intersection intersection = SET_OPERATION_BUILDER.buildIntersection();
        for (Object sketchObj : sketchObjects) {
            intersection.intersect(SketchFunctions.asThetaSketch(sketchObj));
        }
        return intersection.getResult(false, null);
    }

    private static Sketch asThetaSketch(Object sketchObj) {
        if (sketchObj instanceof String) {
            byte[] decoded = Base64.getDecoder().decode((String)sketchObj);
            return Sketches.wrapSketch((Memory)Memory.wrap((byte[])decoded));
        }
        if (sketchObj instanceof Sketch) {
            return (Sketch)sketchObj;
        }
        if (sketchObj instanceof byte[]) {
            return Sketches.wrapSketch((Memory)Memory.wrap((byte[])((byte[])sketchObj)));
        }
        throw new RuntimeException("Exception occurred getting estimate from Theta Sketch, unsupported Object type: " + sketchObj.getClass());
    }

    @ScalarFunction(names={"intSumTupleSketchUnion", "int_sum_tuple_sketch_union"})
    public static byte[] intSumTupleSketchUnion(Object o1, Object o2) {
        return SketchFunctions.intSumTupleSketchUnion((int)Math.pow(2.0, 14.0), o1, o2);
    }

    @ScalarFunction(names={"intSumTupleSketchUnion", "int_sum_tuple_sketch_union"})
    public static byte[] intSumTupleSketchUnion(int nomEntries, Object o1, Object o2) {
        return SketchFunctions.intTupleSketchUnionVar(IntegerSummary.Mode.Sum, nomEntries, o1, o2);
    }

    @ScalarFunction(names={"intMinTupleSketchUnion", "int_min_tuple_sketch_union"})
    public static byte[] intMinTupleSketchUnion(Object o1, Object o2) {
        return SketchFunctions.intMinTupleSketchUnion((int)Math.pow(2.0, 14.0), o1, o2);
    }

    @ScalarFunction(names={"intMinTupleSketchUnion", "int_min_tuple_sketch_union"})
    public static byte[] intMinTupleSketchUnion(int nomEntries, Object o1, Object o2) {
        return SketchFunctions.intTupleSketchUnionVar(IntegerSummary.Mode.Min, nomEntries, o1, o2);
    }

    @ScalarFunction(names={"intMaxTupleSketchUnion", "int_max_tuple_sketch_union"})
    public static byte[] intMaxTupleSketchUnion(Object o1, Object o2) {
        return SketchFunctions.intMaxTupleSketchUnion((int)Math.pow(2.0, 14.0), o1, o2);
    }

    @ScalarFunction(names={"intMaxTupleSketchUnion", "int_max_tuple_sketch_union"})
    public static byte[] intMaxTupleSketchUnion(int nomEntries, Object o1, Object o2) {
        return SketchFunctions.intTupleSketchUnionVar(IntegerSummary.Mode.Max, nomEntries, o1, o2);
    }

    private static byte[] intTupleSketchUnionVar(IntegerSummary.Mode mode, int nomEntries, Object ... sketchObjects) {
        org.apache.datasketches.tuple.Union union = new org.apache.datasketches.tuple.Union(nomEntries, (SummarySetOperations)new IntegerSummarySetOperations(mode, mode));
        for (Object sketchObj : sketchObjects) {
            union.union(SketchFunctions.asIntegerSketch(sketchObj));
        }
        return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.serialize((org.apache.datasketches.tuple.Sketch<IntegerSummary>)union.getResult().compact());
    }

    @ScalarFunction(names={"intSumTupleSketchIntersect", "int_sum_tuple_sketch_intersect"})
    public static byte[] intSumTupleSketchIntersect(Object o1, Object o2) {
        return SketchFunctions.intTupleSketchIntersectVar(IntegerSummary.Mode.Sum, o1, o2);
    }

    @ScalarFunction(names={"intMinTupleSketchIntersect", "int_min_tuple_sketch_intersect"})
    public static byte[] intMinTupleSketchIntersect(Object o1, Object o2) {
        return SketchFunctions.intTupleSketchIntersectVar(IntegerSummary.Mode.Min, o1, o2);
    }

    @ScalarFunction(names={"intMaxTupleSketchIntersect", "int_max_tuple_sketch_intersect"})
    public static byte[] intMaxTupleSketchIntersect(Object o1, Object o2) {
        return SketchFunctions.intTupleSketchIntersectVar(IntegerSummary.Mode.Max, o1, o2);
    }

    private static byte[] intTupleSketchIntersectVar(IntegerSummary.Mode mode, Object ... sketchObjects) {
        org.apache.datasketches.tuple.Intersection intersection = new org.apache.datasketches.tuple.Intersection((SummarySetOperations)new IntegerSummarySetOperations(mode, mode));
        for (Object sketchObj : sketchObjects) {
            intersection.intersect(SketchFunctions.asIntegerSketch(sketchObj));
        }
        return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.serialize((org.apache.datasketches.tuple.Sketch<IntegerSummary>)intersection.getResult().compact());
    }

    @ScalarFunction(names={"intTupleSketchDiff", "int_tuple_sketch_diff"})
    public static byte[] intSumTupleSketchDiff(Object o1, Object o2) {
        org.apache.datasketches.tuple.AnotB diff = new org.apache.datasketches.tuple.AnotB();
        diff.setA(SketchFunctions.asIntegerSketch(o1));
        diff.notB(SketchFunctions.asIntegerSketch(o2));
        return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.serialize((org.apache.datasketches.tuple.Sketch<IntegerSummary>)diff.getResult(false).compact());
    }

    private static org.apache.datasketches.tuple.Sketch<IntegerSummary> asIntegerSketch(Object sketchObj) {
        if (sketchObj instanceof String) {
            byte[] decoded = Base64.getDecoder().decode((String)sketchObj);
            return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.deserialize(decoded);
        }
        if (sketchObj instanceof org.apache.datasketches.tuple.Sketch) {
            return (org.apache.datasketches.tuple.Sketch)sketchObj;
        }
        if (sketchObj instanceof byte[]) {
            return ObjectSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.deserialize((byte[])sketchObj);
        }
        throw new RuntimeException("Exception occurred getting reading Tuple Sketch, unsupported Object type: " + sketchObj.getClass());
    }

    @ScalarFunction(names={"getIntTupleSketchEstimate", "get_int_tuple_sketch_estimate"})
    public static long getIntTupleSketchEstimate(Object o1) {
        return Math.round(SketchFunctions.asIntegerSketch(o1).getEstimate());
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toCpcSketch(@Nullable Object input) {
        return SketchFunctions.toCpcSketch(input, 12);
    }

    @ScalarFunction(names={"getCpcSketchEstimate", "get_cpc_sketch_estimate"})
    public static long getCpcSketchEstimate(Object o1) {
        return Math.round(SketchFunctions.asCpcSketch(o1).getEstimate());
    }

    @ScalarFunction(names={"cpcSketchUnion", "cpc_sketch_union"})
    public static byte[] cpcSketchUnion(Object o1, Object o2) {
        return SketchFunctions.cpcSketchUnionVar(o1, o2);
    }

    @ScalarFunction(names={"cpcSketchUnion", "cpc_sketch_union"})
    public static byte[] cpcSketchUnion(Object o1, Object o2, Object o3) {
        return SketchFunctions.cpcSketchUnionVar(o1, o2, o3);
    }

    @ScalarFunction(names={"cpcSketchUnion", "cpc_sketch_union"})
    public static byte[] cpcSketchUnion(Object o1, Object o2, Object o3, Object o4) {
        return SketchFunctions.cpcSketchUnionVar(o1, o2, o3, o4);
    }

    @ScalarFunction(names={"cpcSketchUnion", "cpc_sketch_union"})
    public static byte[] cpcSketchUnion(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return SketchFunctions.cpcSketchUnionVar(o1, o2, o3, o4, o5);
    }

    @ScalarFunction(names={"cpcSketchToString", "cpc_sketch_to_string"})
    public static String cpcSketchToString(Object sketchObject) {
        return SketchFunctions.asCpcSketch(sketchObject).toString();
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toCpcSketch(@Nullable Object input, int lgK) {
        CpcSketch sketch = new CpcSketch(lgK);
        if (input != null) {
            if (input instanceof Integer) {
                sketch.update((long)((Integer)input).intValue());
            } else if (input instanceof Long) {
                sketch.update(((Long)input).longValue());
            } else if (input instanceof Float) {
                sketch.update((double)((Float)input).floatValue());
            } else if (input instanceof Double) {
                sketch.update(((Double)input).doubleValue());
            } else if (input instanceof BigDecimal) {
                sketch.update(((BigDecimal)input).toString());
            } else if (input instanceof String) {
                sketch.update((String)input);
            } else if (input instanceof byte[]) {
                sketch.update((byte[])input);
            } else {
                throw new IllegalArgumentException("Unrecognised input type for CPC sketch: " + input.getClass().getSimpleName());
            }
        }
        return ObjectSerDeUtils.DATA_SKETCH_CPC_SER_DE.serialize(sketch);
    }

    private static CpcSketch asCpcSketch(Object sketchObj) {
        if (sketchObj instanceof CpcSketch) {
            return (CpcSketch)sketchObj;
        }
        if (sketchObj instanceof byte[]) {
            return CpcSketch.heapify((Memory)Memory.wrap((byte[])((byte[])sketchObj)));
        }
        if (sketchObj instanceof String) {
            byte[] decoded = Base64.getDecoder().decode((String)sketchObj);
            return CpcSketch.heapify((Memory)Memory.wrap((byte[])decoded));
        }
        throw new RuntimeException("Exception occurred getting estimate from CPC Sketch, unsupported Object type: " + sketchObj.getClass());
    }

    private static byte[] cpcSketchUnionVar(Object ... sketchObjects) {
        CpcUnion union = new CpcUnion(12);
        for (Object sketchObj : sketchObjects) {
            union.update(SketchFunctions.asCpcSketch(sketchObj));
        }
        return union.getResult().toByteArray();
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toULL(@Nullable Object input) {
        return SketchFunctions.toULL(input, 12);
    }

    @ScalarFunction(nullableParameters=true)
    public static byte[] toULL(@Nullable Object input, int p) {
        UltraLogLog sketch = UltraLogLog.create((int)p);
        UltraLogLogUtils.hashObject((Object)input).ifPresent(arg_0 -> ((UltraLogLog)sketch).add(arg_0));
        return ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.serialize(sketch);
    }

    @ScalarFunction
    public static byte[] fromULL(byte[] input) {
        UltraLogLog ull = UltraLogLog.wrap((byte[])input);
        return ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.serialize(ull);
    }
}

