/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;

public abstract class BaseBinaryGeoTransformFunction
extends BaseTransformFunction {
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private Geometry _firstLiteral;
    private Geometry _secondLiteral;
    private int[] _intResults;
    private double[] _doubleResults;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"2 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (String)"The first argument must be of type BYTES , but was %s", (Object)transformFunction.getResultMetadata().getDataType());
        if (transformFunction instanceof LiteralTransformFunction) {
            this._firstLiteral = GeometrySerializer.deserialize((byte[])((LiteralTransformFunction)transformFunction).getBytesLiteral());
        } else {
            this._firstArgument = transformFunction;
        }
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (String)"The second argument must be of type BYTES , but was %s", (Object)transformFunction.getResultMetadata().getDataType());
        if (transformFunction instanceof LiteralTransformFunction) {
            this._secondLiteral = GeometrySerializer.deserialize((byte[])((LiteralTransformFunction)transformFunction).getBytesLiteral());
        } else {
            this._secondArgument = transformFunction;
        }
    }

    protected int[] transformGeometryToIntValuesSV(ValueBlock valueBlock) {
        if (this._intResults == null) {
            this._intResults = new int[10000];
        }
        if (this._firstArgument == null && this._secondArgument == null) {
            this._intResults = new int[Math.min(valueBlock.getNumDocs(), 10000)];
            Arrays.fill(this._intResults, this.transformGeometryToInt(this._firstLiteral, this._secondLiteral));
        } else if (this._firstArgument == null) {
            byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._intResults[i] = this.transformGeometryToInt(this._firstLiteral, GeometrySerializer.deserialize((byte[])secondValues[i]));
            }
        } else if (this._secondArgument == null) {
            byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._intResults[i] = this.transformGeometryToInt(GeometrySerializer.deserialize((byte[])firstValues[i]), this._secondLiteral);
            }
        } else {
            byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(valueBlock);
            byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._intResults[i] = this.transformGeometryToInt(GeometrySerializer.deserialize((byte[])firstValues[i]), GeometrySerializer.deserialize((byte[])secondValues[i]));
            }
        }
        return this._intResults;
    }

    protected double[] transformGeometryToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._doubleResults == null) {
            this._doubleResults = new double[10000];
        }
        if (this._firstArgument == null && this._secondArgument == null) {
            this._doubleResults = new double[Math.min(valueBlock.getNumDocs(), 10000)];
            Arrays.fill(this._doubleResults, this.transformGeometryToDouble(this._firstLiteral, this._secondLiteral));
        } else if (this._firstArgument == null) {
            byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._doubleResults[i] = this.transformGeometryToDouble(this._firstLiteral, GeometrySerializer.deserialize((byte[])secondValues[i]));
            }
        } else if (this._secondArgument == null) {
            byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._doubleResults[i] = this.transformGeometryToDouble(GeometrySerializer.deserialize((byte[])firstValues[i]), this._secondLiteral);
            }
        } else {
            byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(valueBlock);
            byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(valueBlock);
            for (int i = 0; i < valueBlock.getNumDocs(); ++i) {
                this._doubleResults[i] = this.transformGeometryToDouble(GeometrySerializer.deserialize((byte[])firstValues[i]), GeometrySerializer.deserialize((byte[])secondValues[i]));
            }
        }
        return this._doubleResults;
    }

    public int transformGeometryToInt(Geometry firstGeometry, Geometry secondGeometry) {
        throw new UnsupportedOperationException();
    }

    public double transformGeometryToDouble(Geometry firstGeometry, Geometry secondGeometry) {
        throw new UnsupportedOperationException();
    }
}

