/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.exception.EarlyTerminationException;

public class AcquireReleaseColumnsSegmentOperator
extends BaseOperator<BaseResultsBlock> {
    private static final String EXPLAIN_NAME = "ACQUIRE_RELEASE_COLUMNS_SEGMENT";
    private final PlanNode _planNode;
    private final IndexSegment _indexSegment;
    private final FetchContext _fetchContext;
    private Operator<BaseResultsBlock> _childOperator;

    public AcquireReleaseColumnsSegmentOperator(PlanNode planNode, IndexSegment indexSegment, FetchContext fetchContext) {
        this._planNode = planNode;
        this._indexSegment = indexSegment;
        this._fetchContext = fetchContext;
    }

    public void materializeChildOperator() {
        this._childOperator = this._planNode.run();
    }

    @Override
    protected BaseResultsBlock getNextBlock() {
        this.materializeChildOperator();
        return this._childOperator.nextBlock();
    }

    public void acquire() {
        if (Thread.interrupted()) {
            throw new EarlyTerminationException("Interrupted while acquiring segment");
        }
        this._indexSegment.acquire(this._fetchContext);
    }

    public void release() {
        this._indexSegment.release(this._fetchContext);
    }

    @Override
    public void prepareForExplainPlan(ExplainPlanRows explainPlanRows) {
        this.acquire();
        this.materializeChildOperator();
    }

    @Override
    public void postExplainPlan(ExplainPlanRows explainPlanRows) {
        this.release();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._childOperator);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._childOperator == null ? new ExecutionStatistics(0L, 0L, 0L, 0L) : this._childOperator.getExecutionStatistics();
    }
}

