/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import javax.annotation.Nullable;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ColumnContext {
    private final FieldSpec.DataType _dataType;
    private final boolean _isSingleValue;
    private final Dictionary _dictionary;
    private final DataSource _dataSource;

    private ColumnContext(FieldSpec.DataType dataType, boolean isSingleValue, @Nullable Dictionary dictionary, @Nullable DataSource dataSource) {
        this._dataType = dataType;
        this._isSingleValue = isSingleValue;
        this._dictionary = dictionary;
        this._dataSource = dataSource;
    }

    public FieldSpec.DataType getDataType() {
        return this._dataType;
    }

    public boolean isSingleValue() {
        return this._isSingleValue;
    }

    @Nullable
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Nullable
    public DataSource getDataSource() {
        return this._dataSource;
    }

    public static ColumnContext fromDataSource(DataSource dataSource) {
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        return new ColumnContext(dataSourceMetadata.getDataType(), dataSourceMetadata.isSingleValue(), dataSource.getDictionary(), dataSource);
    }

    public static ColumnContext fromTransformFunction(TransformFunction transformFunction) {
        TransformResultMetadata resultMetadata = transformFunction.getResultMetadata();
        return new ColumnContext(resultMetadata.getDataType(), resultMetadata.isSingleValue(), transformFunction.getDictionary(), null);
    }
}

