/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.Tracing;

public class InstanceResponseOperator
extends BaseOperator<InstanceResponseBlock> {
    private static final String EXPLAIN_NAME = "INSTANCE_RESPONSE";
    protected final BaseCombineOperator<?> _combineOperator;
    protected final List<SegmentContext> _segmentContexts;
    protected final List<FetchContext> _fetchContexts;
    protected final int _fetchContextSize;
    protected final QueryContext _queryContext;
    protected long _threadCpuTimeNs;
    protected long _systemActivitiesCpuTimeNs;

    public InstanceResponseOperator(BaseCombineOperator<?> combineOperator, List<SegmentContext> segmentContexts, List<FetchContext> fetchContexts, QueryContext queryContext) {
        this._combineOperator = combineOperator;
        this._segmentContexts = segmentContexts;
        this._fetchContexts = fetchContexts;
        this._fetchContextSize = fetchContexts.size();
        this._queryContext = queryContext;
    }

    public static long calSystemActivitiesCpuTimeNs(long totalWallClockTimeNs, long multipleThreadCpuTimeNs, long mainThreadCpuTimeNs, int numServerThreads) {
        double perMultipleThreadCpuTimeNs = (double)multipleThreadCpuTimeNs * 1.0 / (double)numServerThreads;
        long systemActivitiesCpuTimeNs = Math.round((double)(totalWallClockTimeNs - mainThreadCpuTimeNs) - perMultipleThreadCpuTimeNs);
        return Math.max(systemActivitiesCpuTimeNs, 0L);
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        BaseResultsBlock baseResultsBlock = this.getBaseBlock();
        return this.buildInstanceResponseBlock(baseResultsBlock);
    }

    protected InstanceResponseBlock buildInstanceResponseBlock(BaseResultsBlock baseResultsBlock) {
        InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(baseResultsBlock);
        instanceResponseBlock.addMetadata(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), String.valueOf(this._threadCpuTimeNs));
        instanceResponseBlock.addMetadata(DataTable.MetadataKey.SYSTEM_ACTIVITIES_CPU_TIME_NS.getName(), String.valueOf(this._systemActivitiesCpuTimeNs));
        return instanceResponseBlock;
    }

    protected BaseResultsBlock getBaseBlock() {
        if (ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled()) {
            long startWallClockTimeNs = System.nanoTime();
            ThreadResourceUsageProvider mainThreadResourceUsageProvider = new ThreadResourceUsageProvider();
            BaseResultsBlock resultsBlock = this.getCombinedResults();
            long mainThreadCpuTimeNs = mainThreadResourceUsageProvider.getThreadTimeNs();
            long totalWallClockTimeNs = System.nanoTime() - startWallClockTimeNs;
            long multipleThreadCpuTimeNs = resultsBlock.getExecutionThreadCpuTimeNs();
            int numServerThreads = resultsBlock.getNumServerThreads();
            this._systemActivitiesCpuTimeNs = InstanceResponseOperator.calSystemActivitiesCpuTimeNs(totalWallClockTimeNs, multipleThreadCpuTimeNs, mainThreadCpuTimeNs, numServerThreads);
            this._threadCpuTimeNs = mainThreadCpuTimeNs + multipleThreadCpuTimeNs;
            return resultsBlock;
        }
        return this.getCombinedResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseResultsBlock getCombinedResults() {
        try {
            this.prefetchAll();
            BaseResultsBlock baseResultsBlock = (BaseResultsBlock)this._combineOperator.nextBlock();
            return baseResultsBlock;
        }
        catch (EarlyTerminationException e) {
            Exception killedErrorMsg = Tracing.getThreadAccountant().getErrorStatus();
            ExceptionResultsBlock exceptionResultsBlock = new ExceptionResultsBlock(new QueryCancelledException("Cancelled while combining results" + (String)(killedErrorMsg == null ? "" : " " + killedErrorMsg), (Throwable)e));
            return exceptionResultsBlock;
        }
        finally {
            this.releaseAll();
        }
    }

    public void prefetchAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._segmentContexts.get(i).getIndexSegment().prefetch(this._fetchContexts.get(i));
        }
    }

    public void releaseAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._segmentContexts.get(i).getIndexSegment().release(this._fetchContexts.get(i));
        }
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._combineOperator);
    }
}

