/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ProjectionOperatorUtils {
    private static Implementation _instance = new DefaultImplementation();

    private ProjectionOperatorUtils() {
    }

    public static void setImplementation(Implementation newImplementation) {
        _instance = newImplementation;
    }

    public static ProjectionOperator getProjectionOperator(Map<String, DataSource> dataSourceMap, @Nullable BaseOperator<DocIdSetBlock> docIdSetOperator) {
        return _instance.getProjectionOperator(dataSourceMap, docIdSetOperator);
    }

    public static class DefaultImplementation
    implements Implementation {
        @Override
        public ProjectionOperator getProjectionOperator(Map<String, DataSource> dataSourceMap, @Nullable BaseOperator<DocIdSetBlock> docIdSetOperator) {
            return new ProjectionOperator(dataSourceMap, docIdSetOperator);
        }
    }

    public static interface Implementation {
        public ProjectionOperator getProjectionOperator(Map<String, DataSource> var1, @Nullable BaseOperator<DocIdSetBlock> var2);
    }
}

