/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;

public class DistinctResultsBlock
extends BaseResultsBlock {
    private final QueryContext _queryContext;
    private DistinctTable _distinctTable;

    public DistinctResultsBlock(DistinctTable distinctTable, QueryContext queryContext) {
        this._distinctTable = distinctTable;
        this._queryContext = queryContext;
    }

    public DistinctTable getDistinctTable() {
        return this._distinctTable;
    }

    public void setDistinctTable(DistinctTable distinctTable) {
        this._distinctTable = distinctTable;
    }

    @Override
    public int getNumRows() {
        return this._distinctTable.size();
    }

    @Override
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    public DataSchema getDataSchema() {
        return this._distinctTable.getDataSchema();
    }

    @Override
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._distinctTable.size());
        for (Record record : this._distinctTable.getRecords()) {
            rows.add(record.getValues());
        }
        return rows;
    }

    @Override
    public DataTable getDataTable() throws IOException {
        List<Object[]> rows = this.getRows();
        return SelectionOperatorUtils.getDataTableFromRows(rows, this._distinctTable.getDataSchema(), this._queryContext.isNullHandlingEnabled());
    }
}

