/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSingleBlockCombineOperator<T extends BaseResultsBlock>
extends BaseCombineOperator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSingleBlockCombineOperator.class);
    protected final BlockingQueue<BaseResultsBlock> _blockingQueue = new LinkedBlockingQueue<BaseResultsBlock>();

    protected BaseSingleBlockCombineOperator(ResultsBlockMerger<T> resultsBlockMerger, List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(resultsBlockMerger, operators, queryContext, executorService);
    }

    @Override
    protected BaseResultsBlock getNextBlock() {
        BaseResultsBlock mergedBlock;
        try {
            this.startProcess();
            mergedBlock = this.mergeResults();
        }
        catch (InterruptedException e) {
            throw new EarlyTerminationException("Interrupted while merging results blocks", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while merging results blocks (query: {})", (Object)this._queryContext, (Object)e);
            mergedBlock = new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Throwable)e));
        }
        finally {
            this.stopProcess();
        }
        int numServerThreads = Math.min(this._numTasks, ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
        CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators, this._totalWorkerThreadCpuTimeNs.get(), numServerThreads);
        return mergedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        while (this._processingException.get() == null && (operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            BaseResultsBlock resultsBlock;
            Operator operator = (Operator)this._operators.get(operatorId);
            try {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                resultsBlock = (BaseResultsBlock)operator.nextBlock();
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
            this._blockingQueue.offer(resultsBlock);
            if (!this._resultsBlockMerger.isQuerySatisfied(resultsBlock)) continue;
            this._nextOperatorId.set(this._numOperators);
            return;
        }
    }

    @Override
    protected void onProcessSegmentsException(Throwable t) {
        this._processingException.compareAndSet(null, t);
        this._blockingQueue.offer(new ExceptionResultsBlock(t));
    }

    @Override
    protected void onProcessSegmentsFinish() {
    }

    protected BaseResultsBlock mergeResults() throws Exception {
        BaseResultsBlock mergedBlock = null;
        long endTimeMs = this._queryContext.getEndTimeMs();
        for (int numBlocksMerged = 0; numBlocksMerged < this._numOperators; ++numBlocksMerged) {
            long waitTimeMs = endTimeMs - System.currentTimeMillis();
            if (waitTimeMs <= 0L) {
                return this.getTimeoutResultsBlock(numBlocksMerged);
            }
            BaseResultsBlock blockToMerge = this._blockingQueue.poll(waitTimeMs, TimeUnit.MILLISECONDS);
            if (blockToMerge == null) {
                return this.getTimeoutResultsBlock(numBlocksMerged);
            }
            if (blockToMerge.getProcessingExceptions() != null) {
                return blockToMerge;
            }
            if (mergedBlock == null) {
                mergedBlock = blockToMerge;
                continue;
            }
            this._resultsBlockMerger.mergeResultsBlocks(mergedBlock, blockToMerge);
            if (!this._resultsBlockMerger.isQuerySatisfied(mergedBlock)) continue;
            return mergedBlock;
        }
        return mergedBlock;
    }
}

