/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine.merger;

import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;

public class DistinctResultsBlockMerger
implements ResultsBlockMerger<DistinctResultsBlock> {
    private final QueryContext _queryContext;
    private final boolean _hasOrderBy;

    public DistinctResultsBlockMerger(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._hasOrderBy = queryContext.getOrderByExpressions() != null;
    }

    @Override
    public boolean isQuerySatisfied(DistinctResultsBlock resultsBlock) {
        if (this._hasOrderBy) {
            return false;
        }
        return resultsBlock.getDistinctTable().size() >= this._queryContext.getLimit();
    }

    @Override
    public void mergeResultsBlocks(DistinctResultsBlock mergedBlock, DistinctResultsBlock blockToMerge) {
        DistinctTable mergedDistinctTable = mergedBlock.getDistinctTable();
        DistinctTable distinctTableToMerge = blockToMerge.getDistinctTable();
        assert (mergedDistinctTable != null && distinctTableToMerge != null);
        if (!mergedDistinctTable.isMainTable()) {
            DistinctTable mainDistinctTable = new DistinctTable(distinctTableToMerge.getDataSchema(), this._queryContext.getOrderByExpressions(), this._queryContext.getLimit(), this._queryContext.isNullHandlingEnabled());
            mainDistinctTable.mergeTable(mergedDistinctTable);
            mergedBlock.setDistinctTable(mainDistinctTable);
            mergedDistinctTable = mainDistinctTable;
        }
        mergedDistinctTable.mergeTable(distinctTableToMerge);
    }
}

