/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine.merger;

import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionOrderByResultsBlockMerger
implements ResultsBlockMerger<SelectionResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionOrderByResultsBlockMerger.class);
    private final int _numRowsToKeep;

    public SelectionOrderByResultsBlockMerger(QueryContext queryContext) {
        this._numRowsToKeep = queryContext.getLimit() + queryContext.getOffset();
    }

    @Override
    public void mergeResultsBlocks(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        SelectionOperatorUtils.mergeWithOrdering(mergedBlock, blockToMerge, this._numRowsToKeep);
    }
}

