/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.common.BlockDocIdIterator;

public final class AndDocIdIterator
implements BlockDocIdIterator {
    public final BlockDocIdIterator[] _docIdIterators;
    private int _nextDocId = 0;

    public AndDocIdIterator(BlockDocIdIterator[] docIdIterators) {
        this._docIdIterators = docIdIterators;
    }

    @Override
    public int next() {
        int maxDocId = this._nextDocId;
        int maxDocIdIndex = -1;
        int numDocIdIterators = this._docIdIterators.length;
        int index = 0;
        while (index < numDocIdIterators) {
            if (index == maxDocIdIndex) {
                ++index;
                continue;
            }
            int docId = this._docIdIterators[index].advance(maxDocId);
            if (docId != Integer.MIN_VALUE) {
                if (docId == maxDocId) {
                    ++index;
                    continue;
                }
                maxDocId = docId;
                maxDocIdIndex = index;
                index = 0;
                continue;
            }
            return Integer.MIN_VALUE;
        }
        this._nextDocId = maxDocId;
        return this._nextDocId++;
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        return this.next();
    }
}

