/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BitmapDocIdSetOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.ProjectionOperatorUtils;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class ExpressionScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final TransformFunction _transformFunction;
    private final PredicateEvaluator _predicateEvaluator;
    private final Map<String, DataSource> _dataSourceMap;
    private final int _endDocId;
    private final int[] _docIdBuffer = new int[10000];
    private final boolean _nullHandlingEnabled;
    private final PredicateEvaluationResult _predicateEvaluationResult;
    private int _blockEndDocId = 0;
    private PeekableIntIterator _docIdIterator;
    private long _numEntriesScanned = 0L;

    public ExpressionScanDocIdIterator(TransformFunction transformFunction, @Nullable PredicateEvaluator predicateEvaluator, Map<String, DataSource> dataSourceMap, int numDocs, boolean nullHandlingEnabled, PredicateEvaluationResult predicateEvaluationResult) {
        this._transformFunction = transformFunction;
        this._predicateEvaluator = predicateEvaluator;
        this._dataSourceMap = dataSourceMap;
        this._endDocId = numDocs;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._predicateEvaluationResult = predicateEvaluationResult;
    }

    @Override
    public int next() {
        if (this._docIdIterator != null && this._docIdIterator.hasNext()) {
            return this._docIdIterator.next();
        }
        while (this._blockEndDocId < this._endDocId) {
            int blockStartDocId = this._blockEndDocId;
            this._blockEndDocId = Math.min(blockStartDocId + 10000, this._endDocId);
            ProjectionBlock projectionBlock = (ProjectionBlock)ProjectionOperatorUtils.getProjectionOperator(this._dataSourceMap, new RangeDocIdSetOperator(blockStartDocId, this._blockEndDocId)).nextBlock();
            RoaringBitmap matchingDocIds = new RoaringBitmap();
            this.processProjectionBlock(projectionBlock, (BitmapDataProvider)matchingDocIds);
            if (matchingDocIds.isEmpty()) continue;
            this._docIdIterator = matchingDocIds.getIntIterator();
            return this._docIdIterator.next();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        if (targetDocId < this._blockEndDocId) {
            this._docIdIterator.advanceIfNeeded(targetDocId);
            if (this._docIdIterator.hasNext()) {
                return this._docIdIterator.next();
            }
        } else {
            this._blockEndDocId = targetDocId;
        }
        this._docIdIterator = null;
        return this.next();
    }

    @Override
    public MutableRoaringBitmap applyAnd(BatchIterator batchIterator, OptionalInt firstDoc, OptionalInt lastDoc) {
        ProjectionBlock projectionBlock;
        IntIterator intIterator = batchIterator.asIntIterator(new int[256]);
        ProjectionOperator projectionOperator = ProjectionOperatorUtils.getProjectionOperator(this._dataSourceMap, new BitmapDocIdSetOperator(intIterator, this._docIdBuffer));
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        while ((projectionBlock = (ProjectionBlock)projectionOperator.nextBlock()) != null) {
            this.processProjectionBlock(projectionBlock, (BitmapDataProvider)matchingDocIds);
        }
        return matchingDocIds;
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        ProjectionBlock projectionBlock;
        ProjectionOperator projectionOperator = ProjectionOperatorUtils.getProjectionOperator(this._dataSourceMap, new BitmapDocIdSetOperator((ImmutableBitmapDataProvider)docIds, this._docIdBuffer));
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        while ((projectionBlock = (ProjectionBlock)projectionOperator.nextBlock()) != null) {
            this.processProjectionBlock(projectionBlock, (BitmapDataProvider)matchingDocIds);
        }
        return matchingDocIds;
    }

    private void processProjectionBlock(ProjectionBlock projectionBlock, BitmapDataProvider matchingDocIds) {
        block72: {
            boolean predicateEvaluationResult;
            TransformResultMetadata resultMetadata;
            int numDocs;
            block70: {
                boolean predicateEvaluationResult2;
                RoaringBitmap nullBitmap;
                block71: {
                    numDocs = projectionBlock.getNumDocs();
                    resultMetadata = this._transformFunction.getResultMetadata();
                    if (!resultMetadata.isSingleValue()) break block70;
                    this._numEntriesScanned += (long)numDocs;
                    nullBitmap = null;
                    if (this._predicateEvaluationResult == PredicateEvaluationResult.NULL) {
                        nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        if (nullBitmap != null) {
                            Iterator iterator = nullBitmap.iterator();
                            while (iterator.hasNext()) {
                                int i = (Integer)iterator.next();
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        return;
                    }
                    boolean bl = predicateEvaluationResult2 = this._predicateEvaluationResult == PredicateEvaluationResult.TRUE;
                    assert (this._predicateEvaluator != null);
                    if (!resultMetadata.hasDictionary()) break block71;
                    int[] dictIds = this._transformFunction.transformToDictIdsSV(projectionBlock);
                    if (this._nullHandlingEnabled) {
                        nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                    }
                    if (nullBitmap != null && !nullBitmap.isEmpty()) {
                        for (int i = 0; i < numDocs; ++i) {
                            if (this._predicateEvaluator.applySV(dictIds[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                    } else {
                        for (int i = 0; i < numDocs; ++i) {
                            if (this._predicateEvaluator.applySV(dictIds[i]) != predicateEvaluationResult2) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                    }
                    break block72;
                }
                switch (resultMetadata.getDataType().getStoredType()) {
                    case INT: {
                        int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(intValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(intValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case LONG: {
                        long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(longValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(longValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case FLOAT: {
                        float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(floatValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(floatValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case DOUBLE: {
                        double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(doubleValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(doubleValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case STRING: {
                        String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(stringValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(stringValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case BYTES: {
                        byte[][] bytesValues = this._transformFunction.transformToBytesValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(bytesValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(bytesValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    case BIG_DECIMAL: {
                        BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                        if (this._nullHandlingEnabled) {
                            nullBitmap = this._transformFunction.getNullBitmap(projectionBlock);
                        }
                        if (nullBitmap != null && !nullBitmap.isEmpty()) {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(bigDecimalValues[i]) != predicateEvaluationResult2 || nullBitmap.contains(i)) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        } else {
                            for (int i = 0; i < numDocs; ++i) {
                                if (this._predicateEvaluator.applySV(bigDecimalValues[i]) != predicateEvaluationResult2) continue;
                                matchingDocIds.add(this._docIdBuffer[i]);
                            }
                        }
                        break block72;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this._predicateEvaluationResult == PredicateEvaluationResult.NULL) {
                return;
            }
            boolean bl = predicateEvaluationResult = this._predicateEvaluationResult == PredicateEvaluationResult.TRUE;
            assert (this._predicateEvaluator != null);
            if (resultMetadata.hasDictionary()) {
                int[][] dictIdsArray = this._transformFunction.transformToDictIdsMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    int[] dictIds = dictIdsArray[i];
                    int numDictIds = dictIds.length;
                    this._numEntriesScanned += (long)numDictIds;
                    if (this._predicateEvaluator.applyMV(dictIds, numDictIds) != predicateEvaluationResult) continue;
                    matchingDocIds.add(this._docIdBuffer[i]);
                }
            } else {
                switch (resultMetadata.getDataType().getStoredType()) {
                    case INT: {
                        int[][] intValuesArray = this._transformFunction.transformToIntValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            int[] values = intValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (this._predicateEvaluator.applyMV(values, numValues) != predicateEvaluationResult) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case LONG: {
                        long[][] longValuesArray = this._transformFunction.transformToLongValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            long[] values = longValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (this._predicateEvaluator.applyMV(values, numValues) != predicateEvaluationResult) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case FLOAT: {
                        float[][] floatValuesArray = this._transformFunction.transformToFloatValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            float[] values = floatValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (this._predicateEvaluator.applyMV(values, numValues) != predicateEvaluationResult) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case DOUBLE: {
                        double[][] doubleValuesArray = this._transformFunction.transformToDoubleValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            double[] values = doubleValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (this._predicateEvaluator.applyMV(values, numValues) != predicateEvaluationResult) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case STRING: {
                        String[][] valuesArray = this._transformFunction.transformToStringValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            String[] values = valuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (this._predicateEvaluator.applyMV(values, numValues) != predicateEvaluationResult) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    public static enum PredicateEvaluationResult {
        TRUE,
        NULL,
        FALSE;

    }

    private class RangeDocIdSetOperator
    extends BaseOperator<DocIdSetBlock> {
        static final String EXPLAIN_NAME = "DOC_ID_SET_RANGE";
        DocIdSetBlock _docIdSetBlock;

        RangeDocIdSetOperator(int startDocId, int endDocId) {
            int numDocs = endDocId - startDocId;
            for (int i = 0; i < numDocs; ++i) {
                ExpressionScanDocIdIterator.this._docIdBuffer[i] = startDocId + i;
            }
            this._docIdSetBlock = new DocIdSetBlock(ExpressionScanDocIdIterator.this._docIdBuffer, numDocs);
        }

        @Override
        protected DocIdSetBlock getNextBlock() {
            DocIdSetBlock docIdSetBlock = this._docIdSetBlock;
            this._docIdSetBlock = null;
            return docIdSetBlock;
        }

        @Override
        public String toExplainString() {
            return EXPLAIN_NAME;
        }

        @Override
        public List<Operator> getChildOperators() {
            return Collections.emptyList();
        }
    }
}

