/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public final class RangelessBitmapDocIdIterator
implements BitmapBasedDocIdIterator {
    private final ImmutableRoaringBitmap _docIds;
    private final PeekableIntIterator _docIdIterator;

    public RangelessBitmapDocIdIterator(ImmutableRoaringBitmap docIds) {
        this._docIds = docIds;
        this._docIdIterator = docIds.getIntIterator();
    }

    @Override
    public ImmutableRoaringBitmap getDocIds() {
        return this._docIds;
    }

    @Override
    public int next() {
        if (this._docIdIterator.hasNext()) {
            return this._docIdIterator.next();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        this._docIdIterator.advanceIfNeeded(targetDocId);
        return this.next();
    }
}

