/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import java.util.OptionalInt;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class SVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final PredicateEvaluator _predicateEvaluator;
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final int _numDocs;
    private final ValueMatcher _valueMatcher;
    private final int[] _batch;
    private int _firstMismatch;
    private int _cursor;
    private final int _cardinality;
    private int _nextDocId = 0;
    private long _numEntriesScanned = 0L;

    public SVScanDocIdIterator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs, int batchSize) {
        this._batch = new int[batchSize];
        this._predicateEvaluator = predicateEvaluator;
        this._reader = dataSource.getForwardIndex();
        this._readerContext = this._reader.createContext();
        this._numDocs = numDocs;
        this._valueMatcher = this.getValueMatcher();
        this._cardinality = dataSource.getDataSourceMetadata().getCardinality();
    }

    public SVScanDocIdIterator(PredicateEvaluator predicateEvaluator, ForwardIndexReader reader, int numDocs) {
        this._batch = new int[256];
        this._predicateEvaluator = predicateEvaluator;
        this._reader = reader;
        this._readerContext = reader.createContext();
        this._numDocs = numDocs;
        this._valueMatcher = this.getValueMatcher();
        this._cardinality = -1;
    }

    @Override
    public int next() {
        if (this._cursor >= this._firstMismatch) {
            int limit;
            int batchSize = 0;
            do {
                if ((limit = Math.min(this._numDocs - this._nextDocId, this._batch.length)) <= 0) continue;
                for (int i = 0; i < limit; ++i) {
                    this._batch[i] = this._nextDocId + i;
                }
                batchSize = this._valueMatcher.matchValues(limit, this._batch);
                this._nextDocId += limit;
                this._numEntriesScanned += (long)limit;
            } while (limit > 0 & batchSize == 0);
            this._firstMismatch = batchSize;
            this._cursor = 0;
            if (this._firstMismatch == 0) {
                return Integer.MIN_VALUE;
            }
        }
        return this._batch[this._cursor++];
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        this._firstMismatch = 0;
        while (this._nextDocId < this._numDocs) {
            int nextDocId;
            ++this._nextDocId;
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesValueMatch(nextDocId)) continue;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public MutableRoaringBitmap applyAnd(BatchIterator docIdIterator, OptionalInt firstDoc, OptionalInt lastDoc) {
        if (!docIdIterator.hasNext()) {
            return new MutableRoaringBitmap();
        }
        RoaringBitmapWriter result = firstDoc.isPresent() && lastDoc.isPresent() ? RoaringBitmapWriter.bufferWriter().expectedRange((long)firstDoc.getAsInt(), (long)lastDoc.getAsInt()).runCompress(false).get() : RoaringBitmapWriter.bufferWriter().runCompress(false).get();
        int[] buffer = new int[this._batch.length];
        while (docIdIterator.hasNext()) {
            int limit = docIdIterator.nextBatch(buffer);
            if (limit > 0) {
                int firstMismatch = this._valueMatcher.matchValues(limit, buffer);
                for (int i = 0; i < firstMismatch; ++i) {
                    result.add(buffer[i]);
                }
            }
            this._numEntriesScanned += (long)limit;
        }
        return (MutableRoaringBitmap)result.get();
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    @Override
    public float getEstimatedCardinality(boolean isAndDocIdSet) {
        int numMatchingItems = this._predicateEvaluator.getNumMatchingItems();
        if (numMatchingItems == Integer.MIN_VALUE || this._cardinality < 0) {
            return ScanBasedDocIdIterator.super.getEstimatedCardinality(isAndDocIdSet);
        }
        numMatchingItems = numMatchingItems > 0 ? numMatchingItems : numMatchingItems + this._cardinality;
        return (float)this._cardinality / (float)numMatchingItems;
    }

    private ValueMatcher getValueMatcher() {
        if (this._reader.isDictionaryEncoded()) {
            return new DictIdMatcher();
        }
        switch (this._reader.getStoredType()) {
            case INT: {
                return new IntMatcher();
            }
            case LONG: {
                return new LongMatcher();
            }
            case FLOAT: {
                return new FloatMatcher();
            }
            case DOUBLE: {
                return new DoubleMatcher();
            }
            case BIG_DECIMAL: {
                return new BigDecimalMatcher();
            }
            case STRING: {
                return new StringMatcher();
            }
            case BYTES: {
                return new BytesMatcher();
            }
        }
        throw new UnsupportedOperationException();
    }

    private class BytesMatcher
    implements ValueMatcher {
        private BytesMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBytes(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class StringMatcher
    implements ValueMatcher {
        private StringMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getString(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class BigDecimalMatcher
    implements ValueMatcher {
        private BigDecimalMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBigDecimal(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class DoubleMatcher
    implements ValueMatcher {
        private final double[] _buffer;

        private DoubleMatcher() {
            this._buffer = new double[SVScanDocIdIterator.this._batch.length];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDouble(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class FloatMatcher
    implements ValueMatcher {
        private final float[] _buffer;

        private FloatMatcher() {
            this._buffer = new float[SVScanDocIdIterator.this._batch.length];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getFloat(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class LongMatcher
    implements ValueMatcher {
        private final long[] _buffer;

        private LongMatcher() {
            this._buffer = new long[SVScanDocIdIterator.this._batch.length];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getLong(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class IntMatcher
    implements ValueMatcher {
        private final int[] _buffer;

        private IntMatcher() {
            this._buffer = new int[SVScanDocIdIterator.this._batch.length];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getInt(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class DictIdMatcher
    implements ValueMatcher {
        private final int[] _buffer;

        private DictIdMatcher() {
            this._buffer = new int[SVScanDocIdIterator.this._batch.length];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDictId(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readDictIds(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private static interface ValueMatcher {
        public boolean doesValueMatch(int var1);

        default public int matchValues(int limit, int[] docIds) {
            int matchCount = 0;
            for (int i = 0; i < limit; ++i) {
                int docId = docIds[i];
                if (!this.doesValueMatch(docId)) continue;
                docIds[matchCount++] = docId;
            }
            return matchCount;
        }
    }
}

