/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.operator.dociditerators.AndDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.RangelessBitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.SortedDocIdIterator;
import org.apache.pinot.core.util.SortedRangeIntersection;
import org.apache.pinot.spi.utils.Pairs;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class AndDocIdSet
implements BlockDocIdSet {
    private final AtomicReference<List<BlockDocIdSet>> _scanBasedDocIdSets = new AtomicReference();
    private final boolean _cardinalityBasedRankingForScan;
    private List<BlockDocIdSet> _docIdSets;
    private volatile long _numEntriesScannedInFilter;

    public AndDocIdSet(List<BlockDocIdSet> docIdSets, @Nullable Map<String, String> queryOptions) {
        this._docIdSets = docIdSets;
        this._cardinalityBasedRankingForScan = queryOptions != null && QueryOptionsUtils.isAndScanReorderingEnabled(queryOptions);
    }

    @Override
    public BlockDocIdIterator iterator() {
        int numDocIdSets = this._docIdSets.size();
        BlockDocIdIterator[] allDocIdIterators = new BlockDocIdIterator[numDocIdSets];
        ArrayList<SortedDocIdIterator> sortedDocIdIterators = new ArrayList<SortedDocIdIterator>();
        ArrayList<BitmapBasedDocIdIterator> bitmapBasedDocIdIterators = new ArrayList<BitmapBasedDocIdIterator>();
        ArrayList<ScanBasedDocIdIterator> scanBasedDocIdIterators = new ArrayList<ScanBasedDocIdIterator>();
        ArrayList<BlockDocIdIterator> remainingDocIdIterators = new ArrayList<BlockDocIdIterator>();
        long numEntriesScannedForNonScanBasedDocIdSets = 0L;
        ArrayList<BlockDocIdSet> scanBasedDocIdSets = new ArrayList<BlockDocIdSet>();
        for (int i = 0; i < numDocIdSets; ++i) {
            BlockDocIdIterator docIdIterator;
            BlockDocIdSet docIdSet = this._docIdSets.get(i);
            allDocIdIterators[i] = docIdIterator = docIdSet.iterator();
            if (docIdIterator instanceof SortedDocIdIterator) {
                sortedDocIdIterators.add((SortedDocIdIterator)docIdIterator);
                numEntriesScannedForNonScanBasedDocIdSets += docIdSet.getNumEntriesScannedInFilter();
                continue;
            }
            if (docIdIterator instanceof BitmapBasedDocIdIterator) {
                bitmapBasedDocIdIterators.add((BitmapBasedDocIdIterator)docIdIterator);
                numEntriesScannedForNonScanBasedDocIdSets += docIdSet.getNumEntriesScannedInFilter();
                continue;
            }
            if (docIdIterator instanceof ScanBasedDocIdIterator) {
                scanBasedDocIdIterators.add((ScanBasedDocIdIterator)docIdIterator);
                scanBasedDocIdSets.add(docIdSet);
                continue;
            }
            remainingDocIdIterators.add(docIdIterator);
            scanBasedDocIdSets.add(docIdSet);
        }
        this._docIdSets = null;
        this._numEntriesScannedInFilter = numEntriesScannedForNonScanBasedDocIdSets;
        this._scanBasedDocIdSets.set(scanBasedDocIdSets);
        bitmapBasedDocIdIterators.sort(Comparator.comparing(x -> x.getDocIds().getCardinality()));
        if (this._cardinalityBasedRankingForScan) {
            scanBasedDocIdIterators.sort(Comparator.comparing(x -> Float.valueOf(-x.getEstimatedCardinality(true))));
        }
        int numSortedDocIdIterators = sortedDocIdIterators.size();
        int numBitmapBasedDocIdIterators = bitmapBasedDocIdIterators.size();
        int numScanBasedDocIdIterators = scanBasedDocIdIterators.size();
        int numRemainingDocIdIterators = remainingDocIdIterators.size();
        int numIndexBasedDocIdIterators = numSortedDocIdIterators + numBitmapBasedDocIdIterators;
        if (numIndexBasedDocIdIterators > 0 && numScanBasedDocIdIterators > 0 || numIndexBasedDocIdIterators > 1) {
            Object docIds;
            if (numSortedDocIdIterators > 0) {
                List<Pairs.IntPair> docIdRanges;
                if (numSortedDocIdIterators == 1) {
                    docIdRanges = ((SortedDocIdIterator)sortedDocIdIterators.get(0)).getDocIdRanges();
                } else {
                    ArrayList<List<Pairs.IntPair>> docIdRangesList = new ArrayList<List<Pairs.IntPair>>(numSortedDocIdIterators);
                    for (SortedDocIdIterator sortedDocIdIterator : sortedDocIdIterators) {
                        docIdRangesList.add(sortedDocIdIterator.getDocIdRanges());
                    }
                    docIdRanges = SortedRangeIntersection.intersectSortedRangeSets(docIdRangesList);
                }
                MutableRoaringBitmap mutableDocIds = new MutableRoaringBitmap();
                for (Pairs.IntPair docIdRange : docIdRanges) {
                    mutableDocIds.add((long)docIdRange.getLeft(), (long)docIdRange.getRight() + 1L);
                }
                for (BitmapBasedDocIdIterator bitmapBasedDocIdIterator : bitmapBasedDocIdIterators) {
                    mutableDocIds.and(bitmapBasedDocIdIterator.getDocIds());
                }
                docIds = mutableDocIds;
            } else if (numBitmapBasedDocIdIterators == 1) {
                docIds = ((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(0)).getDocIds();
            } else {
                MutableRoaringBitmap mutableDocIds = ((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(0)).getDocIds().toMutableRoaringBitmap();
                for (int i = 1; i < numBitmapBasedDocIdIterators; ++i) {
                    mutableDocIds.and(((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(i)).getDocIds());
                }
                docIds = mutableDocIds;
            }
            for (ScanBasedDocIdIterator scanBasedDocIdIterator : scanBasedDocIdIterators) {
                docIds = scanBasedDocIdIterator.applyAnd((ImmutableRoaringBitmap)docIds);
            }
            RangelessBitmapDocIdIterator rangelessBitmapDocIdIterator = new RangelessBitmapDocIdIterator((ImmutableRoaringBitmap)docIds);
            if (numRemainingDocIdIterators == 0) {
                return rangelessBitmapDocIdIterator;
            }
            BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[numRemainingDocIdIterators + 1];
            docIdIterators[0] = rangelessBitmapDocIdIterator;
            for (int i = 0; i < numRemainingDocIdIterators; ++i) {
                docIdIterators[i + 1] = (BlockDocIdIterator)remainingDocIdIterators.get(i);
            }
            return new AndDocIdIterator(docIdIterators);
        }
        return new AndDocIdIterator(allDocIdIterators);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        List<BlockDocIdSet> scanBasedDocIdSets = this._scanBasedDocIdSets.get();
        long numEntriesScannedForScanBasedDocIdSets = 0L;
        if (scanBasedDocIdSets != null) {
            for (BlockDocIdSet scanBasedDocIdSet : scanBasedDocIdSets) {
                numEntriesScannedForScanBasedDocIdSets += scanBasedDocIdSet.getNumEntriesScannedInFilter();
            }
        }
        return this._numEntriesScannedInFilter + numEntriesScannedForScanBasedDocIdSets;
    }
}

