/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.AndDocIdSet;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.docidsets.NotDocIdSet;
import org.apache.pinot.core.operator.docidsets.OrDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class AndFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_AND";
    private final List<BaseFilterOperator> _filterOperators;
    private final Map<String, String> _queryOptions;

    public AndFilterOperator(List<BaseFilterOperator> filterOperators, @Nullable Map<String, String> queryOptions, int numDocs, boolean nullHandlingEnabled) {
        super(numDocs, nullHandlingEnabled);
        this._filterOperators = filterOperators;
        this._queryOptions = queryOptions;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        Tracing.activeRecording().setNumChildren(this._filterOperators.size());
        ArrayList<BlockDocIdSet> blockDocIdSets = new ArrayList<BlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            blockDocIdSets.add(filterOperator.getTrues());
        }
        return new AndDocIdSet(blockDocIdSets, this._queryOptions);
    }

    @Override
    protected BlockDocIdSet getFalses() {
        ArrayList<BlockDocIdSet> blockDocIdSets = new ArrayList<BlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            BlockDocIdSet nulls;
            BlockDocIdSet trues = filterOperator.getTrues();
            if (trues instanceof EmptyDocIdSet) {
                return new MatchAllDocIdSet(this._numDocs);
            }
            if (trues instanceof MatchAllDocIdSet) continue;
            if (this._nullHandlingEnabled && !((nulls = filterOperator.getNulls()) instanceof EmptyDocIdSet)) {
                blockDocIdSets.add(new OrDocIdSet(Arrays.asList(trues, nulls), this._numDocs));
                continue;
            }
            blockDocIdSets.add(trues);
        }
        if (blockDocIdSets.isEmpty()) {
            return EmptyDocIdSet.getInstance();
        }
        if (blockDocIdSets.size() == 1) {
            return new NotDocIdSet((BlockDocIdSet)blockDocIdSets.get(0), this._numDocs);
        }
        return new NotDocIdSet(new AndDocIdSet(blockDocIdSets, this._queryOptions), this._numDocs);
    }

    @Override
    public boolean canOptimizeCount() {
        boolean allChildrenCanProduceBitmaps = true;
        for (BaseFilterOperator child : this._filterOperators) {
            allChildrenCanProduceBitmaps &= child.canProduceBitmaps();
        }
        return allChildrenCanProduceBitmaps;
    }

    @Override
    public int getNumMatchingDocs() {
        if (this._filterOperators.size() == 2) {
            return this._filterOperators.get(0).getBitmaps().andCardinality(this._filterOperators.get(1).getBitmaps());
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[this._filterOperators.size()];
        int i = 0;
        for (BaseFilterOperator child : this._filterOperators) {
            bitmaps[i++] = child.getBitmaps().reduce();
        }
        return BufferFastAggregation.andCardinality((ImmutableRoaringBitmap[])bitmaps);
    }

    @Override
    public List<Operator> getChildOperators() {
        return new ArrayList<Operator>(this._filterOperators);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }
}

