/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class BitmapBasedFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_BITMAP";
    private final ImmutableRoaringBitmap _docIds;
    private final boolean _exclusive;

    public BitmapBasedFilterOperator(ImmutableRoaringBitmap docIds, boolean exclusive, int numDocs) {
        super(numDocs, false);
        this._docIds = docIds;
        this._exclusive = exclusive;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._exclusive) {
            return new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)this._docIds, (long)0L, (long)this._numDocs), this._numDocs);
        }
        return new BitmapDocIdSet(this._docIds, this._numDocs);
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        int count = this._docIds.getCardinality();
        return this._exclusive ? this._numDocs - count : count;
    }

    @Override
    public boolean canProduceBitmaps() {
        return true;
    }

    @Override
    public BitmapCollection getBitmaps() {
        return new BitmapCollection(this._numDocs, this._exclusive, this._docIds);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }
}

