/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.locationtech.jts.geom.Geometry;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class H3InclusionIndexFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "INCLUSION_FILTER_H3_INDEX";
    private static final String LITERAL_H3_CELLS_CACHE_NAME = "st_contain_literal_h3_cells";
    private final IndexSegment _segment;
    private final QueryContext _queryContext;
    private final Predicate _predicate;
    private final H3IndexReader _h3IndexReader;
    private final Geometry _geometry;
    private final boolean _isPositiveCheck;

    public H3InclusionIndexFilterOperator(IndexSegment segment, QueryContext queryContext, Predicate predicate, int numDocs) {
        super(numDocs, false);
        this._segment = segment;
        this._queryContext = queryContext;
        this._predicate = predicate;
        List arguments = predicate.getLhs().getFunction().getArguments();
        EqPredicate eqPredicate = (EqPredicate)predicate;
        this._isPositiveCheck = BooleanUtils.toBoolean((String)eqPredicate.getValue());
        if (((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER) {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(0)).getIdentifier()).getH3Index();
            this._geometry = GeometrySerializer.deserialize((byte[])((ExpressionContext)arguments.get(1)).getLiteral().getBytesValue());
        } else {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(1)).getIdentifier()).getH3Index();
            this._geometry = GeometrySerializer.deserialize((byte[])((ExpressionContext)arguments.get(0)).getLiteral().getBytesValue());
        }
        assert (this._h3IndexReader != null) : "the column must have H3 index setup.";
    }

    @Override
    protected BlockDocIdSet getTrues() {
        Pair fullyAndPotentiallyCoveredCells = this._queryContext.getOrComputeSharedValue(Pair.class, LITERAL_H3_CELLS_CACHE_NAME, k -> H3Utils.coverGeometryInH3((Geometry)this._geometry, (int)this._h3IndexReader.getH3IndexResolution().getLowestResolution()));
        LongSet fullyCoveredCells = (LongSet)fullyAndPotentiallyCoveredCells.getLeft();
        LongSet potentiallyCoveredCells = (LongSet)fullyAndPotentiallyCoveredCells.getRight();
        int numFullyCoveredCells = fullyCoveredCells.size();
        ImmutableRoaringBitmap[] fullMatchDocIds = new ImmutableRoaringBitmap[numFullyCoveredCells];
        LongIterator fullyCoveredCellsIterator = fullyCoveredCells.iterator();
        for (int i = 0; i < numFullyCoveredCells; ++i) {
            fullMatchDocIds[i] = this._h3IndexReader.getDocIds(fullyCoveredCellsIterator.nextLong());
        }
        MutableRoaringBitmap fullMatch = BufferFastAggregation.or((ImmutableRoaringBitmap[])fullMatchDocIds);
        int numPotentiallyCoveredCells = potentiallyCoveredCells.size();
        ImmutableRoaringBitmap[] potentialMatchDocIds = new ImmutableRoaringBitmap[numPotentiallyCoveredCells];
        LongIterator potentiallyCoveredCellsIterator = potentiallyCoveredCells.iterator();
        for (int i = 0; i < numPotentiallyCoveredCells; ++i) {
            potentialMatchDocIds[i] = this._h3IndexReader.getDocIds(potentiallyCoveredCellsIterator.nextLong());
        }
        MutableRoaringBitmap potentialMatch = BufferFastAggregation.or((ImmutableRoaringBitmap[])potentialMatchDocIds);
        if (this._isPositiveCheck) {
            return this.getFilterBlock(fullMatch, potentialMatch);
        }
        MutableRoaringBitmap fullNotMatch = potentialMatch.clone();
        fullNotMatch.flip(0L, (long)this._numDocs);
        fullNotMatch.andNot((ImmutableRoaringBitmap)fullMatch);
        return this.getFilterBlock(fullNotMatch, potentialMatch);
    }

    private BlockDocIdSet getFilterBlock(MutableRoaringBitmap fullMatchDocIds, MutableRoaringBitmap partialMatchDocIds) {
        ExpressionFilterOperator expressionFilterOperator = new ExpressionFilterOperator(this._segment, this._queryContext, this._predicate, this._numDocs);
        final ScanBasedDocIdIterator docIdIterator = (ScanBasedDocIdIterator)expressionFilterOperator.getTrues().iterator();
        MutableRoaringBitmap result = docIdIterator.applyAnd((ImmutableRoaringBitmap)partialMatchDocIds);
        result.or((ImmutableRoaringBitmap)fullMatchDocIds);
        return new BitmapDocIdSet((ImmutableRoaringBitmap)result, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return docIdIterator.getNumEntriesScanned();
            }
        };
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(inclusionIndex:h3_index");
        stringBuilder.append(",operator:").append(this._predicate.getType());
        stringBuilder.append(",predicate:").append(this._predicate.toString());
        return stringBuilder.append(')').toString();
    }
}

