/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.filter.BaseColumnFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.spi.trace.FilterType;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class InvertedIndexFilterOperator
extends BaseColumnFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_INVERTED_INDEX";
    private final PredicateEvaluator _predicateEvaluator;
    private final InvertedIndexReader<ImmutableRoaringBitmap> _invertedIndexReader;
    private final boolean _exclusive;

    InvertedIndexFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        super(queryContext, dataSource, numDocs);
        InvertedIndexReader invertedIndexReader;
        this._predicateEvaluator = predicateEvaluator;
        this._invertedIndexReader = invertedIndexReader = dataSource.getInvertedIndex();
        this._exclusive = predicateEvaluator.isExclusive();
    }

    @Override
    protected BlockDocIdSet getNextBlockWithoutNullHandling() {
        InvocationRecording recording;
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        int numDictIds = dictIds.length;
        if (numDictIds == 0) {
            return EmptyDocIdSet.getInstance();
        }
        if (numDictIds == 1) {
            ImmutableRoaringBitmap docIds = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[0]);
            if (this._exclusive) {
                if (docIds instanceof MutableRoaringBitmap) {
                    MutableRoaringBitmap mutableRoaringBitmap = (MutableRoaringBitmap)docIds;
                    mutableRoaringBitmap.flip(0L, (long)this._numDocs);
                    return new BitmapDocIdSet((ImmutableRoaringBitmap)mutableRoaringBitmap, this._numDocs);
                }
                return new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)docIds, (long)0L, (long)this._numDocs), this._numDocs);
            }
            return new BitmapDocIdSet(docIds, this._numDocs);
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[numDictIds];
        for (int i = 0; i < numDictIds; ++i) {
            bitmaps[i] = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[i]);
        }
        MutableRoaringBitmap docIds = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap[])bitmaps);
        if (this._exclusive) {
            docIds.flip(0L, (long)this._numDocs);
        }
        if ((recording = Tracing.activeRecording()).isEnabled()) {
            recording.setColumnName(this._predicateEvaluator.getPredicate().getLhs().getIdentifier());
            recording.setNumDocsMatchingAfterFilter(docIds.getCardinality());
            recording.setFilter(FilterType.INDEX, String.valueOf(this._predicateEvaluator.getPredicateType()));
        }
        return new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs);
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        int count = 0;
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        switch (dictIds.length) {
            case 0: {
                break;
            }
            case 1: {
                count = ((ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[0])).getCardinality();
                break;
            }
            case 2: {
                count = ImmutableRoaringBitmap.orCardinality((ImmutableRoaringBitmap)((ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[0])), (ImmutableRoaringBitmap)((ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[1])));
                break;
            }
            default: {
                MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
                for (int dictId : dictIds) {
                    bitmap.or((ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictId));
                }
                count = bitmap.getCardinality();
                break;
            }
        }
        return this._exclusive ? this._numDocs - count : count;
    }

    @Override
    public boolean canProduceBitmaps() {
        return true;
    }

    @Override
    public BitmapCollection getBitmaps() {
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[dictIds.length];
        for (int i = 0; i < dictIds.length; ++i) {
            bitmaps[i] = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[i]);
        }
        return new BitmapCollection(this._numDocs, this._exclusive, bitmaps);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:inverted_index");
        Predicate predicate = this._predicateEvaluator.getPredicate();
        stringBuilder.append(",operator:").append(predicate.getType());
        stringBuilder.append(",predicate:").append(predicate.toString());
        return stringBuilder.append(')').toString();
    }
}

