/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;

public class NotFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_NOT";
    private final BaseFilterOperator _filterOperator;

    public NotFilterOperator(BaseFilterOperator filterOperator, int numDocs, boolean nullHandlingEnabled) {
        super(numDocs, nullHandlingEnabled);
        this._filterOperator = filterOperator;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._filterOperator);
    }

    @Override
    @Nullable
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._filterOperator.isResultEmpty()) {
            return new MatchAllDocIdSet(this._numDocs);
        }
        return this._filterOperator.getFalses();
    }

    @Override
    protected BlockDocIdSet getFalses() {
        return this._filterOperator.getTrues();
    }

    @Override
    public boolean canOptimizeCount() {
        return this._filterOperator.canOptimizeCount();
    }

    @Override
    public int getNumMatchingDocs() {
        return this._numDocs - this._filterOperator.getNumMatchingDocs();
    }

    @Override
    public boolean canProduceBitmaps() {
        return this._filterOperator.canProduceBitmaps();
    }

    @Override
    public BitmapCollection getBitmaps() {
        return this._filterOperator.getBitmaps().invert();
    }

    public BaseFilterOperator getChildFilterOperator() {
        return this._filterOperator;
    }
}

