/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.docidsets.NotDocIdSet;
import org.apache.pinot.core.operator.docidsets.OrDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class OrFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_OR";
    private final List<BaseFilterOperator> _filterOperators;
    private final Map<String, String> _queryOptions;

    public OrFilterOperator(List<BaseFilterOperator> filterOperators, @Nullable Map<String, String> queryOptions, int numDocs, boolean nullHandlingEnabled) {
        super(numDocs, nullHandlingEnabled);
        this._filterOperators = filterOperators;
        this._queryOptions = queryOptions;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        Tracing.activeRecording().setNumChildren(this._filterOperators.size());
        ArrayList<BlockDocIdSet> blockDocIdSets = new ArrayList<BlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            blockDocIdSets.add(filterOperator.getTrues());
        }
        return new OrDocIdSet(blockDocIdSets, this._numDocs);
    }

    @Override
    protected BlockDocIdSet getFalses() {
        ArrayList<BlockDocIdSet> blockDocIdSets = new ArrayList<BlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            BlockDocIdSet nulls;
            BlockDocIdSet trues = filterOperator.getTrues();
            if (trues instanceof MatchAllDocIdSet) {
                return EmptyDocIdSet.getInstance();
            }
            if (trues instanceof EmptyDocIdSet) continue;
            if (this._nullHandlingEnabled && !((nulls = filterOperator.getNulls()) instanceof EmptyDocIdSet)) {
                blockDocIdSets.add(new OrDocIdSet(Arrays.asList(trues, nulls), this._numDocs));
                continue;
            }
            blockDocIdSets.add(trues);
        }
        if (blockDocIdSets.isEmpty()) {
            return new MatchAllDocIdSet(this._numDocs);
        }
        if (blockDocIdSets.size() == 1) {
            return new NotDocIdSet((BlockDocIdSet)blockDocIdSets.get(0), this._numDocs);
        }
        return new NotDocIdSet(new OrDocIdSet(blockDocIdSets, this._numDocs), this._numDocs);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return new ArrayList<Operator>(this._filterOperators);
    }

    @Override
    public boolean canOptimizeCount() {
        boolean allChildrenProduceBitmaps = true;
        for (BaseFilterOperator child : this._filterOperators) {
            allChildrenProduceBitmaps &= child.canProduceBitmaps();
        }
        return allChildrenProduceBitmaps;
    }

    @Override
    public int getNumMatchingDocs() {
        if (this._filterOperators.size() == 2) {
            return this._filterOperators.get(0).getBitmaps().orCardinality(this._filterOperators.get(1).getBitmaps());
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[this._filterOperators.size()];
        for (int i = 0; i < this._filterOperators.size(); ++i) {
            bitmaps[i] = this._filterOperators.get(i).getBitmaps().reduce();
        }
        return BufferFastAggregation.orCardinality((ImmutableRoaringBitmap[])bitmaps);
    }
}

