/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseColumnFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.traits.DoubleRange;
import org.apache.pinot.core.operator.filter.predicate.traits.DoubleValue;
import org.apache.pinot.core.operator.filter.predicate.traits.FloatRange;
import org.apache.pinot.core.operator.filter.predicate.traits.FloatValue;
import org.apache.pinot.core.operator.filter.predicate.traits.IntRange;
import org.apache.pinot.core.operator.filter.predicate.traits.IntValue;
import org.apache.pinot.core.operator.filter.predicate.traits.LongRange;
import org.apache.pinot.core.operator.filter.predicate.traits.LongValue;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.FilterType;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RangeIndexBasedFilterOperator
extends BaseColumnFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_RANGE_INDEX";
    private final RangeIndexReader<ImmutableRoaringBitmap> _rangeIndexReader;
    private final PredicateEvaluator _predicateEvaluator;
    private final FieldSpec.DataType _parameterType;

    static boolean canEvaluate(PredicateEvaluator predicateEvaluator, DataSource dataSource) {
        Predicate.Type type = predicateEvaluator.getPredicateType();
        RangeIndexReader rangeIndex = dataSource.getRangeIndex();
        return rangeIndex != null && (type == Predicate.Type.RANGE || type == Predicate.Type.EQ && dataSource.getRangeIndex().isExact());
    }

    public RangeIndexBasedFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        super(queryContext, dataSource, numDocs);
        this._predicateEvaluator = predicateEvaluator;
        this._rangeIndexReader = dataSource.getRangeIndex();
        this._parameterType = predicateEvaluator.isDictionaryBased() ? FieldSpec.DataType.INT : predicateEvaluator.getDataType();
    }

    @Override
    protected BlockDocIdSet getNextBlockWithoutNullHandling() {
        if (this._rangeIndexReader.isExact()) {
            ImmutableRoaringBitmap matches = this.getMatchingDocIds();
            this.recordFilter(matches);
            return new BitmapDocIdSet(matches, this._numDocs);
        }
        return this.evaluateLegacyRangeFilter();
    }

    private BlockDocIdSet evaluateLegacyRangeFilter() {
        ImmutableRoaringBitmap matches = this.getMatchingDocIds();
        ImmutableRoaringBitmap partialMatches = this.getPartiallyMatchingDocIds();
        if (partialMatches == null) {
            return new BitmapDocIdSet((ImmutableRoaringBitmap)(matches == null ? new MutableRoaringBitmap() : matches), this._numDocs);
        }
        ScanBasedFilterOperator scanBasedFilterOperator = new ScanBasedFilterOperator(this._queryContext, this._predicateEvaluator, this._dataSource, this._numDocs);
        final BlockDocIdSet scanBasedDocIdSet = scanBasedFilterOperator.getTrues();
        MutableRoaringBitmap docIds = ((ScanBasedDocIdIterator)scanBasedDocIdSet.iterator()).applyAnd(partialMatches);
        if (matches != null) {
            docIds.or(matches);
        }
        this.recordFilter(matches);
        return new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return scanBasedDocIdSet.getNumEntriesScannedInFilter();
            }
        };
    }

    ImmutableRoaringBitmap getMatchingDocIds() {
        switch (this._parameterType) {
            case INT: {
                if (this._predicateEvaluator instanceof IntValue) {
                    return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(((IntValue)((Object)this._predicateEvaluator)).getInt());
                }
                IntRange intRange = (IntRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(intRange.getInclusiveLowerBound(), intRange.getInclusiveUpperBound());
            }
            case LONG: {
                if (this._predicateEvaluator instanceof LongValue) {
                    return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(((LongValue)((Object)this._predicateEvaluator)).getLong());
                }
                LongRange longRange = (LongRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(longRange.getInclusiveLowerBound(), longRange.getInclusiveUpperBound());
            }
            case FLOAT: {
                if (this._predicateEvaluator instanceof FloatValue) {
                    return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(((FloatValue)((Object)this._predicateEvaluator)).getFloat());
                }
                FloatRange floatRange = (FloatRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(floatRange.getInclusiveLowerBound(), floatRange.getInclusiveUpperBound());
            }
            case DOUBLE: {
                if (this._predicateEvaluator instanceof DoubleValue) {
                    return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(((DoubleValue)((Object)this._predicateEvaluator)).getDouble());
                }
                DoubleRange doubleRange = (DoubleRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(doubleRange.getInclusiveLowerBound(), doubleRange.getInclusiveUpperBound());
            }
        }
        throw RangeIndexBasedFilterOperator.unsupportedDataType(this._parameterType);
    }

    ImmutableRoaringBitmap getPartiallyMatchingDocIds() {
        assert (!this._rangeIndexReader.isExact());
        switch (this._parameterType) {
            case INT: {
                IntRange intRange = (IntRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(intRange.getInclusiveLowerBound(), intRange.getInclusiveUpperBound());
            }
            case LONG: {
                LongRange longRange = (LongRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(longRange.getInclusiveLowerBound(), longRange.getInclusiveUpperBound());
            }
            case FLOAT: {
                FloatRange floatRange = (FloatRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(floatRange.getInclusiveLowerBound(), floatRange.getInclusiveUpperBound());
            }
            case DOUBLE: {
                DoubleRange doubleRange = (DoubleRange)((Object)this._predicateEvaluator);
                return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(doubleRange.getInclusiveLowerBound(), doubleRange.getInclusiveUpperBound());
            }
        }
        throw RangeIndexBasedFilterOperator.unsupportedDataType(this._parameterType);
    }

    @Override
    public boolean canOptimizeCount() {
        return this._rangeIndexReader.isExact();
    }

    @Override
    public int getNumMatchingDocs() {
        switch (this._parameterType) {
            case INT: {
                if (this._predicateEvaluator instanceof IntValue) {
                    return this._rangeIndexReader.getNumMatchingDocs(((IntValue)((Object)this._predicateEvaluator)).getInt());
                }
                IntRange intRange = (IntRange)((Object)this._predicateEvaluator);
                return this._rangeIndexReader.getNumMatchingDocs(intRange.getInclusiveLowerBound(), intRange.getInclusiveUpperBound());
            }
            case LONG: {
                if (this._predicateEvaluator instanceof LongValue) {
                    return this._rangeIndexReader.getNumMatchingDocs(((LongValue)((Object)this._predicateEvaluator)).getLong());
                }
                LongRange longRange = (LongRange)((Object)this._predicateEvaluator);
                return this._rangeIndexReader.getNumMatchingDocs(longRange.getInclusiveLowerBound(), longRange.getInclusiveUpperBound());
            }
            case FLOAT: {
                if (this._predicateEvaluator instanceof FloatValue) {
                    return this._rangeIndexReader.getNumMatchingDocs(((FloatValue)((Object)this._predicateEvaluator)).getFloat());
                }
                FloatRange floatRange = (FloatRange)((Object)this._predicateEvaluator);
                return this._rangeIndexReader.getNumMatchingDocs(floatRange.getInclusiveLowerBound(), floatRange.getInclusiveUpperBound());
            }
            case DOUBLE: {
                if (this._predicateEvaluator instanceof DoubleValue) {
                    return this._rangeIndexReader.getNumMatchingDocs(((DoubleValue)((Object)this._predicateEvaluator)).getDouble());
                }
                DoubleRange doubleRange = (DoubleRange)((Object)this._predicateEvaluator);
                return this._rangeIndexReader.getNumMatchingDocs(doubleRange.getInclusiveLowerBound(), doubleRange.getInclusiveUpperBound());
            }
        }
        throw RangeIndexBasedFilterOperator.unsupportedDataType(this._parameterType);
    }

    @Override
    public boolean canProduceBitmaps() {
        return this._rangeIndexReader.isExact();
    }

    @Override
    public BitmapCollection getBitmaps() {
        return new BitmapCollection(this._numDocs, false, this.getMatchingDocIds());
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        return "FILTER_RANGE_INDEX(indexLookUp:range_index,operator:" + this._predicateEvaluator.getPredicateType() + ",predicate:" + this._predicateEvaluator.getPredicate().toString() + ")";
    }

    static RuntimeException unsupportedPredicateType(Predicate.Type type) {
        return new IllegalStateException("Range index cannot satisfy " + type);
    }

    static RuntimeException unsupportedDataType(FieldSpec.DataType dataType) {
        return new IllegalStateException("Range index does not support " + dataType);
    }

    private void recordFilter(ImmutableRoaringBitmap bitmap) {
        InvocationRecording recording = Tracing.activeRecording();
        if (recording.isEnabled()) {
            recording.setNumDocsMatchingAfterFilter(bitmap == null ? 0 : bitmap.getCardinality());
            recording.setColumnName(this._dataSource.getDataSourceMetadata().getFieldSpec().getName());
            recording.setFilter(FilterType.INDEX, this._predicateEvaluator.getPredicateType().name());
            recording.setNumDocsScanned(this._numDocs);
        }
    }
}

