/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.MVScanDocIdSet;
import org.apache.pinot.core.operator.docidsets.SVScanDocIdSet;
import org.apache.pinot.core.operator.filter.BaseColumnFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;

public class ScanBasedFilterOperator
extends BaseColumnFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_FULL_SCAN";
    private final PredicateEvaluator _predicateEvaluator;
    private final int _batchSize;

    public ScanBasedFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this(queryContext, predicateEvaluator, dataSource, numDocs, 256);
    }

    public ScanBasedFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs, int batchSize) {
        super(queryContext, dataSource, numDocs);
        this._predicateEvaluator = predicateEvaluator;
        Preconditions.checkState((this._dataSource.getForwardIndex() != null ? 1 : 0) != 0, (String)"Forward index disabled for column: %s, scan based filtering not supported!", (Object)this._dataSource.getDataSourceMetadata().getFieldSpec().getName());
        this._batchSize = batchSize;
    }

    @Override
    protected BlockDocIdSet getNextBlockWithoutNullHandling() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        if (dataSourceMetadata.isSingleValue()) {
            return new SVScanDocIdSet(this._predicateEvaluator, this._dataSource, this._numDocs, this._batchSize);
        }
        return new MVScanDocIdSet(this._predicateEvaluator, this._dataSource, this._numDocs);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(operator:").append(this._predicateEvaluator.getPredicateType());
        stringBuilder.append(",predicate:").append(this._predicateEvaluator.getPredicate().toString());
        return stringBuilder.append(')').toString();
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSource.getDataSourceMetadata();
    }
}

