/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.math.BigDecimal;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.BasePredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class BaseDictionaryBasedPredicateEvaluator
extends BasePredicateEvaluator {
    protected final Dictionary _dictionary;
    protected boolean _alwaysTrue;
    protected boolean _alwaysFalse;
    protected int[] _matchingDictIds;
    protected int[] _nonMatchingDictIds;

    protected BaseDictionaryBasedPredicateEvaluator(Predicate predicate, Dictionary dictionary) {
        super(predicate);
        this._dictionary = dictionary;
    }

    @Override
    public final boolean isDictionaryBased() {
        return true;
    }

    @Override
    public FieldSpec.DataType getDataType() {
        return FieldSpec.DataType.INT;
    }

    @Override
    public boolean isAlwaysTrue() {
        return this._alwaysTrue;
    }

    @Override
    public boolean isAlwaysFalse() {
        return this._alwaysFalse;
    }

    @Override
    public int[] getMatchingDictIds() {
        if (this._matchingDictIds == null) {
            this._matchingDictIds = this.calculateMatchingDictIds();
        }
        return this._matchingDictIds;
    }

    protected int[] calculateMatchingDictIds() {
        IntArrayList matchingDictIds = new IntArrayList();
        int dictionarySize = this._dictionary.length();
        for (int dictId = 0; dictId < dictionarySize; ++dictId) {
            if (!this.applySV(dictId)) continue;
            matchingDictIds.add(dictId);
        }
        return matchingDictIds.toIntArray();
    }

    @Override
    public int[] getNonMatchingDictIds() {
        if (this._nonMatchingDictIds == null) {
            this._nonMatchingDictIds = this.calculateNonMatchingDictIds();
        }
        return this._nonMatchingDictIds;
    }

    protected int[] calculateNonMatchingDictIds() {
        return PredicateUtils.flipDictIds(this.getMatchingDictIds(), this._dictionary.length());
    }

    @Override
    public final boolean applySV(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applyMV(long[] values, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applySV(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applyMV(float[] values, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applySV(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applyMV(double[] values, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applySV(BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applySV(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applyMV(String[] values, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applySV(byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean applyMV(byte[][] values, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean applySV(int var1);

    @Override
    public boolean applyMV(int[] dictIds, int length) {
        if (this.isExclusive()) {
            for (int i = 0; i < length; ++i) {
                if (this.applySV(dictIds[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (!this.applySV(dictIds[i])) continue;
            return true;
        }
        return false;
    }
}

